/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.WXPayNotifyBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.WXPayNotifyBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXPayNotifyBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXPayNotifyBusiServiceRspBo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.req.bo.WXApiNotifyReqBO;
import com.tydic.payment.pay.wx.util.Signature;
import com.tydic.payment.pay.wx.util.Util;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.busi.WXPayNotifyBusiService"})
public class WXPayNotifyBusiServiceImpl
implements WXPayNotifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXPayNotifyBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;

    @PostMapping(value={"dealWxPayNotify"})
    public WXPayNotifyBusiServiceRspBo dealWxPayNotify(@RequestBody String reqStr) throws Exception {
        WXPayNotifyBusiServiceRspBo rspBo = new WXPayNotifyBusiServiceRspBo();
        log.info("\u5fae\u4fe1\u76f4\u63a5\u8fd4\u56de\uff0c\u8fdb\u5165\u5fae\u4fe1\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\uff1a" + reqStr);
        if (StringUtils.isEmpty((Object)reqStr)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u8fd4\u56de\u901a\u77e5\u7ed3\u679c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u5185\u5bb9\uff0c\u5904\u7406\u7ed3\u675f\uff01");
        }
        WXApiNotifyReqBO data = (WXApiNotifyReqBO)Util.getObjectFromXMLGeneric((String)reqStr, WXApiNotifyReqBO.class);
        String payOrderId = data.getOut_trade_no();
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setPayOrderId(payOrderId);
        List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
        if (transAtomList == null || transAtomList.isEmpty()) {
            log.info("\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010payOrderId=" + payOrderId + "\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e\uff01");
        }
        Long orderId = transAtomList.get(0).getOrderId();
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (orderInfo == null) {
            log.info("\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e\uff01");
        }
        String payTransStatus = transAtomList.get(0).getOrderStatus();
        String orderStatus2 = orderInfo.getOrderStatus();
        if ("A10".equals(orderStatus2) && "A10".equals(payTransStatus)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        String merchant_id = String.valueOf(orderInfo.getMerchantId());
        String payMethod = String.valueOf(transAtomList.get(0).getPayMethod());
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(merchant_id);
        paraReq.setPayMethod(payMethod);
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            log.info("\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u83b7\u53d6\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        String signkey = "";
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            if (!"signkey".equals(para.getAttrCode())) continue;
            signkey = para.getAttrValue();
            break;
        }
        if (!Signature.checkIsSignValidFromResponseString((String)reqStr, (String)signkey)) {
            log.info("\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u5f02\u6b65\u56de\u8c03\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        if ("SUCCESS".equals(data.getReturn_code())) {
            PorderPayTransAtomReqBo orderPayTransUpdateReq = new PorderPayTransAtomReqBo();
            orderPayTransUpdateReq.setPayOrderId(payOrderId);
            orderPayTransUpdateReq.setOrderId(orderId);
            orderPayTransUpdateReq.setPayNotifyTransId(data.getTransaction_id());
            PorderPo updatePo = new PorderPo();
            updatePo.setOrderId(orderId);
            if (!StringUtils.isEmpty((Object)data.getTime_end())) {
                orderPayTransUpdateReq.setTradeTime(data.getTime_end());
                updatePo.setTradeTime(data.getTime_end());
            } else {
                Date dbDate = this.queryDBDateBusiService.getDBDate();
                String tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
                orderPayTransUpdateReq.setTradeTime(tradeTime);
                updatePo.setTradeTime(tradeTime);
            }
            long totalFee = data.getTotal_fee();
            if (totalFee > 0L) {
                totalFee *= 100L;
            }
            updatePo.setRealFee(totalFee);
            updatePo.setOnlineFee(totalFee);
            updatePo.setTradeTime(data.getTime_end());
            updatePo.setPayNotifyTransId(data.getTransaction_id());
            if ("SUCCESS".equals(data.getResult_code())) {
                orderPayTransUpdateReq.setOrderStatus("A10");
                updatePo.setOrderStatus("A10");
            } else {
                orderPayTransUpdateReq.setOrderStatus("A20");
                updatePo.setOrderStatus("A20");
            }
            this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(orderPayTransUpdateReq);
            this.payOrderAtomService.update(updatePo);
            CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
            callBackNoticeReqBo.setOrderId(orderId);
            CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
            if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                log.info(orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        rspBo.setRespCode("8888");
        rspBo.setRespDesc("\u5931\u8d25");
        return rspBo;
    }

    @PostMapping(value={"dealPayNotifyFromAbility"})
    public WXPayNotifyBusiRspBO dealPayNotifyFromAbility(@RequestBody WXPayNotifyBusiReqBO req) throws Exception {
        WXPayNotifyBusiRspBO rsp = new WXPayNotifyBusiRspBO();
        log.info("\u5fae\u4fe1-\u300b\u80fd\u529b\u5e73\u53f0-\u300b\u652f\u4ed8\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)req));
        if (req == null) {
            log.info("\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u901a\u77e5\u7ed3\u679c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u5185\u5bb9\uff0c\u5904\u7406\u7ed3\u675f\uff01");
            rsp.setReturnCode("8888");
            rsp.setReturnMsg("\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u901a\u77e5\u7ed3\u679c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u5185\u5bb9\uff0c\u5904\u7406\u7ed3\u675f\uff01");
            return rsp;
        }
        log.info("\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u901a\u77e5\u7ed3\u679c\u5185\u5bb9\uff1areq=" + req.toString());
        try {
            JSONObject infoDetail;
            String payOrderId = req.getOutTradeNo();
            if (StringUtils.isEmpty((Object)payOrderId)) {
                log.info("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5outTradeNo\u5165\u53c2\u4e3a\u7a7a");
                rsp.setReturnCode("8888");
                rsp.setReturnMsg("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5outTradeNo\u5165\u53c2\u4e3a\u7a7a");
                return rsp;
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setPayOrderId(payOrderId);
            List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
            if (transAtomList == null || transAtomList.size() <= 0) {
                log.info("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u6839\u636e\u3010payOrderId=" + payOrderId + "\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
                rsp.setReturnCode("8888");
                rsp.setReturnMsg("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u6839\u636e\u3010payOrderId=" + payOrderId + "\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
                return rsp;
            }
            Long orderId = transAtomList.get(0).getOrderId();
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
            if (orderInfo == null) {
                log.info("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
                rsp.setReturnCode("8888");
                rsp.setReturnMsg("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
                return rsp;
            }
            String payTransStatus = transAtomList.get(0).getOrderStatus();
            String orderStatus2 = orderInfo.getOrderStatus();
            if ("A10".equals(orderStatus2) && "A10".equals(payTransStatus)) {
                rsp.setReturnCode("0000");
                rsp.setReturnMsg("\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u72b6\u6001\u5df2\u66f4\u65b0");
                return rsp;
            }
            String merchant_id = String.valueOf(orderInfo.getMerchantId());
            String payMethod = String.valueOf(transAtomList.get(0).getPayMethod());
            QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
            paraReq.setMerchantId(merchant_id);
            paraReq.setPayMethod(payMethod);
            QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
            if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                log.info("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25");
                rsp.setReturnCode("8888");
                rsp.setReturnMsg("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25");
                return rsp;
            }
            if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                log.info("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e");
                rsp.setReturnCode("8888");
                rsp.setReturnMsg("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e");
                return rsp;
            }
            String signkey = "";
            for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
                if (!"signkey".equals(para.getAttrCode())) continue;
                signkey = para.getAttrValue();
                break;
            }
            if (!Signature.checkIsSignValidFromAbilityResponse((JSONObject)(infoDetail = (JSONObject)JSONObject.toJSON((Object)Util.beanToMapUnderlineLowerCase((Object)req))), (String)signkey)) {
                log.info("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
                rsp.setReturnCode("8888");
                rsp.setReturnMsg("\u80fd\u529b\u5e73\u53f0\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e");
                return rsp;
            }
            String return_code = req.getReturnCode();
            String result_code = req.getResultCode();
            String transaction_id = req.getTransactionId();
            if ("SUCCESS".equals(return_code)) {
                PorderPayTransAtomReqBo orderPayTransUpdateReq = new PorderPayTransAtomReqBo();
                orderPayTransUpdateReq.setPayOrderId(payOrderId);
                orderPayTransUpdateReq.setOrderId(orderId);
                orderPayTransUpdateReq.setPayNotifyTransId(transaction_id);
                PorderPo updatePo = new PorderPo();
                updatePo.setOrderId(orderId);
                if (!StringUtils.isEmpty((Object)req.getTimeEnd())) {
                    orderPayTransUpdateReq.setTradeTime(req.getTimeEnd());
                    updatePo.setTradeTime(req.getTimeEnd());
                } else {
                    Date dbDate = this.queryDBDateBusiService.getDBDate();
                    String tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
                    orderPayTransUpdateReq.setTradeTime(tradeTime);
                    updatePo.setTradeTime(tradeTime);
                }
                String totalFee = req.getTotalFee();
                if (!StringUtils.isEmpty((Object)totalFee)) {
                    updatePo.setRealFee(new BigDecimal(totalFee).multiply(new BigDecimal("100")).longValue());
                    updatePo.setOnlineFee(new BigDecimal(totalFee).multiply(new BigDecimal("100")).longValue());
                }
                if ("SUCCESS".equals(result_code)) {
                    orderPayTransUpdateReq.setOrderStatus("A10");
                    updatePo.setOrderStatus("A10");
                } else {
                    orderPayTransUpdateReq.setOrderStatus("A20");
                    updatePo.setOrderStatus("A20");
                }
                this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(orderPayTransUpdateReq);
                this.payOrderAtomService.update(updatePo);
                CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                callBackNoticeReqBo.setOrderId(orderId);
                log.info("\u652f\u4ed8\u4e2d\u5fc3\u5904\u7406\u5b8c\u80fd\u529b\u5e73\u53f0\u7684\u56de\u8c03\u4e4b\u540e\u653e\u5165\u6d88\u606f\u961f\u5217\u7684\u5bf9\u8c61\uff1a" + JSON.toJSONString((Object)callBackNoticeReqBo));
                CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                    log.info(orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                }
                rsp.setReturnCode("0000");
                rsp.setReturnMsg("\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u6210\u529f");
                return rsp;
            }
            rsp.setReturnCode("8888");
            rsp.setReturnMsg("\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u5931\u8d25");
            return rsp;
        }
        catch (Exception e) {
            rsp.setReturnCode("8888");
            rsp.setReturnMsg("\u652f\u4ed8\u7ed3\u679c\u901a\u77e5\u5931\u8d25\uff0c\u5904\u7406\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            return rsp;
        }
    }
}

