/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPageReqPO;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.web.bo.req.PayOrderListQryWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.PayOrderListQryWebRspBo;
import com.tydic.payment.pay.web.service.PayOrderListQryWebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.web.service.PayOrderListQryWebService"})
public class PayOrderListQryWebServiceImpl
implements PayOrderListQryWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayOrderListQryWebServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;

    @PostMapping(value={"qryPayOrderList"})
    public RspPage<PayOrderListQryWebRspBo> qryPayOrderList(@RequestBody PayOrderListQryWebReqBo reqBo) throws Exception {
        List<PorderPo> porderPoList;
        LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        RspPage rspBo = new RspPage();
        ArrayList<PayOrderListQryWebRspBo> payOrderListRspBoList = new ArrayList<PayOrderListQryWebRspBo>();
        rspBo.setRows(payOrderListRspBoList);
        HashSet<Long> orderIdList = new HashSet<Long>();
        PorderPageReqPO porderPo = new PorderPageReqPO();
        if (reqBo.getOutOrderId() != null && !reqBo.getOutOrderId().trim().isEmpty()) {
            OrderQueryConstructionReqBo queryConstructionReqBo = new OrderQueryConstructionReqBo();
            queryConstructionReqBo.setOutOrderId(reqBo.getOutOrderId());
            OrderQueryConstructionRspBo queryConstructionRspBo = this.orderQueryConstructionBusiService.queryConstructionByOutOrderId(queryConstructionReqBo);
            if (queryConstructionRspBo.getOrderId() == null) {
                LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\uff1a\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355\u53f7\u5173\u8054\u7684\u8ba2\u5355\u53f7");
                rspBo.setRecordsTotal(0);
                rspBo.setTotal(0);
                rspBo.setPageNo(1);
                return rspBo;
            }
            reqBo.setOrderId("" + queryConstructionRspBo.getOrderId());
        }
        String payMethod = reqBo.getPayMethod();
        PorderPayTransAtomReqBo payTransAtomReqBo = new PorderPayTransAtomReqBo();
        PorderRefundTransAtomReqBo qryRefundPBo = new PorderRefundTransAtomReqBo();
        if (!StringUtils.isEmpty((Object)payMethod)) {
            payTransAtomReqBo.setPayMethod(Long.parseLong(reqBo.getPayMethod()));
            qryRefundPBo.setPayMethod(Long.parseLong(reqBo.getPayMethod()));
        }
        if (reqBo.getOrderId() != null && !reqBo.getOrderId().trim().isEmpty()) {
            payTransAtomReqBo.setOrderId(Long.parseLong(reqBo.getOrderId()));
            qryRefundPBo.setOrderId(Long.parseLong(reqBo.getOrderId()));
        }
        List<PorderPayTransAtomRspBo> payTransAtomRspBos = this.porderPayTransAtomService.queryOrderPayTransByCondition(payTransAtomReqBo);
        List<PorderRefundTransAtomRspBo> porderRefundTransAtomRspBos = this.porderRefundTransAtomService.queryOrderRefundTransByCondition(qryRefundPBo);
        String orderStatus2 = reqBo.getOrderStatus();
        if (payTransAtomRspBos.isEmpty() && porderRefundTransAtomRspBos.isEmpty()) {
            LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\uff1a\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784\u4e0b\u7684\u8ba2\u5355");
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setPageNo(1);
            return rspBo;
        }
        for (PorderPayTransAtomRspBo transPo : payTransAtomRspBos) {
            orderIdList.add(transPo.getOrderId());
        }
        for (PorderRefundTransAtomRspBo tpo : porderRefundTransAtomRspBos) {
            orderIdList.add(tpo.getOrderId());
        }
        Date dateEnd = null;
        Long payFeeLess = null;
        Long payFeeMore = null;
        try {
            if (reqBo.getPayFeeLess() != null && !reqBo.getPayFeeLess().trim().isEmpty()) {
                payFeeLess = MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(reqBo.getPayFeeLess()));
            }
            if (reqBo.getPayFeeMore() != null && !reqBo.getPayFeeMore().trim().isEmpty()) {
                payFeeMore = MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(reqBo.getPayFeeMore()));
            }
        }
        catch (Exception e) {
            LOGGER.error("BigDecimal2Long\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateBegin())) {
            porderPo.setCreateTime(new DateTime((Object)reqBo.getDateBegin()).toDate());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateEnd())) {
            dateEnd = new DateTime((Object)reqBo.getDateEnd()).plusDays(1).withMillisOfDay(0).toDate();
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            porderPo.setOrderId(Long.parseLong(reqBo.getOrderId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            porderPo.setBusiId(Long.parseLong(reqBo.getBusiId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOrderStatus())) {
            porderPo.setOrderStatus(reqBo.getOrderStatus());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            porderPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        String isQryRefund = reqBo.getIsQryRefund();
        if (!StringUtils.isEmpty((Object)isQryRefund) && "1".equals(isQryRefund)) {
            porderPo.setRefundFee(0L);
        }
        if ((porderPoList = this.payOrderAtomService.queryPorderByCondition((Page<PorderPageReqPO>)page, porderPo, dateEnd, payFeeLess, payFeeMore, orderIdList)).isEmpty()) {
            LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\uff1a\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setPageNo(1);
            return rspBo;
        }
        for (PorderPo po : porderPoList) {
            PayOrderListQryWebRspBo pmcPayOrderListQryRspBo = new PayOrderListQryWebRspBo();
            BeanUtils.copyProperties((Object)po, (Object)pmcPayOrderListQryRspBo);
            if (reqBo.getPayMethod() == null || reqBo.getPayMethod().trim().isEmpty()) {
                PorderPayTransPo transPo = new PorderPayTransPo();
                transPo.setOrderId(po.getOrderId());
                List<PorderPayTransPo> transPos = this.porderPayTransAtomService.queryOrderPayTrans(transPo);
                if (!transPos.isEmpty()) {
                    pmcPayOrderListQryRspBo.setPayMethod("" + transPos.get(0).getPayMethod());
                }
            } else {
                pmcPayOrderListQryRspBo.setPayMethod(reqBo.getPayMethod());
            }
            if (pmcPayOrderListQryRspBo.getPayMethod() != null && !pmcPayOrderListQryRspBo.getPayMethod().trim().isEmpty()) {
                PayMethodPo methodPo = new PayMethodPo();
                methodPo.setPayMethod(Long.parseLong(pmcPayOrderListQryRspBo.getPayMethod()));
                List<PayMethodPo> payMethodPos = this.payMethodAtomService.queryPayMethod(methodPo);
                if (!payMethodPos.isEmpty()) {
                    pmcPayOrderListQryRspBo.setPayMethod(payMethodPos.get(0).getPayMethodName());
                }
            }
            if (po.getMerchantId() != null) {
                pmcPayOrderListQryRspBo.setMerchantId(po.getMerchantId().toString());
            }
            if (po.getOrderId() != null) {
                pmcPayOrderListQryRspBo.setOrderId("" + po.getOrderId());
            }
            if (po.getBusiId() != null) {
                BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
                busiSystemInfoPO.setBusiId(po.getBusiId());
                List<BusiSystemInfoPO> busiSystemInfoPOS = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
                if (!busiSystemInfoPOS.isEmpty()) {
                    pmcPayOrderListQryRspBo.setBusiId(busiSystemInfoPOS.get(0).getBusiName());
                }
            }
            pmcPayOrderListQryRspBo.setCreateTime(new DateTime((Object)po.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            try {
                if (po.getRealFee() != null) {
                    pmcPayOrderListQryRspBo.setRealFee("" + MoneyUtils.haoToFen((Long)po.getRealFee()));
                }
                if (po.getTotalFee() != null) {
                    pmcPayOrderListQryRspBo.setTotalFee("" + MoneyUtils.haoToFen((Long)po.getTotalFee()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            QueryPCodeInfoReqBO bo = new QueryPCodeInfoReqBO();
            bo.setCodeValue(pmcPayOrderListQryRspBo.getOrderStatus());
            bo.setTypeCode("P_ORDER_ORDER_STATUS");
            pmcPayOrderListQryRspBo.setOrderStatus(this.queryPCodeInfoService.queryPCodeInfo(bo).getCodeInfo());
            bo.setCodeValue(pmcPayOrderListQryRspBo.getOrderType());
            bo.setTypeCode("P_ORDER_ORDER_TYPE");
            pmcPayOrderListQryRspBo.setOrderType(this.queryPCodeInfoService.queryPCodeInfo(bo).getCodeInfo());
            payOrderListRspBoList.add(pmcPayOrderListQryRspBo);
        }
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void validateArg(PayOrderListQryWebReqBo reqBo) {
        if (reqBo == null) {
            reqBo = new PayOrderListQryWebReqBo();
        }
    }
}

