/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.executor;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.able.BillDownAndTransAble;
import com.tydic.payment.bill.able.BillFile;
import com.tydic.payment.bill.able.BillFileInfo;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.executor.BillDownAndTrans;
import com.tydic.payment.bill.util.BillFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractBillDownAndTrans
implements BillDownAndTrans,
ApplicationContextAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;

    @Override
    public void doDownAndTrans(BillExecuteRequest request) throws BillDownAndTransException {
        BillDownAndTransAble able = this.getBillDownAndTransAble(request);
        BillFileInfo billFileInfo = able.doDown(request);
        this.setBillFileInfo(billFileInfo);
        able.doTrans(billFileInfo);
        this.closeInputStream(billFileInfo);
    }

    private void closeInputStream(BillFileInfo billFileInfo) {
        for (BillFile billFile : billFileInfo.getBillFileList()) {
            BillFileUtils.closeInputStream(billFile.getInputStream());
        }
    }

    protected abstract BillDownAndTransAble getBillDownAndTransAble(BillExecuteRequest var1) throws BillDownAndTransException;

    private void setBillFileInfo(BillFileInfo billFileInfo) throws BillDownAndTransException {
    }

    @Override
    public void doDownAndTransClean(BillExecuteRequest request) throws BillDownAndTransException {
        BillDownAndTransAble able = this.getBillDownAndTransAble(request);
        able.doDownAndTransClean(request);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

