/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProAbleQueryRefundStatusAbilityService;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryRefundStatusAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryRefundStatusAbilityRspBo;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.PayAbleQryRefundStatusCombService;
import com.tydic.payment.pay.comb.bo.PayAbleQryRefundStatusCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleQryRefundStatusCombRspBo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.icbc.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.ability.PayProAbleQueryRefundStatusAbilityService"})
public class PayProAbleQueryRefundStatusAbilityServiceImpl
implements PayProAbleQueryRefundStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProAbleQueryRefundStatusAbilityServiceImpl.class);
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private PayAbleQryRefundStatusCombService payAbleQryRefundStatusCombService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    @PostMapping(value={"queryRefundStatus"})
    public PayProAbleQueryRefundStatusAbilityRspBo queryRefundStatus(@RequestBody PayProAbleQueryRefundStatusAbilityReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u9000\u6b3e\u72b6\u6001Ability\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        PayProAbleQueryRefundStatusAbilityRspBo retBo = new PayProAbleQueryRefundStatusAbilityRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            retBo.setRespCode("214032");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214032");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214032");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        Long busiId = busiCodeRspBo.getBusiId();
        PayProOrderQueryBusiReqBo qryOrderBo = new PayProOrderQueryBusiReqBo();
        qryOrderBo.setBusiId(busiId);
        qryOrderBo.setOutOrderId(reqBo.getOriOrderId());
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo qryOrderBoRetBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(qryOrderBo);
        if (!"0000".equals(qryOrderBoRetBo.getRespCode())) {
            retBo.setRespCode("214032");
            retBo.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + qryOrderBoRetBo.getRespDesc());
            return retBo;
        }
        PayAbleQryRefundStatusCombReqBo combReqBo = new PayAbleQryRefundStatusCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        combReqBo.setOrderId(qryOrderBoRetBo.getOrderId());
        PayAbleQryRefundStatusCombRspBo combRetBo = this.payAbleQryRefundStatusCombService.queryRefundStatus(combReqBo);
        if (!"0000".equals(combRetBo.getRespCode())) {
            retBo.setRespCode("214032");
            retBo.setRespDesc(combRetBo.getRespDesc());
            return retBo;
        }
        this.assignment(combRetBo, retBo);
        return retBo;
    }

    private void assignment(PayAbleQryRefundStatusCombRspBo combRetBo, PayProAbleQueryRefundStatusAbilityRspBo retBo) {
        MerChantInfoPo merChantInfo;
        BeanUtils.copyProperties((Object)combRetBo, (Object)retBo);
        retBo.setOrderId(combRetBo.getOrderId() != null ? combRetBo.getOrderId() + "" : null);
        Long merchantId = combRetBo.getMerchantId();
        Long payMethod = combRetBo.getPayMethod();
        if (null != payMethod) {
            PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(payMethod);
            if (null != methodInfo) {
                retBo.setPayMethod(payMethod.toString());
                retBo.setPayMethodName(methodInfo.getPayMethodName());
            }
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
            List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (!CollectionUtils.isEmpty(paymentInsList)) {
                PaymentInsPo paymentInsInfo = paymentInsList.get(0);
                retBo.setPaymentInsId(paymentInsInfo.getPaymentInsId().toString());
                retBo.setPaymentInsName(paymentInsInfo.getPaymentInsName());
            }
        }
        if (null != merchantId && null != (merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId))) {
            retBo.setMerchantId(merchantId.toString());
            retBo.setMerchantName(merChantInfo.getMerchantName());
        }
    }

    private String validateArgs(PayProAbleQueryRefundStatusAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[busiCode]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)reqBo.getOriOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[oriOrderId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

