/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.ability.PayProQueryBillListAbilityService;
import com.tydic.payment.pay.ability.bo.PayProQueryBillResultReqBo;
import com.tydic.payment.pay.ability.bo.PayProQueryBillResultRspBo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PaySettleTransMapper;
import com.tydic.payment.pay.dao.po.PaySettleTransPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.ability.PayProQueryBillListAbilityService"})
public class PayProQueryBillListAbilityServiceImpl
implements PayProQueryBillListAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PaySettleTransMapper paySettleTransMapper;
    private static final String FILED_SPLIT = ",";
    public static final String BILL_RESULT_FILE_PATH = "payCenter/billResultFiles/";
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private FileClient fileClient;

    @PostMapping(value={"queryBill"})
    public PayProQueryBillResultRspBo queryBill(@RequestBody PayProQueryBillResultReqBo reqBo) {
        PayProQueryBillResultRspBo rspBo = PayProRspUtil.generateSucRspBo(PayProQueryBillResultRspBo.class);
        this.validate(reqBo);
        Boolean downloadedFile = reqBo.getDownloadedFile();
        PaySettleTransPO qryPo = new PaySettleTransPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        qryPo.setOrderBy("t.TRADE_TIME");
        StringBuilder resultSb = new StringBuilder();
        String createDate = new DateTime((Object)this.payMethodMapper.getDBDate().getDate()).toString("yyyyMMdd");
        try {
            List<PaySettleTransPO> settleList = this.paySettleTransMapper.getList(qryPo);
            if (CollUtil.isEmpty(settleList)) {
                rspBo.setRespDesc("\u65e5\u671f(" + reqBo.getBillDate() + ")\u8d26\u5355\u4e0b\u8f7d\u5931\u8d25\uff0c\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5bf9\u8d26\u662f\u5426\u5b8c\u6210");
                rspBo.setRespCode("214031");
                return rspBo;
            }
            if (downloadedFile.booleanValue()) {
                this.appendHead(resultSb, createDate, settleList.size(), rspBo);
            }
            this.resolvedData(settleList, resultSb, createDate, rspBo, reqBo);
            if (downloadedFile.booleanValue()) {
                String busiCode = reqBo.getBusiCode();
                String fileName = reqBo.getBillDate() + "-" + (StrUtil.isEmpty((CharSequence)busiCode) ? reqBo.getMerchantId() : busiCode) + ".data";
                ByteArrayInputStream inputStream = new ByteArrayInputStream(resultSb.toString().getBytes(StandardCharsets.UTF_8));
                String uploadResult = this.fileClient.uploadFileByInputStream(BILL_RESULT_FILE_PATH, fileName, (InputStream)inputStream);
                rspBo.setDownloadUrl(uploadResult);
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u5bf9\u8d26\u6570\u636e\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rspBo.setRespDesc("\u5bf9\u8d26\u6570\u636e\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            rspBo.setRespCode("214031");
        }
        return rspBo;
    }

    private void resolvedData(List<PaySettleTransPO> settleList, StringBuilder resultSb, String createDate, PayProQueryBillResultRspBo rspBo, PayProQueryBillResultReqBo reqBo) {
        if (!CollUtil.isEmpty(settleList)) {
            int listSize = settleList.size();
            for (int i = 0; i < listSize; ++i) {
                PaySettleTransPO trans = settleList.get(i);
                StringBuilder innerSb = new StringBuilder();
                innerSb.append(createDate);
                innerSb.append(FILED_SPLIT);
                innerSb.append(trans.getOrderId());
                innerSb.append(FILED_SPLIT);
                innerSb.append(trans.getBusiId());
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getOrderType()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(trans.getPayMethod());
                innerSb.append(FILED_SPLIT);
                innerSb.append(trans.getOutOrderId());
                innerSb.append(FILED_SPLIT);
                innerSb.append(trans.getRealFee());
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getRefundNo()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getProvinceId()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getCityId()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getDistrictId()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getChannelId()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getCreateOperId()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getTradeTime()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(trans.getMerchantId());
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getUserAccount()));
                innerSb.append(FILED_SPLIT);
                innerSb.append(this.convertNullString(trans.getUserMobile()));
                if (i != listSize - 1 && reqBo.getDownloadedFile().booleanValue()) {
                    innerSb.append("\n");
                }
                if (reqBo.getDownloadedFile().booleanValue()) {
                    resultSb.append(innerSb.toString());
                    continue;
                }
                rspBo.getResultData().add(innerSb.toString());
            }
        }
    }

    private void appendHead(StringBuilder sb, String createDate, int size, PayProQueryBillResultRspBo rspBo) {
        sb.append(0);
        sb.append(FILED_SPLIT);
        sb.append(size);
        sb.append(FILED_SPLIT);
        sb.append(createDate);
        sb.append("000000");
        sb.append(FILED_SPLIT);
        sb.append(createDate);
        sb.append("235959");
        sb.append(FILED_SPLIT);
        sb.append(1);
        sb.append("\n");
        sb.append(rspBo.getHeadDesc());
        sb.append("\n");
        sb.append("-------------------------------------------------data begin----------------------------------------------");
        sb.append("\n");
    }

    private String convertNullString(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return "";
        }
        if ("null".equals(value.trim())) {
            return "";
        }
        return value;
    }

    private String convertNullLong(Long value) {
        if (null == value) {
            return "0";
        }
        return value.toString();
    }

    private void validate(PayProQueryBillResultReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("218010", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBillDate() == null || reqBo.getBillDate() == 0L) {
            throw new BusinessException("218010", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[billDate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)reqBo.getBusiCode()) && reqBo.getMerchantId() == null) {
            throw new BusinessException("218010", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[busiCode]\u548c[merchantId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

