/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProRelPayParaAbilityService;
import com.tydic.payment.pay.ability.bo.PayProMerchantPayInsDataBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaReqBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaRspBo;
import com.tydic.payment.pay.busi.PayProBillCheckConfigBusiService;
import com.tydic.payment.pay.busi.PayProRelPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayProBillCheckConfigBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProBillCheckConfigBusiRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.ability.PayProRelPayParaAbilityService"})
public class PayProRelPayParaAbilityServiceImpl
implements PayProRelPayParaAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProRelPayParaAbilityServiceImpl.class);
    @Autowired
    private PayProRelPayParaBusiService payProRelPayParaBusiService;
    @Autowired
    private PayProBillCheckConfigBusiService payProBillCheckConfigBusiService;

    @PostMapping(value={"addRelPayPara"})
    public PayProRelPayParaRspBo addRelPayPara(@RequestBody PayProRelPayParaReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u65b0\u589e\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        this.validateArgs(reqBo);
        PayProRelPayParaRspBo retBo = this.payProRelPayParaBusiService.addRelPayPara(reqBo);
        if (!"0000".equals(retBo.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u65b0\u589e\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
            }
            return retBo;
        }
        PayProBillCheckConfigBusiReqBo billConfigReqBo = new PayProBillCheckConfigBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)billConfigReqBo);
        PayProBillCheckConfigBusiRspBo billConfigRetBo = this.payProBillCheckConfigBusiService.addBillConfig(billConfigReqBo);
        BeanUtils.copyProperties((Object)billConfigRetBo, (Object)retBo);
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u65b0\u589e\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    @PostMapping(value={"updateRelPayPara"})
    public PayProRelPayParaRspBo updateRelPayPara(@RequestBody PayProRelPayParaReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u4fee\u6539\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        this.validateArgs(reqBo);
        PayProRelPayParaRspBo retBo = this.payProRelPayParaBusiService.updateRelPayPara(reqBo);
        if (!"0000".equals(retBo.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u4fee\u6539\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
            }
            return retBo;
        }
        PayProBillCheckConfigBusiReqBo billConfigReqBo = new PayProBillCheckConfigBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)billConfigReqBo);
        PayProBillCheckConfigBusiRspBo billConfigRetBo = this.payProBillCheckConfigBusiService.updateBillConfig(billConfigReqBo);
        BeanUtils.copyProperties((Object)billConfigRetBo, (Object)retBo);
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u4fee\u6539\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    @PostMapping(value={"deleteRelPayPara"})
    public PayProRelPayParaRspBo deleteRelPayPara(@RequestBody PayProRelPayParaReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5220\u9664\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        this.validateBaseArgs(reqBo);
        PayProRelPayParaRspBo retBo = this.payProRelPayParaBusiService.deleteRelPayPara(reqBo);
        if (!"0000".equals(retBo.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u5220\u9664\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
            }
            return retBo;
        }
        PayProBillCheckConfigBusiReqBo billConfigReqBo = new PayProBillCheckConfigBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)billConfigReqBo);
        PayProBillCheckConfigBusiRspBo billConfigRetBo = this.payProBillCheckConfigBusiService.deleteBillConfig(billConfigReqBo);
        BeanUtils.copyProperties((Object)billConfigRetBo, (Object)retBo);
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u5173\u8054\u652f\u4ed8\u914d\u7f6e\u4fee\u6539\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private void validateBaseArgs(PayProRelPayParaReqBo reqBo) {
        if (null == reqBo) {
            throw new BusinessException("218023", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            throw new BusinessException("218023", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[merchantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getPaymentIns())) {
            throw new BusinessException("218023", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[paymentIns]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPaymentIns().getPaymentInsId() || 0L == reqBo.getPaymentIns().getPaymentInsId()) {
            throw new BusinessException("218023", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[paymentInsId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgs(PayProRelPayParaReqBo reqBo) {
        this.validateBaseArgs(reqBo);
        PayProMerchantPayInsDataBo paymentIns = reqBo.getPaymentIns();
        if (CollectionUtils.isEmpty((Collection)paymentIns.getPayMethodList())) {
            throw new BusinessException("218023", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payMethodList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((PayProConstants.PayMethod.CASH_PAY.equals(paymentIns.getPaymentInsId()) || PayProConstants.PayMethod.BEST_PAY.equals(paymentIns.getPaymentInsId())) && CollectionUtils.isEmpty((Collection)paymentIns.getPayParaList())) {
            throw new BusinessException("218023", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payParaList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

