/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.AliHbfqQueryPayFeeBusiService;
import com.tydic.payment.pay.busi.bo.AliHbfqQueryPayFeeBusiBo;
import com.tydic.payment.pay.busi.bo.AliHbfqQueryPayFeeBusiReqBo;
import com.tydic.payment.pay.busi.bo.AliHbfqQueryPayFeeBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.busi.AliHbfqQueryPayFeeBusiService"})
public class AliHbfqQueryPayFeeBusiServiceImpl
implements AliHbfqQueryPayFeeBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliHbfqQueryPayFeeBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    @PostMapping(value={"dealQueryHbfqPayFee"})
    public AliHbfqQueryPayFeeBusiRspBo dealQueryHbfqPayFee(@RequestBody AliHbfqQueryPayFeeBusiReqBo reqBo) {
        AliHbfqQueryPayFeeBusiRspBo rspBo = new AliHbfqQueryPayFeeBusiRspBo();
        ArrayList<AliHbfqQueryPayFeeBusiBo> hbfqList = new ArrayList<AliHbfqQueryPayFeeBusiBo>();
        rspBo.setHbfqList(hbfqList);
        rspBo.setRspCode("8888");
        rspBo.setRspName("\u5931\u8d25");
        if (reqBo == null) {
            rspBo.setRspName("\u8ba1\u7b97\u82b1\u5457\u5206\u671f\u624b\u7eed\u8d39\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (StringUtils.isEmpty((String)reqBo.getOrderId())) {
            rspBo.setRspName("\u8ba1\u7b97\u82b1\u5457\u5206\u671f\u624b\u7eed\u8d39\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(StringUtils.isEmpty((String)reqBo.getHbfqNum()) || reqBo.getHbfqNum().equals("3") || reqBo.getHbfqNum().equals("6") || reqBo.getHbfqNum().equals("12"))) {
            rspBo.setRspName("\u8ba1\u7b97\u82b1\u5457\u5206\u671f\u624b\u7eed\u8d39\u5165\u53c2hbfqNum(\u82b1\u5457\u5206\u671f\u6570)\u53ea\u80fd\u4f20\u51653\u62166\u621612");
        }
        if (!(StringUtils.isEmpty((String)reqBo.getHbfqSellerPercent()) || reqBo.getHbfqSellerPercent().equals("100") || reqBo.getHbfqSellerPercent().equals("0"))) {
            rspBo.setRspName("\u8ba1\u7b97\u82b1\u5457\u5206\u671f\u624b\u7eed\u8d39\u5165\u53c2hbfqSellerPercent(\u627f\u62c5\u624b\u7eed\u8d39\u6bd4\u4f8b)\u53ea\u80fd\u4f20\u5165100\u62160");
        }
        try {
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(reqBo.getOrderId()));
            if (orderInfo == null) {
                rspBo.setRspName("\u8ba1\u7b97\u82b1\u5457\u5206\u671f\u624b\u7eed\u8d39\u6839\u636e\u3010ORDER_ID=" + reqBo.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
                return rspBo;
            }
            if (!"A00".equals(orderInfo.getOrderStatus())) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u8be5\u8ba2\u5355\u3010" + reqBo.getOrderId() + "\u3011\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u65e0\u6cd5\u8ba1\u7b97\u82b1\u5457\u5206\u671f\u624b\u7eed\u8d39");
                return rspBo;
            }
            PorderPayTransAtomRspBo porderPayTransAtomRspBo = this.porderPayTransAtomService.queryLastRecordByOrderId(Long.valueOf(reqBo.getOrderId()));
            if (porderPayTransAtomRspBo != null && !"A00".equals(porderPayTransAtomRspBo.getOrderStatus())) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u8be5\u8ba2\u5355\u3010" + reqBo.getOrderId() + "\u3011\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u65e0\u6cd5\u8ba1\u7b97\u82b1\u5457\u5206\u671f\u624b\u7eed\u8d39");
                return rspBo;
            }
            Long totalFee = orderInfo.getTotalFee();
            BigDecimal totalFeeB = MoneyUtils.haoToFen((Long)totalFee);
            if (!StringUtils.isEmpty((String)reqBo.getHbfqSellerPercent())) {
                if (!StringUtils.isEmpty((String)reqBo.getHbfqNum())) {
                    AliHbfqQueryPayFeeBusiBo queryPayFee1 = this.calculateFee(reqBo.getHbfqSellerPercent(), reqBo.getHbfqNum(), totalFeeB);
                    hbfqList.add(queryPayFee1);
                    rspBo.setRspCode("0000");
                    rspBo.setRspName("\u6210\u529f");
                    return rspBo;
                }
                AliHbfqQueryPayFeeBusiBo queryPayFee1 = this.calculateFee(reqBo.getHbfqSellerPercent(), "3", totalFeeB);
                hbfqList.add(queryPayFee1);
                AliHbfqQueryPayFeeBusiBo queryPayFee2 = this.calculateFee(reqBo.getHbfqSellerPercent(), "6", totalFeeB);
                hbfqList.add(queryPayFee2);
                AliHbfqQueryPayFeeBusiBo queryPayFee3 = this.calculateFee(reqBo.getHbfqSellerPercent(), "12", totalFeeB);
                hbfqList.add(queryPayFee3);
                rspBo.setRspCode("0000");
                rspBo.setRspName("\u6210\u529f");
                return rspBo;
            }
            if (!StringUtils.isEmpty((String)reqBo.getHbfqNum())) {
                AliHbfqQueryPayFeeBusiBo queryPayFee1 = this.calculateFee("100", reqBo.getHbfqNum(), totalFeeB);
                hbfqList.add(queryPayFee1);
                AliHbfqQueryPayFeeBusiBo queryPayFee2 = this.calculateFee("0", reqBo.getHbfqNum(), totalFeeB);
                hbfqList.add(queryPayFee2);
                rspBo.setRspCode("0000");
                rspBo.setRspName("\u6210\u529f");
                return rspBo;
            }
            AliHbfqQueryPayFeeBusiBo queryPayFee1 = this.calculateFee("0", "3", totalFeeB);
            hbfqList.add(queryPayFee1);
            AliHbfqQueryPayFeeBusiBo queryPayFee2 = this.calculateFee("0", "6", totalFeeB);
            hbfqList.add(queryPayFee2);
            AliHbfqQueryPayFeeBusiBo queryPayFee3 = this.calculateFee("0", "12", totalFeeB);
            hbfqList.add(queryPayFee3);
            AliHbfqQueryPayFeeBusiBo queryPayFee4 = this.calculateFee("100", "3", totalFeeB);
            hbfqList.add(queryPayFee4);
            AliHbfqQueryPayFeeBusiBo queryPayFee5 = this.calculateFee("100", "6", totalFeeB);
            hbfqList.add(queryPayFee5);
            AliHbfqQueryPayFeeBusiBo queryPayFee6 = this.calculateFee("100", "12", totalFeeB);
            hbfqList.add(queryPayFee6);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u6210\u529f");
            return rspBo;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return rspBo;
        }
    }

    private AliHbfqQueryPayFeeBusiBo calculateFee(String hbfqSellerPercent, String hbfqNum, BigDecimal totalFeeB) {
        AliHbfqQueryPayFeeBusiBo tmpPayFeeBo = new AliHbfqQueryPayFeeBusiBo();
        tmpPayFeeBo.setHbfqNum(hbfqNum);
        if (hbfqSellerPercent.equals("100")) {
            tmpPayFeeBo.setHbfqSeller("merchant");
        } else if (hbfqSellerPercent.equals("0")) {
            tmpPayFeeBo.setHbfqSeller("user");
        }
        BigDecimal eachPrin = totalFeeB.divide(new BigDecimal(hbfqNum), 1);
        BigDecimal rate = this.queryHbfqRate(hbfqSellerPercent, hbfqNum);
        if (rate != null) {
            tmpPayFeeBo.setRate(rate.toPlainString());
        }
        BigDecimal totalFeeInDecimal = totalFeeB.multiply(rate);
        long totalFeeInLong = totalFeeInDecimal.setScale(0, 6).longValue();
        BigDecimal eachFee = BigDecimal.valueOf(totalFeeInLong).divide(new BigDecimal(hbfqNum), 1);
        tmpPayFeeBo.setServiceCharge(eachFee.toPlainString());
        BigDecimal prinAndFee = eachFee.add(eachPrin);
        BigDecimal prinAndFeeInYuan = prinAndFee.divide(new BigDecimal("100"));
        tmpPayFeeBo.setPayFeePer(prinAndFeeInYuan.toPlainString());
        return tmpPayFeeBo;
    }

    private BigDecimal queryHbfqRate(String hbfqSellerPercent, String hbfqNum) {
        BigDecimal rateB = null;
        if (hbfqSellerPercent.equals("100")) {
            if (hbfqNum.equals("3")) {
                double rate = 0.018;
                rateB = BigDecimal.valueOf(rate);
                return rateB;
            }
            if (hbfqNum.equals("6")) {
                double rate = 0.045;
                rateB = BigDecimal.valueOf(rate);
                return rateB;
            }
            if (hbfqNum.equals("12")) {
                double rate = 0.075;
                rateB = BigDecimal.valueOf(rate);
                return rateB;
            }
        } else if (hbfqSellerPercent.equals("0")) {
            if (hbfqNum.equals("3")) {
                double rate = 0.023;
                rateB = BigDecimal.valueOf(rate);
                return rateB;
            }
            if (hbfqNum.equals("6")) {
                double rate = 0.045;
                rateB = BigDecimal.valueOf(rate);
                return rateB;
            }
            if (hbfqNum.equals("12")) {
                double rate = 0.075;
                rateB = BigDecimal.valueOf(rate);
                return rateB;
            }
        }
        return rateB;
    }
}

