/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.BusiSystemMerchantRelAtomService;
import com.tydic.payment.pay.atom.InfoStoreAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.InfoStorePageReqPO;
import com.tydic.payment.pay.dao.po.InfoStorePo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.web.bo.InfoStoreBoStr;
import com.tydic.payment.pay.web.bo.req.InfoStoreQueryWebReqBo;
import com.tydic.payment.pay.web.service.InfoStoreQueryWebService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.web.service.InfoStoreQueryWebService"})
public class InfoStoreQueryWebServiceImpl
implements InfoStoreQueryWebService {
    private static final Logger log = LoggerFactory.getLogger(InfoStoreQueryWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private InfoStoreAtomService infoStoreAtomService;
    @Autowired
    private BusiSystemMerchantRelAtomService busiSystemMerchantRelAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;

    @PostMapping(value={"queryInfoStoreWithPage"})
    public RspPage<InfoStoreBoStr> queryInfoStoreWithPage(@RequestBody InfoStoreQueryWebReqBo reqBo) {
        log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        RspPage rspBo = new RspPage();
        ArrayList<InfoStoreBoStr> storeBoList = new ArrayList<InfoStoreBoStr>();
        rspBo.setRows(storeBoList);
        if (reqBo == null) {
            reqBo = new InfoStoreQueryWebReqBo();
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            MerChantInfoPo merpo = new MerChantInfoPo();
            merpo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
            List<MerChantInfoPo> merList = this.merchantInfoAtomService.queryMerChantInfoByCondition(merpo);
            if (CollectionUtils.isEmpty(merList)) {
                log.info("\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u5546\u6237ID -> " + reqBo.getMerchantId());
                rspBo.setPageNo(0);
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                return rspBo;
            }
            String merchantName = merList.get(0).getMerchantName();
            InfoStorePageReqPO storePo = new InfoStorePageReqPO();
            storePo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
            if (!StringUtils.isEmpty((Object)reqBo.getStoreName())) {
                storePo.setStoreName(reqBo.getStoreName());
            }
            log.info("\u67e5\u8be2\u5e97\u94faPO:" + JSON.toJSONString((Object)((Object)storePo)));
            List<InfoStorePo> list = this.infoStoreAtomService.queryInfoStoreWithPage((Page<InfoStorePageReqPO>)page, storePo);
            if (list == null || list.isEmpty()) {
                log.info("\u5e97\u94fa\u67e5\u8be2\u6210\u529f\uff0c\u8be5\u5546\u6237ID\u7684\u5e97\u94fa\u5217\u8868\u4e3a\u7a7a,\u5546\u6237ID - > " + reqBo.getMerchantId());
                rspBo.setPageNo(0);
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                return rspBo;
            }
            this.afterCopy(list, storeBoList, merchantName);
            rspBo.setPageNo(page.getPageNo());
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            return rspBo;
        }
        List<Object> merIdList = new ArrayList();
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            BusiSystemMerchantRelPo bmPo = new BusiSystemMerchantRelPo();
            merIdList = this.busiSystemMerchantRelAtomService.queryMerchantIdRelBusiSystem(bmPo);
            if (merIdList == null || merIdList.isEmpty()) {
                log.info("\u5e97\u94fa\u67e5\u8be2\u6210\u529f\uff0c\u5546\u6237ID\u4e3a\u7a7a\uff0c\u4e1a\u52a1\u7cfb\u7edf-\u5546\u6237\u5173\u7cfb\u8868\u4e3a\u7a7a");
                rspBo.setPageNo(0);
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                return rspBo;
            }
        } else {
            BusiSystemInfoPO busiIsExit = this.busiSystemInfoAtomService.queryBusiSystemInfoById(Long.valueOf(reqBo.getBusiId()));
            if (busiIsExit == null) {
                log.info("\u5e97\u94fa\u67e5\u8be2\u5931\u8d25\uff0c\u8be5\u4e1a\u52a1\u7cfb\u7edf\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u4e1a\u52a1\u7cfb\u7edfID -> " + reqBo.getBusiId());
                rspBo.setPageNo(0);
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                return rspBo;
            }
            BusiSystemMerchantRelPo bmPo = new BusiSystemMerchantRelPo();
            bmPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
            merIdList = this.busiSystemMerchantRelAtomService.queryMerchantIdRelBusiSystem(bmPo);
            if (CollectionUtils.isEmpty(merIdList)) {
                log.info("\u5e97\u94fa\u67e5\u8be2\u6210\u529f\uff0c\u5546\u6237ID\u4e3a\u7a7a\uff0c\u8be5\u4e1a\u52a1\u7cfb\u7edf\u6ca1\u6709\u5173\u8054\u7684\u5546\u6237");
                rspBo.setPageNo(0);
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                return rspBo;
            }
        }
        log.info("\u67e5\u8be2\u51fa\u7684\u5546\u6237ID\u6709\uff1a" + JSON.toJSONString(merIdList));
        HashMap<String, MerChantInfoPo> merDetailMap = new HashMap<String, MerChantInfoPo>();
        ArrayList<String> vaMerIdL = new ArrayList<String>();
        for (String string : merIdList) {
            MerChantInfoPo qryMerPo = new MerChantInfoPo();
            if (StringUtils.isEmpty((Object)string)) continue;
            MerChantInfoPo merL = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(string));
            if (merL == null) {
                log.info("\u67e5\u8be2\u5931\u8d25\uff0c\u4e1a\u52a1\u7cfb\u7edf\u5173\u8054\u7684\u5546\u6237ID\u5728\u5546\u6237\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u4e1a\u52a1\u7cfb\u7edf\u5173\u8054\u5546\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5b58\u5728\u810f\u6570\u636e\uff1amerchantId\u4e3a" + qryMerPo.getMerchantId());
                continue;
            }
            String reMerId = merL.getMerchantId().toString();
            merDetailMap.put(reMerId, merL);
            vaMerIdL.add(merL.getMerchantId().toString());
        }
        InfoStorePageReqPO infoStorePo = new InfoStorePageReqPO();
        this.beforeCopy(reqBo, infoStorePo);
        List<InfoStorePo> list = this.infoStoreAtomService.queryStoreOfMerchantWithPage((Page<InfoStorePageReqPO>)page, infoStorePo, vaMerIdL);
        log.info("\u67e5\u8be2\u5546\u6237\u6240\u6709\u95e8\u5e97\u7684list\u6709\uff1a" + JSON.toJSONString(list));
        for (InfoStorePo temp : list) {
            InfoStoreBoStr storeBo = new InfoStoreBoStr();
            BeanUtils.copyProperties((Object)temp, (Object)storeBo);
            if (temp.getMerchantId() != null) {
                String merchantId = temp.getMerchantId().toString();
                storeBo.setMerchantId(merchantId);
                storeBo.setMerchantName(merDetailMap.get(merchantId) == null ? "" : ((MerChantInfoPo)merDetailMap.get(merchantId)).getMerchantName());
            }
            storeBo.setStoreId(String.valueOf(temp.getStoreId()));
            storeBoList.add(storeBo);
        }
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        return rspBo;
    }

    private void beforeCopy(InfoStoreQueryWebReqBo reqbo, InfoStorePageReqPO storePo) {
        BeanUtils.copyProperties((Object)reqbo, (Object)((Object)storePo));
        if (!StringUtils.isEmpty((Object)reqbo.getMerchantId())) {
            storePo.setMerchantId(Long.valueOf(reqbo.getMerchantId()));
        }
    }

    private void afterCopy(List<InfoStorePo> storePoList, List<InfoStoreBoStr> storeBoList, String merchantName) {
        for (InfoStorePo temp : storePoList) {
            InfoStoreBoStr storeBo = new InfoStoreBoStr();
            BeanUtils.copyProperties((Object)temp, (Object)storeBo);
            storeBo.setMerchantName(StringUtils.isEmpty((Object)merchantName) ? "" : merchantName);
            storeBo.setMerchantId(temp.getMerchantId() == null ? "" : temp.getMerchantId().toString());
            storeBo.setStoreId(temp.getStoreId() == null ? "" : temp.getStoreId().toString());
            storeBo.setCreateOperId(temp.getCreateOperId() == null ? "" : temp.getCreateOperId());
            storeBo.setCreateTime(temp.getCreateTime() == null ? "" : new DateTime((Object)temp.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            storeBoList.add(storeBo);
        }
    }
}

