/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPageReqPO;
import com.tydic.payment.pay.web.bo.req.QueryInfoBusiSystemWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryInfoBusiSystemReqWayWebBo;
import com.tydic.payment.pay.web.bo.rsp.QueryInfoBusiSystemWebBo;
import com.tydic.payment.pay.web.bo.rsp.QueryInfoBusiSystemWebRspBo;
import com.tydic.payment.pay.web.service.QueryInfoBusiSystemWebService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.web.service.QueryInfoBusiSystemWebService"})
public class QueryInfoBusiSystemWebServiceImpl
implements QueryInfoBusiSystemWebService {
    private static final Logger log = LoggerFactory.getLogger(QueryInfoBusiSystemWebServiceImpl.class);
    private static String SERVICE = "QueryInfoBusiSystemBusiService";
    private static String SERVICE_NAME = "\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1";
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    QueryCodeListByTypecodeService queryCodeListByTypecodeService;
    @Autowired
    RelBusiCashierAtomService relBusiCashierAtomService;

    @PostMapping(value={"queryInfoBusiSystem"})
    public RspPage<QueryInfoBusiSystemWebBo> queryInfoBusiSystem(@RequestBody QueryInfoBusiSystemWebReqBo reqBo) {
        log.info(SERVICE_NAME + " -> " + SERVICE + " : \u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f");
        log.info(SERVICE + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        if (reqBo == null) {
            reqBo = new QueryInfoBusiSystemWebReqBo();
        }
        RspPage retBo = new RspPage();
        ArrayList<QueryInfoBusiSystemWebBo> infoBusiBoList = new ArrayList<QueryInfoBusiSystemWebBo>();
        retBo.setRows(infoBusiBoList);
        BusiSystemInfoPageReqPO qryBusiPo = new BusiSystemInfoPageReqPO();
        if (!StringUtils.isEmpty((String)reqBo.getBusiId())) {
            qryBusiPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
        }
        if (!StringUtils.isEmpty((String)reqBo.getBusiCode())) {
            qryBusiPo.setBusiCode(reqBo.getBusiCode());
        }
        if (!StringUtils.isEmpty((String)reqBo.getBusiName())) {
            qryBusiPo.setBusiName(reqBo.getBusiName());
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        List<BusiSystemInfoPO> queryBusiSystemList = this.busiSystemInfoAtomService.queryBusiSystemInfoByConditionWithPage((Page<BusiSystemInfoPageReqPO>)page, qryBusiPo);
        if (queryBusiSystemList.isEmpty()) {
            retBo.setPageNo(0);
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            return retBo;
        }
        HashMap<String, String> busiSystemStateMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryBusiSystemStateReq = new QueryCodeListByTypecodeReqBo();
        qryBusiSystemStateReq.setTypeCode("BUSI_SYSTEM_STATE");
        QueryCodeListByTypecodeRspBo qryBusiSystemStateRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryBusiSystemStateReq);
        List busiSystemStateList = qryBusiSystemStateRsp.getCodeList();
        for (PCodeListBoStr temp : busiSystemStateList) {
            if (StringUtils.isEmpty((String)temp.getCodeName()) || StringUtils.isEmpty((String)temp.getCodeValue())) continue;
            busiSystemStateMap.put(temp.getCodeValue(), temp.getCodeName());
        }
        HashMap<String, String> busiSystemEncryptMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryBusiSystemEncryptReq = new QueryCodeListByTypecodeReqBo();
        qryBusiSystemEncryptReq.setTypeCode("BUSI_SYSTEM_ENCRYPT");
        QueryCodeListByTypecodeRspBo qryBusiSystemEncryptRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryBusiSystemEncryptReq);
        List busiSystemEncryptList = qryBusiSystemEncryptRsp.getCodeList();
        for (PCodeListBoStr temp : busiSystemEncryptList) {
            if (StringUtils.isEmpty((String)temp.getCodeName()) || StringUtils.isEmpty((String)temp.getCodeValue())) continue;
            busiSystemEncryptMap.put(temp.getCodeValue(), temp.getCodeName());
        }
        HashMap<String, String> busiSystemReqWayMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryBusiSystemReqWayReq = new QueryCodeListByTypecodeReqBo();
        qryBusiSystemReqWayReq.setTypeCode("BUSI_SYSTEM_REQ_WAY");
        QueryCodeListByTypecodeRspBo qryBusiSystemReqWayRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryBusiSystemReqWayReq);
        List busiSystemReqWayList = qryBusiSystemReqWayRsp.getCodeList();
        for (PCodeListBoStr temp : busiSystemReqWayList) {
            if (StringUtils.isEmpty((String)temp.getCodeName()) || StringUtils.isEmpty((String)temp.getCodeValue())) continue;
            busiSystemReqWayMap.put(temp.getCodeValue(), temp.getCodeName());
        }
        HashMap<String, String> busiSystemCallTypeMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryBusiSystemCallTypeReq = new QueryCodeListByTypecodeReqBo();
        qryBusiSystemCallTypeReq.setTypeCode("BUSI_SYSTEM_CALL_TYPE");
        QueryCodeListByTypecodeRspBo qryBusiSystemCallTypeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryBusiSystemCallTypeReq);
        List busiSystemCallTypeList = qryBusiSystemCallTypeRsp.getCodeList();
        for (PCodeListBoStr pCodeListBoStr : busiSystemCallTypeList) {
            if (StringUtils.isEmpty((String)pCodeListBoStr.getCodeName()) || StringUtils.isEmpty((String)pCodeListBoStr.getCodeValue())) continue;
            busiSystemCallTypeMap.put(pCodeListBoStr.getCodeValue(), pCodeListBoStr.getCodeName());
        }
        for (BusiSystemInfoPO busiSystemInfoPO : queryBusiSystemList) {
            Long busiId = busiSystemInfoPO.getBusiId();
            QueryInfoBusiSystemWebBo tempBo = new QueryInfoBusiSystemWebBo();
            infoBusiBoList.add(tempBo);
            BeanUtils.copyProperties((Object)busiSystemInfoPO, (Object)tempBo);
            tempBo.setBusiId(busiId + "");
            tempBo.setRsaPrivateKey("");
            tempBo.setCallType(busiSystemInfoPO.getCallType() == null ? "" : busiSystemInfoPO.getCallType().toString());
            tempBo.setCreateOperId(StringUtils.isEmpty((String)busiSystemInfoPO.getCreateOperId()) ? "" : busiSystemInfoPO.getCreateOperId());
            tempBo.setCreateTime(busiSystemInfoPO.getCreateTime() == null ? "" : new DateTime((Object)busiSystemInfoPO.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            tempBo.setUpdateOperId(StringUtils.isEmpty((String)busiSystemInfoPO.getUpdateOperId()) ? "" : busiSystemInfoPO.getUpdateOperId());
            tempBo.setUpdateTime(busiSystemInfoPO.getUpdateTime() == null ? "" : new DateTime((Object)busiSystemInfoPO.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            tempBo.setRemark(StringUtils.isEmpty((String)busiSystemInfoPO.getRemark()) ? "" : busiSystemInfoPO.getRemark());
            ArrayList<QueryInfoBusiSystemReqWayWebBo> reqWayBoList = new ArrayList<QueryInfoBusiSystemReqWayWebBo>();
            tempBo.setReqWayBoList(reqWayBoList);
            List<String> queryRelBusiCashier = this.relBusiCashierAtomService.queryReqWayRelBusi(busiId);
            for (String tempStr : queryRelBusiCashier) {
                QueryInfoBusiSystemReqWayWebBo tbrwBo = new QueryInfoBusiSystemReqWayWebBo();
                tbrwBo.setReqWay(tempStr);
                tbrwBo.setReqWayName(busiSystemReqWayMap.get(tempStr) == null ? tempStr : (String)busiSystemReqWayMap.get(tempStr));
                reqWayBoList.add(tbrwBo);
            }
            if (!StringUtils.isEmpty((String)busiSystemInfoPO.getState())) {
                tempBo.setStateName(busiSystemStateMap.get(busiSystemInfoPO.getState()) == null ? busiSystemInfoPO.getState() : (String)busiSystemStateMap.get(busiSystemInfoPO.getState()));
            }
            if (!StringUtils.isEmpty((String)busiSystemInfoPO.getEncrypt())) {
                tempBo.setEncryptName(busiSystemEncryptMap.get(busiSystemInfoPO.getEncrypt()) == null ? busiSystemInfoPO.getEncrypt() : (String)busiSystemEncryptMap.get(busiSystemInfoPO.getEncrypt()));
            }
            if (busiSystemInfoPO.getCallType() == null) continue;
            String callType = busiSystemInfoPO.getCallType().toString();
            tempBo.setCallTypeName(busiSystemCallTypeMap.get(callType) == null ? callType : (String)busiSystemCallTypeMap.get(callType));
        }
        retBo.setRows(infoBusiBoList);
        retBo.setPageNo(page.getPageNo());
        retBo.setTotal(page.getTotalPages());
        retBo.setRecordsTotal(page.getTotalCount());
        return retBo;
    }

    @PostMapping(value={"queryAllInfoBusiSystemIdAndName"})
    public QueryInfoBusiSystemWebRspBo queryAllInfoBusiSystemIdAndName(@RequestBody QueryInfoBusiSystemWebReqBo reqBo) {
        log.info(SERVICE_NAME + " -> " + SERVICE + " : \u5f53\u524d\u65b9\u6cd5\uff0c\u8fd4\u56de\u6240\u6709\u4e1a\u52a1\u7cfb\u7edf\u7684Id\u548cName");
        log.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        QueryInfoBusiSystemWebRspBo rspBo = new QueryInfoBusiSystemWebRspBo();
        ArrayList<QueryInfoBusiSystemWebBo> busiBoList = new ArrayList<QueryInfoBusiSystemWebBo>();
        rspBo.setInfoBusiBoList(busiBoList);
        BusiSystemInfoPO qryBusiPo = new BusiSystemInfoPO();
        if (!StringUtils.isEmpty((String)reqBo.getBusiId())) {
            qryBusiPo.setBusiId(Long.parseLong(reqBo.getBusiId()));
        }
        if (!StringUtils.isEmpty((String)reqBo.getBusiName())) {
            qryBusiPo.setBusiName(reqBo.getBusiName());
        }
        List<BusiSystemInfoPO> busiPoList = this.busiSystemInfoAtomService.queryBusiSystemIdAndName(qryBusiPo);
        this.copyPoIDandNameToBo(busiPoList, busiBoList);
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u6210\u529f");
        return rspBo;
    }

    private void copyPoIDandNameToBo(List<BusiSystemInfoPO> busiPoList, List<QueryInfoBusiSystemWebBo> busiBoList) {
        for (BusiSystemInfoPO tempPo : busiPoList) {
            QueryInfoBusiSystemWebBo tempBo = new QueryInfoBusiSystemWebBo();
            tempBo.setBusiId(tempPo.getBusiId().toString());
            tempBo.setBusiName(tempPo.getBusiName());
            busiBoList.add(tempBo);
        }
    }
}

