/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.tydic.payment.pay.atom.PayQryStayCloseTransAtomService;
import com.tydic.payment.pay.atom.bo.PayQryStayCloseTransAtomReqBO;
import com.tydic.payment.pay.atom.bo.PayQryStayCloseTransAtomRspBO;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayCloseTradeReqBO;
import com.tydic.payment.pay.busi.bo.PayCloseTradeRspBO;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.comb.PayCloseTradeCombService;
import com.tydic.payment.pay.comb.bo.PayCloseTradeCombReqBO;
import com.tydic.payment.pay.comb.bo.PayCloseTradeCombRspBO;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.BeanUtils;
import com.tydic.payment.pay.util.PayAbleManager;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payCloseTradeCombService")
public class PayCloseTradeCombServiceImpl
implements PayCloseTradeCombService {
    @Autowired
    private PayQryStayCloseTransAtomService payQryStayCloseTransAtomService;
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;

    public PayCloseTradeCombRspBO closeTrade(PayCloseTradeCombReqBO reqBO) {
        PayCloseTradeCombRspBO rspBO = new PayCloseTradeCombRspBO();
        String validParam = this.validParam(reqBO);
        if (!StringUtils.isEmpty((String)validParam)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(validParam);
            return rspBO;
        }
        PayQryStayCloseTransAtomReqBO payQryStayCloseTransAtomReqBO = new PayQryStayCloseTransAtomReqBO();
        payQryStayCloseTransAtomReqBO.setOrderId(reqBO.getOrderId());
        PayQryStayCloseTransAtomRspBO payQryStayCloseTransAtomRspBO = this.payQryStayCloseTransAtomService.qryStayClose(payQryStayCloseTransAtomReqBO);
        List<PorderPayTransPo> transPos = payQryStayCloseTransAtomRspBO.getTransPos();
        if (!transPos.isEmpty()) {
            PorderPayTransPo trans = transPos.get(0);
            Long payMethod = trans.getPayMethod();
            PayProQueryPayParaBusiReqBo qryPayParaBo = new PayProQueryPayParaBusiReqBo();
            qryPayParaBo.setPayMethod(payMethod);
            qryPayParaBo.setMerchantId(trans.getMerchantId());
            PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaBo);
            if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5546\u6237\u3010" + trans.getMerchantId() + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25");
                return rspBO;
            }
            Map detailAttrs = payProQueryPayParaBusiRspBo.getDetailAttrs();
            PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
            PayCloseTradeReqBO payCloseTradeReqBO = new PayCloseTradeReqBO();
            payCloseTradeReqBO.setPayOrderId(trans.getPayOrderId());
            payCloseTradeReqBO.setParaMap(detailAttrs);
            PayCloseTradeRspBO payCloseTradeRspBO = payAble.dealCloseTrade(payCloseTradeReqBO);
            BeanUtils.copyProperties((Object)payCloseTradeRspBO, (Object)rspBO);
            if (!payCloseTradeRspBO.getRespCode().equals("0000")) {
                rspBO.setPayOrderId(trans.getPayOrderId());
            }
        }
        return rspBO;
    }

    private String validParam(PayCloseTradeCombReqBO reqBO) {
        if (reqBO == null) {
            return "\u5173\u95ed\u8ba2\u5355comb\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)reqBO.getOrderId())) {
            return "\u5173\u95ed\u8ba2\u5355comb\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

