/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.bo.PayProFailAsyncNoticeReqBo;
import com.tydic.payment.pay.bo.PayProFailNoticeMessageBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PayProFailAsyncNotice {
    private static final Logger log = LoggerFactory.getLogger(PayProFailAsyncNotice.class);
    private static final String RESULT_CODE = "resultCode";
    private static final String NOTIFY_RESULT = "notifyResult";
    private static final String NOTIFY_RESULT_CAPITAL = "NOTIFY_RESULT";
    private static final String SUCCESS = "SUCCESS";
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private DataEncryptionService dataEncryptionService;

    @Async(value="payAsyncExecutor")
    public void sendMessage(PayProFailAsyncNoticeReqBo reqBo) {
        if (reqBo.getIsRefund().booleanValue()) {
            log.info("\u9000\u6b3e\u5931\u8d25\u5f02\u6b65\u901a\u77e5");
            this.processRefundFailNotice(reqBo);
        } else {
            log.info("\u652f\u4ed8\u5931\u8d25\u5f02\u6b65\u901a\u77e5");
            this.processPayFailNotice(reqBo);
        }
    }

    private void processRefundFailNotice(PayProFailAsyncNoticeReqBo reqBo) {
        PorderRefundTransAtomReqBo refundTransReqBo = new PorderRefundTransAtomReqBo();
        refundTransReqBo.setRefundOrderId(reqBo.getTransOrderId());
        PorderRefundTransAtomRspBo refundTransRetBo = this.porderRefundTransAtomService.queryOrderRefundTransByRefundOrderId(refundTransReqBo);
        if (null == refundTransRetBo) {
            log.info("===\u9000\u6b3e\u5931\u8d25\u5f02\u6b65\u901a\u77e5\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u6d41\u6c34ID\u3010{}\u3011\u7684\u8ba2\u5355\u4fe1\u606f", (Object)reqBo.getTransOrderId());
            return;
        }
        Long orderId = refundTransRetBo.getOrderId();
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (null == orderInfo) {
            log.info("===\u9000\u6b3e\u5931\u8d25\u5f02\u6b65\u901a\u77e5\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u8ba2\u5355ID\u3010{}\u3011\u7684\u4fe1\u606f", (Object)orderId);
            return;
        }
        PayProFailNoticeMessageBo messageBo = new PayProFailNoticeMessageBo();
        messageBo.setResultCode(reqBo.getOrderStatus());
        messageBo.setResultMsg(reqBo.getStatusDesc());
        messageBo.setReqWay(orderInfo.getReqWay());
        messageBo.setOutOrderId(orderInfo.getOutOrderId());
        messageBo.setTransactionsId(orderId.toString());
        messageBo.setRefundOrderId(refundTransRetBo.getRefundOrderId());
        messageBo.setRemark(orderInfo.getOutRemark());
        this.assignMsg(messageBo, refundTransRetBo.getPayMethod(), refundTransRetBo.getMerchantId());
        this.doSend(messageBo, orderInfo.getNotifyUrl(), orderInfo);
    }

    private void processPayFailNotice(PayProFailAsyncNoticeReqBo reqBo) {
        PorderPayTransAtomReqBo payTransReqBo = new PorderPayTransAtomReqBo();
        payTransReqBo.setPayOrderId(reqBo.getTransOrderId());
        PorderPayTransAtomRspBo payTransRetBo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(payTransReqBo);
        if (null == payTransRetBo) {
            log.info("===\u652f\u4ed8\u5931\u8d25\u5f02\u6b65\u901a\u77e5\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u6d41\u6c34ID\u3010{}\u3011\u8ba2\u5355\u4fe1\u606f", (Object)reqBo.getTransOrderId());
            return;
        }
        Long orderId = payTransRetBo.getOrderId();
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (null == orderInfo) {
            log.info("===\u652f\u4ed8\u5931\u8d25\u5f02\u6b65\u901a\u77e5\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u8ba2\u5355ID\u3010{}\u3011\u7684\u4fe1\u606f", (Object)orderId);
            return;
        }
        PayProFailNoticeMessageBo messageBo = new PayProFailNoticeMessageBo();
        messageBo.setResultCode(reqBo.getOrderStatus());
        messageBo.setResultMsg(reqBo.getStatusDesc());
        messageBo.setReqWay(orderInfo.getReqWay());
        messageBo.setOutOrderId(orderInfo.getOutOrderId());
        messageBo.setTransactionsId(orderId.toString());
        messageBo.setRefundOrderId(payTransRetBo.getPayOrderId());
        this.assignMsg(messageBo, payTransRetBo.getPayMethod(), payTransRetBo.getMerchantId());
        this.doSend(messageBo, orderInfo.getNotifyUrl(), orderInfo);
    }

    private void doSend(PayProFailNoticeMessageBo messageBo, String notifyUrl, PorderPo orderInfo) {
        String messageStr = JSON.toJSONString((Object)messageBo);
        log.info("\u672c\u6b21\u901a\u77e5\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)messageStr);
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(orderInfo.getBusiId().toString());
        dataEncryptionReqBo.setContent(messageStr);
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        log.info("\u672c\u6b21\u5931\u8d25\u901a\u77e5\u7684\u6d88\u606f\u4e3b\u9898\u5185\u5bb9\u4e3a\uff1a{}\uff0c\u76ee\u6807\u5730\u5740\u4e3a\uff1a{}", (Object)dataEncryptionRspBo.getEncrypData(), (Object)notifyUrl);
        HashMap<String, String> postData = new HashMap<String, String>(16);
        postData.put("busiCode", orderInfo.getBusiCode());
        postData.put("content", dataEncryptionRspBo.getEncrypData());
        String result = HttpUtil.post((String)orderInfo.getNotifyUrl(), postData);
        log.info("\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        if (result.contains(RESULT_CODE) || result.contains(NOTIFY_RESULT) || result.contains(NOTIFY_RESULT_CAPITAL)) {
            if (result.contains(SUCCESS)) {
                log.debug("===========\u672c\u6b21\u5931\u8d25\u72b6\u6001\u901a\u77e5\u6210\u529f===========");
            } else {
                log.debug("===========\u672c\u6b21\u5931\u8d25\u72b6\u6001\u901a\u77e5\u5931\u8d25===========");
            }
        } else {
            log.debug("===========\u672c\u6b21\u5931\u8d25\u72b6\u6001\u901a\u77e5\u5931\u8d25===========");
        }
    }

    private void assignMsg(PayProFailNoticeMessageBo messageBo, Long payMethod, Long merchantId) {
        MerChantInfoPo merChantInfo;
        PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(payMethod);
        if (null == methodInfo) {
            return;
        }
        messageBo.setPayMethod(payMethod.toString());
        messageBo.setPayMethodName(methodInfo.getPayMethodName());
        PaymentInsPo paymentInsPo = new PaymentInsPo();
        paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
        List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
        if (!CollectionUtils.isEmpty(paymentInsList)) {
            PaymentInsPo paymentInsInfo = paymentInsList.get(0);
            messageBo.setPaymentInsId(paymentInsInfo.getPaymentInsId().toString());
            messageBo.setPaymentInsName(paymentInsInfo.getPaymentInsName());
        }
        messageBo.setMerchantId(merchantId.toString());
        if (null != merchantId && null != (merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId))) {
            messageBo.setMerchantName(merChantInfo.getMerchantName());
        }
    }
}

