/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.payable.impl.transbo.SftBillErrorRspBO;
import com.tydic.payment.pay.payable.impl.transbo.SftBillReqBO;
import com.tydic.payment.pay.payable.impl.transbo.SftBillRspBO;
import com.tydic.payment.pay.sft.MD5;
import com.tydic.payment.pay.sft.RSATool;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.payment.pay.util.SftHttpClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PayBillAbleSftImpl
implements PayBillAble {
    private static final Logger log = LoggerFactory.getLogger(PayBillAbleSftImpl.class);
    private static final String UTF_8 = "UTF-8";
    private String ThirdSysID;
    private String TxCode;
    private String Data;
    private String Auth;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private SftHttpClient sftHttpClient;

    public Long paymentIns() {
        return BillConstant.PaymentIns.SFT_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        PayBillAbleDownloadRspBo retBo = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        String validateStr = this.validateBillArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        String sftRequestUrl = this.payPropertiesVo.getSFTRequestUrl();
        SftBillReqBO sftBillReqBO = new SftBillReqBO();
        sftBillReqBO.setTxCode("SFT10033");
        sftBillReqBO.setTransID(String.valueOf(PayProSequence.nextId()));
        sftBillReqBO.setQueryTime(String.valueOf(reqBo.getBillDate()));
        this.initParam(sftBillReqBO);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("ThirdSysID", this.ThirdSysID);
        dataMap.put("Data", this.Data);
        dataMap.put("TxCode", this.TxCode);
        dataMap.put("Auth", this.Auth);
        CloseableHttpResponse response = null;
        List<SftBillRspBO> sftBillRspBOS = new ArrayList<SftBillRspBO>();
        try {
            CloseableHttpClient client = this.getCloseableHttpClient();
            HttpPost httpPost = new HttpPost(sftRequestUrl);
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set keySet = dataMap.keySet();
            for (String key : keySet) {
                nvps.add(new BasicNameValuePair(key, (String)dataMap.get(key)));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)httpPost);
            InputStream content = response.getEntity().getContent();
            byte[] bytes = PayBillAbleSftImpl.inputStream2Byte(content);
            String errorResult = new String(bytes, StandardCharsets.UTF_8);
            if (errorResult.contains("errorCode")) {
                SftBillErrorRspBO sftBillErrorRspBO = (SftBillErrorRspBO)JSON.parseObject((String)errorResult, SftBillErrorRspBO.class);
                log.info("\u4e0b\u8f7d\u5584\u4ed8\u901a\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25:{}", (Object)sftBillErrorRspBO.getErrorMsg());
                return retBo;
            }
            byte[] unZipBytes = this.unZip(bytes);
            String resultBody = new String(unZipBytes, StandardCharsets.UTF_8);
            sftBillRspBOS = JSON.parseArray((String)resultBody, SftBillRspBO.class);
            log.info("\u5584\u4ed8\u901a\u5bf9\u8d26\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(sftBillRspBOS));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.parseAndSavaToRspBos(sftBillRspBOS, retBo, reqBo.getBillDate());
        return retBo;
    }

    public String encryp(String reqJson, String publicKeyStr) {
        String enStr = null;
        try {
            enStr = RSATool.clientEncrypt((String)reqJson, (String)publicKeyStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enStr;
    }

    private void initParam(SftBillReqBO sftBillReqBO) {
        String sftPublicKey = this.payPropertiesVo.getSFTPublicKey();
        String md5Key = this.payPropertiesVo.getSFTMD5Key();
        String reqJson = JSON.toJSONString((Object)sftBillReqBO);
        String enStr = this.encryp(reqJson, sftPublicKey);
        try {
            this.Data = URLEncoder.encode(enStr, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.Auth = MD5.getMD5((String)(this.ThirdSysID + this.TxCode + this.Data + md5Key), (String)"utf-8");
        this.TxCode = "SFT10033";
        this.ThirdSysID = this.payPropertiesVo.getSFTThirdSysId();
    }

    private byte[] unZip(byte[] data) {
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = null;
        ZipInputStream zip = null;
        byte[] b = null;
        try {
            bis = new ByteArrayInputStream(data);
            bos = new ByteArrayOutputStream();
            zip = new ZipInputStream(bis);
            while (zip.getNextEntry() != null) {
                int r = -1;
                byte[] buf = new byte[1024];
                while ((r = zip.read(buf, 0, buf.length)) != -1) {
                    bos.write(buf, 0, r);
                }
                b = bos.toByteArray();
                bos.flush();
                bos.close();
            }
            zip.close();
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            assert (sc != null);
            sc.init(null, new TrustManager[]{x509TrustManager}, null);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    private CloseableHttpClient getCloseableHttpClient() {
        SSLContext sslcontext = PayBillAbleSftImpl.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    public static byte[] inputStream2Byte(InputStream is) {
        int BUFFER_SIZE = 1024;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] date = new byte[BUFFER_SIZE];
        int len = -1;
        while (true) {
            try {
                len = is.read(date, 0, BUFFER_SIZE);
                if (-1 == len) {
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            os.write(date, 0, BUFFER_SIZE);
        }
        return os.toByteArray();
    }

    private String validateBillArgs(PayBillAbleDownloadReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getBillDate() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'billDate'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private void parseAndSavaToRspBos(List<SftBillRspBO> sftBillRspBOS, PayBillAbleDownloadRspBo rspBo, Long billDate) {
        sftBillRspBOS.forEach(bo -> this.buildRspData((SftBillRspBO)bo, rspBo, billDate));
    }

    private void buildRspData(SftBillRspBO sftBillData, PayBillAbleDownloadRspBo rspBo, Long billDate) {
        PayBillAbleDownloadRspDataBo trans = new PayBillAbleDownloadRspDataBo();
        if ("1".equals(sftBillData.getPayStatus())) {
            trans.setOrderType("01");
            trans.setTypeOrderId(sftBillData.getOrderNo());
            trans.setBillDate(billDate);
            trans.setPaymentInsId(BillConstant.PaymentIns.SFT_PAY.getPaymentInsId());
            trans.setTypeTransId(sftBillData.getPayTransidCcb());
            Double payFee = Double.valueOf(sftBillData.getOrderMoney()) * 100.0;
            long realFee = payFee.longValue();
            trans.setRealFee(Long.valueOf(realFee));
            trans.setBillFlag("0");
            trans.setPaymentMchId(sftBillData.getSelleridThirdsys());
            trans.setPaymentInsObj((Object)sftBillData);
            trans.setTradeTime(sftBillData.getOrdTime());
            rspBo.getRspDataBos().add(trans);
        }
    }
}

