/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayProWxUnifiedOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractWxPayAble;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WxPayAppPayAbleImpl
extends AbstractWxPayAble
implements PayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProWxUnifiedOrderBusiService payProWxUnifiedOrderBusiService;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.WX_APP.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        this.LOGGER.info("\u5fae\u4fe1APP\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff1a" + reqBo);
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validteArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5fae\u4fe1APP\u652f\u4ed8\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("212042");
            retBo.setRespDesc("\u5fae\u4fe1APP\u652f\u4ed8\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        JSONObject json = JSON.parseObject((String)reqBo.getBusiReqData());
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)json, PayAbleBusiReqDataBo.class);
        PayProWxUnifiedOrderBusiReqBo unifiedReqBo = new PayProWxUnifiedOrderBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)unifiedReqBo);
        unifiedReqBo.setPayOrderId(reqBo.getPayOrderId());
        unifiedReqBo.setParaMap(reqBo.getParaMap());
        unifiedReqBo.setPayMethod(PayProConstants.PayMethod.WX_APP.getPayMethod() + "");
        unifiedReqBo.setBody(reqBo.getDetailName());
        unifiedReqBo.setOpenId(reqDataBo.getOpenId());
        unifiedReqBo.setSpbillCreateIp(reqBo.getCreateIpAddress());
        unifiedReqBo.setAppPayAppId((String)reqBo.getParaMap().get("appid"));
        unifiedReqBo.setTotalFee(reqBo.getPayFee() + "");
        PayProWxUnifiedOrderBusiRspBo unifiedRetBo = this.payProWxUnifiedOrderBusiService.unifiedOrder(unifiedReqBo);
        if (!"0000".equals(unifiedRetBo.getRespCode())) {
            retBo.setRespCode("212042");
            retBo.setRespDesc("\u8c03\u7528\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355busi\u670d\u52a1\u5931\u8d25\uff1a" + unifiedRetBo.getRespDesc());
            return retBo;
        }
        String signKey = (String)reqBo.getParaMap().get("signkey");
        this.sortRetBo(reqBo, retBo, signKey, unifiedRetBo);
        return retBo;
    }

    private String validteArgs(PayAbleDealPayReqBo reqBo) {
        super.validWxJsapiaArgs(reqBo);
        Map paraMap = reqBo.getParaMap();
        if (StringUtils.isEmpty(paraMap.get("appid"))) {
            return "\u5546\u6237\u4fe1\u606f\u672a\u914d\u7f6e\u3010Appid\u3011";
        }
        return null;
    }
}

