/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.ability.impl;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.ability.BillHandlerTaskAbilityService;
import com.tydic.payment.bill.busi.PayBillCommBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.UpdateShardingCountRedisBusiService;
import com.tydic.payment.bill.comb.BillBusiCheckCombService;
import com.tydic.payment.bill.comb.bo.BillBusiCheckCombReqBO;
import com.tydic.payment.bill.comb.bo.BillCheckConfigReqBO;
import com.tydic.payment.bill.comb.bo.BillCheckConfigRspBO;
import com.tydic.payment.bill.comb.bo.BillCheckLogReqBO;
import com.tydic.payment.bill.constant.BillExecuteStep;
import com.tydic.payment.bill.exception.BillException;
import com.tydic.payment.bill.executor.BillExecutor;
import com.tydic.payment.bill.util.PayBillUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="billHandlerTaskAbilityService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.bill.ability.BillHandlerTaskAbilityService"})
public class BillHandlerTaskAbilityServiceImpl
implements BillHandlerTaskAbilityService {
    @Autowired
    private PayBillCommBusiService payBillCommBusiService;
    @Autowired
    private UpdateShardingCountRedisBusiService updateShardingCountRedisBusiService;
    @Autowired
    private BillBusiCheckCombService billBusiCheckCombService;
    @Autowired
    private PaymentInsIdBusiService paymentInsIdBusiService;
    @Autowired
    private BillExecutor billExecutor;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"execute"})
    public void execute(@RequestBody String segmentNumber) {
        Integer currentNumber;
        if (StringUtils.isEmpty((Object)segmentNumber)) {
            segmentNumber = "0";
        }
        Long splitTotal = this.paymentInsIdBusiService.getBillSplitTotal();
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1a\u5165\u53c2 {}", (Object)segmentNumber);
        try {
            currentNumber = Integer.valueOf(segmentNumber);
            this.logger.debug("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1a\u5f53\u524d\u5206\u7247\u53f7 == " + segmentNumber);
        }
        catch (NumberFormatException ex) {
            this.updateShardingCountRedisBusiService.updateShardingCount(splitTotal);
            this.logger.error("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u5165\u53c2\u9519\u8bef\uff1a{}", (Throwable)ex);
            return;
        }
        Long billDate = this.paymentInsIdBusiService.getBillDate();
        BillCheckConfigReqBO configReqBO = new BillCheckConfigReqBO();
        configReqBO.setEffFlag("1");
        configReqBO.setNextDate(billDate);
        List configRspBOS = this.payBillCommBusiService.getBillCheckConfig(configReqBO);
        if (configRspBOS.size() > 0) {
            configRspBOS = configRspBOS.parallelStream().filter(config -> PayBillUtils.hashByMerchId(config.getPaymentMchId(), splitTotal.intValue()) == currentNumber).collect(Collectors.toList());
        }
        this.logger.info("\u5206\u7247 \u3010" + currentNumber + "\u3011\u5904\u7406 " + configRspBOS.size() + "\u6761\u652f\u4ed8\u5546\u6237\u6570\u636e\uff01");
        for (BillCheckConfigRspBO configRspBO : configRspBOS) {
            this.logger.info("\u652f\u4ed8\u5546\u6237\u3010{}\u3011\u5bf9\u8d26\u5f00\u59cb", (Object)configRspBO.getPaymentMchId());
            this.doExecute(configRspBO, billDate);
            this.logger.info("\u652f\u4ed8\u5546\u6237\u3010{}\u3011\u5bf9\u8d26\u7ed3\u675f", (Object)configRspBO.getPaymentMchId());
        }
        this.updateSplitTotal(billDate, splitTotal);
    }

    private void updateSplitTotal(Long billDate, Long splitTotal) {
        boolean flag = this.updateShardingCountRedisBusiService.updateShardingCount(splitTotal);
        if (flag) {
            this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8d26\u670d\u52a1\u5f00\u59cb\uff1a{}", (Object)billDate);
            BillBusiCheckCombReqBO reqBO = new BillBusiCheckCombReqBO();
            reqBO.setBillDate(billDate);
            this.billBusiCheckCombService.execute(reqBO);
            this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8d26\u670d\u52a1\u7ed3\u675f");
        }
    }

    private void doExecute(BillCheckConfigRspBO config, Long billDate) {
        BillCheckLogReqBO logReqBO = new BillCheckLogReqBO();
        logReqBO.setPaymentInsId(config.getPaymentInsId());
        logReqBO.setPaymentMchId(config.getPaymentMchId());
        logReqBO.setBillDate(billDate);
        logReqBO.setConfigId(config.getConfigId());
        logReqBO.setNextDate(this.nextDay(billDate));
        logReqBO.setEffFlag("1");
        logReqBO.setCreateTime(new Date());
        logReqBO.setLastResult("1");
        logReqBO.setResultCode("0000");
        logReqBO.setResultDesc("SUCCESS");
        BillCheckConfigReqBO billCheckConfigReqBO = new BillCheckConfigReqBO();
        billCheckConfigReqBO.setConfigId(config.getConfigId());
        billCheckConfigReqBO.setNextDate(this.nextDay(billDate));
        billCheckConfigReqBO.setLastResult("1");
        billCheckConfigReqBO.setLastResultCode("0000");
        billCheckConfigReqBO.setLastResultDesc("SUCCESS");
        BillExecuteRequest request = new BillExecuteRequest();
        request.setBillDate(billDate);
        request.setPaymentInsId(config.getPaymentInsId());
        request.setPaymentMchId(config.getPaymentMchId());
        if (!"1".equals(config.getLastResult()) && !"0000".equals(config.getLastResultCode())) {
            request.setBillExecuteStep(BillExecuteStep.ofCode((int)Integer.parseInt(config.getLastResultCode())));
        }
        try {
            this.billExecutor.invoke(request);
        }
        catch (Exception ex) {
            this.logger.error("\u5546\u6237\u53f7\u3010" + config.getPaymentMchId() + "\u3011\u5bf9\u8d26\u53d1\u751f\u9519\u8bef \uff1a{}", (Throwable)ex);
            if (ex instanceof BillException) {
                BillException exception = (BillException)ex;
                logReqBO.setResultCode(String.valueOf(exception.getBillExecuteStep().getCode()));
                logReqBO.setResultDesc(exception.getMessage());
                logReqBO.setLastResult("0");
                billCheckConfigReqBO.setLastResultCode(String.valueOf(exception.getBillExecuteStep().getCode()));
                billCheckConfigReqBO.setLastResultDesc(exception.getMessage());
                billCheckConfigReqBO.setLastResult("0");
            } else {
                logReqBO.setResultCode(String.valueOf(BillExecuteStep.SYNC_SETTLE_TRANS.getCode()));
                logReqBO.setResultDesc(ex.getMessage());
                logReqBO.setLastResult("0");
                billCheckConfigReqBO.setLastResultCode(String.valueOf(BillExecuteStep.SYNC_SETTLE_TRANS.getCode()));
                billCheckConfigReqBO.setLastResultDesc(ex.getMessage());
                billCheckConfigReqBO.setLastResult("0");
            }
            billCheckConfigReqBO.setNextDate(billDate);
        }
        this.logger.info("\u8bb0\u5f55\u672c\u6b21\u5904\u7406\u7684\u65e5\u5fd7\uff1a" + logReqBO);
        this.payBillCommBusiService.saveBillCheckLog(logReqBO);
        this.logger.info("\u66f4\u65b0\u672c\u6b21\u5904\u7406\u7684\u7ed3\u679c\uff1a" + billCheckConfigReqBO);
        this.payBillCommBusiService.updateCheckConfig(billCheckConfigReqBO);
    }

    private Long nextDay(Long checkDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return Long.valueOf(LocalDate.parse(checkDate.toString(), formatter).plusDays(1L).format(formatter));
    }
}

