/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.tydic.payment.bill.busi.PayBillCommBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.UpdateShardingCountRedisBusiService;
import com.tydic.payment.bill.comb.bo.BillCheckConfigReqBO;
import com.tydic.payment.bill.comb.bo.BillCheckLogReqBO;
import com.tydic.payment.bill.constant.BillExecuteStep;
import com.tydic.payment.bill.exception.BillException;
import com.tydic.payment.pay.ability.PayProBillExecutorAbilityService;
import com.tydic.payment.pay.ability.bo.PayProBillExecutorAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProBillExecutorAbilityServiceRspBo;
import com.tydic.payment.pay.atom.PayProBillQryPaymentMerchantAtomService;
import com.tydic.payment.pay.atom.bo.PayProBillQryPaymentMerchantAtomServiceReqBo;
import com.tydic.payment.pay.atom.bo.PayProBillQryPaymentMerchantAtomServiceRspBo;
import com.tydic.payment.pay.atom.bo.PayProBillQryPaymentMerchantAtomServiceRspDataBo;
import com.tydic.payment.pay.bill.impl.api.PayProBillMerchantExecBillService;
import com.tydic.payment.pay.comb.bo.PayProBillMerchantExecCombServiceReqBo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.PayProBillExecutorAbilityService"})
public class PayProBillExecutorAbilityServiceImpl
implements PayProBillExecutorAbilityService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PaymentInsIdBusiService paymentInsIdBusiService;
    @Autowired
    private PayProBillMerchantExecBillService payProBillMerchantExecBillService;
    @Autowired
    private PayProBillQryPaymentMerchantAtomService payProBillQryPaymentMerchantAtomService;
    @Autowired
    private PayBillCommBusiService payBillCommBusiService;
    @Autowired
    private UpdateShardingCountRedisBusiService updateShardingCountRedisBusiService;
    @Autowired
    private PayMethodMapper payMethodMapper;
    private static final String RESULT_DESC_SUCCESS = "SUCCESS";

    @PostMapping(value={"execBill"})
    public PayProBillExecutorAbilityServiceRspBo execBill(@RequestBody PayProBillExecutorAbilityServiceReqBo reqBo) {
        PayProBillExecutorAbilityServiceRspBo rspBo = PayProRspUtil.generateSucRspBo(PayProBillExecutorAbilityServiceRspBo.class);
        Long billDate = this.paymentInsIdBusiService.getBillDate();
        PayProBillQryPaymentMerchantAtomServiceReqBo qryMerchantBo = new PayProBillQryPaymentMerchantAtomServiceReqBo();
        qryMerchantBo.setEffFlag("1");
        qryMerchantBo.setNextDate(billDate);
        PayProBillQryPaymentMerchantAtomServiceRspBo qryMerchantRsp = this.payProBillQryPaymentMerchantAtomService.qryMerchant(qryMerchantBo);
        if (!"0000".equals(qryMerchantRsp.getRespCode())) {
            return PayProRspUtil.generateRspBo("214029", qryMerchantRsp.getRespDesc(), PayProBillExecutorAbilityServiceRspBo.class);
        }
        HashSet<String> filterSet = new HashSet<String>();
        for (PayProBillQryPaymentMerchantAtomServiceRspDataBo data : qryMerchantRsp.getDatas()) {
            PayProBillMerchantExecCombServiceReqBo execMerchantBo = new PayProBillMerchantExecCombServiceReqBo();
            execMerchantBo.setBillDate(billDate);
            execMerchantBo.setMerchantId(data.getMerchantId());
            execMerchantBo.setPaymentInsId(data.getPaymentInsId());
            execMerchantBo.setPaymentInsMerchant(data.getAttrValue());
            execMerchantBo.setConfigId(data.getConfigId());
            execMerchantBo.setLastResult(data.getLastResult());
            execMerchantBo.setLastResultCode(data.getLastResultCode());
            this.logger.info("\u652f\u4ed8\u5546\u6237[{}] \u5f00\u59cb\u5bf9\u8d26", (Object)data.getAttrValue());
            boolean needTrigger = false;
            if (!filterSet.contains(data.getAttrValue())) {
                filterSet.add(data.getAttrValue());
                needTrigger = true;
            }
            this.doBill(execMerchantBo, needTrigger);
            this.logger.info("\u652f\u4ed8\u5546\u6237[{}] \u7ed3\u675f\u5bf9\u8d26", (Object)data.getAttrValue());
        }
        return rspBo;
    }

    private void doBill(PayProBillMerchantExecCombServiceReqBo config, boolean needTrigger) {
        Long billDate = config.getBillDate();
        BillCheckLogReqBO logReqBO = new BillCheckLogReqBO();
        logReqBO.setPaymentInsId(config.getPaymentInsId());
        logReqBO.setPaymentMchId(config.getPaymentInsMerchant());
        logReqBO.setBillDate(billDate);
        logReqBO.setConfigId(config.getConfigId());
        logReqBO.setNextDate(this.nextDayLong(billDate));
        logReqBO.setEffFlag("1");
        logReqBO.setCreateTime(this.payMethodMapper.getDBDate().getDate());
        logReqBO.setLastResult("1");
        logReqBO.setResultCode("0000");
        logReqBO.setResultDesc(RESULT_DESC_SUCCESS);
        BillCheckConfigReqBO billCheckConfigReqBO = new BillCheckConfigReqBO();
        billCheckConfigReqBO.setConfigId(config.getConfigId());
        billCheckConfigReqBO.setNextDate(this.nextDayLong(billDate));
        billCheckConfigReqBO.setLastResult("1");
        billCheckConfigReqBO.setLastResultCode("0000");
        billCheckConfigReqBO.setLastResultDesc(RESULT_DESC_SUCCESS);
        if (!"1".equals(config.getLastResult()) && !"0000".equals(config.getLastResultCode())) {
            config.setBillExecuteStep(BillExecuteStep.ofCode((int)Integer.parseInt(config.getLastResultCode())));
        }
        try {
            if (needTrigger) {
                this.payProBillMerchantExecBillService.execMerchantBill(config);
            }
        }
        catch (Exception ex) {
            this.logger.error("\u5546\u6237\u53f7\u3010" + config.getPaymentInsMerchant() + "\u3011\u5bf9\u8d26\u53d1\u751f\u9519\u8bef \uff1a{}", (Throwable)ex);
            if (ex instanceof BillException) {
                BillException exception = (BillException)ex;
                logReqBO.setResultCode(String.valueOf(exception.getBillExecuteStep().getCode()));
                logReqBO.setResultDesc(PayProBillExecutorAbilityServiceImpl.cutException((Exception)exception));
                logReqBO.setLastResult("0");
                billCheckConfigReqBO.setLastResultCode(String.valueOf(exception.getBillExecuteStep().getCode()));
                billCheckConfigReqBO.setLastResultDesc(PayProBillExecutorAbilityServiceImpl.cutException((Exception)exception));
                billCheckConfigReqBO.setLastResult("0");
            } else {
                logReqBO.setResultCode(String.valueOf(BillExecuteStep.SYNC_SETTLE_TRANS.getCode()));
                logReqBO.setResultDesc(PayProBillExecutorAbilityServiceImpl.cutException(ex));
                logReqBO.setLastResult("0");
                billCheckConfigReqBO.setLastResultCode(String.valueOf(BillExecuteStep.SYNC_SETTLE_TRANS.getCode()));
                billCheckConfigReqBO.setLastResultDesc(PayProBillExecutorAbilityServiceImpl.cutException(ex));
                billCheckConfigReqBO.setLastResult("0");
            }
            billCheckConfigReqBO.setNextDate(billDate);
        }
        this.logger.info("\u8bb0\u5f55\u672c\u6b21\u5904\u7406\u7684\u65e5\u5fd7\uff1a" + logReqBO);
        this.payBillCommBusiService.saveBillCheckLog(logReqBO);
        this.logger.info("\u66f4\u65b0\u672c\u6b21\u5904\u7406\u7684\u7ed3\u679c\uff1a" + billCheckConfigReqBO);
        this.payBillCommBusiService.updateCheckConfig(billCheckConfigReqBO);
    }

    public static String cutException(Exception exception) {
        int len = 2000;
        if (exception != null) {
            String exceptionMessage = exception.getMessage();
            return StrUtil.isEmpty((CharSequence)exceptionMessage) ? "" : (exceptionMessage.length() > len ? exceptionMessage.substring(0, len) : exceptionMessage);
        }
        return "";
    }

    private Long nextDayLong(Long checkDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return Long.valueOf(LocalDate.parse(checkDate.toString(), formatter).plusDays(1L).format(formatter));
    }
}

