/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProGenerateMerchantWithTempAbilityService;
import com.tydic.payment.pay.ability.bo.PayProGenerateMerchantWithTempAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProGenerateMerchantWithTempAbilityRspBo;
import com.tydic.payment.pay.busi.PayProAddMerchantBusiService;
import com.tydic.payment.pay.busi.bo.PayProAddMerchantBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProAddMerchantBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProMerchantInfoBo;
import com.tydic.payment.pay.busi.bo.PayProPayParaAttrInfoBo;
import com.tydic.payment.pay.busi.bo.PayProPayParaInfoBo;
import com.tydic.payment.pay.busi.bo.PayProPaymentInsInfoBo;
import com.tydic.payment.pay.busi.bo.PayProRelSysMerchantBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.BusiSystemMerchantRelMapper;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.PayParaInfoAttrMapper;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="payProGenerateMerchantWithTempAbilityService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.PayProGenerateMerchantWithTempAbilityService"})
public class PayProGenerateMerchantWithTempAbilityServiceImpl
implements PayProGenerateMerchantWithTempAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private BusiSystemMerchantRelMapper busiSystemMerchantRelMapper;
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;
    @Autowired
    private PayParaInfoAttrMapper payParaInfoAttrMapper;
    @Autowired
    private PayProAddMerchantBusiService payProAddMerchantBusiService;

    @PostMapping(value={"generateMerchant"})
    public PayProGenerateMerchantWithTempAbilityRspBo generateMerchant(@RequestBody PayProGenerateMerchantWithTempAbilityReqBo reqBo) {
        this.LOGGER.debug("\u6839\u636e\u6a21\u677f\u5546\u6237\u65b0\u589e\u5546\u6237\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        PayProGenerateMerchantWithTempAbilityRspBo rspBo = new PayProGenerateMerchantWithTempAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("214024");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        Long newMerchantId = reqBo.getMerchantId();
        MerChantInfoPo queryMerchantPo = new MerChantInfoPo();
        queryMerchantPo.setMerchantId(newMerchantId);
        MerChantInfoPo queryMerchantRspPo = this.merChantInfoMapper.queryMerChantInfoById(queryMerchantPo);
        if (queryMerchantRspPo != null) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5546\u6237(" + newMerchantId + ")\u5df2\u5b58\u5728");
            rspBo.setMerchantId(reqBo.getMerchantId());
            rspBo.setMerchantName(queryMerchantRspPo.getMerchantName());
            return rspBo;
        }
        PayProAddMerchantBusiReqBo addMerchantReqBo = new PayProAddMerchantBusiReqBo();
        this.prepareArg(reqBo, addMerchantReqBo);
        PayProAddMerchantBusiRspBo addMerchantRspBo = this.payProAddMerchantBusiService.addMerchant(addMerchantReqBo);
        if (!"0000".equals(addMerchantRspBo.getRespCode())) {
            rspBo.setRespCode(addMerchantRspBo.getRespCode());
            rspBo.setRespDesc(addMerchantRspBo.getRespDesc());
        } else {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
        }
        this.LOGGER.debug("\u6839\u636e\u6a21\u677f\u5546\u6237\u65b0\u589e\u5546\u6237\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void prepareArg(PayProGenerateMerchantWithTempAbilityReqBo reqBo, PayProAddMerchantBusiReqBo addMerchantReqBo) {
        Long tempMerchantId = reqBo.getTempMerchantId();
        Long merchantId = reqBo.getMerchantId();
        MerChantInfoPo qryMerchantPo = new MerChantInfoPo();
        qryMerchantPo.setMerchantId(tempMerchantId);
        MerChantInfoPo qryRetMerchantBo = this.merChantInfoMapper.queryMerChantInfoById(qryMerchantPo);
        if (qryRetMerchantBo == null) {
            throw new BusinessException("218001", "\u6a21\u677f\u5546\u6237(" + reqBo.getTempMerchantId() + ")\u4e0d\u5b58\u5728");
        }
        PayProMerchantInfoBo merchantInfoBo = new PayProMerchantInfoBo();
        BeanUtils.copyProperties((Object)qryRetMerchantBo, (Object)merchantInfoBo);
        merchantInfoBo.setMerchantId(merchantId);
        merchantInfoBo.setMerchantName(reqBo.getMerchantName());
        merchantInfoBo.setMerchantNameAbb(reqBo.getMerchantName());
        addMerchantReqBo.setMerchantInfoBo(merchantInfoBo);
        BusiSystemMerchantRelPo queryRelBusiMerchantBo = new BusiSystemMerchantRelPo();
        queryRelBusiMerchantBo.setMerchantId(tempMerchantId);
        List<BusiSystemMerchantRelPo> busiSystemMerchantRelPos = this.busiSystemMerchantRelMapper.queryBusiSystemMerchantByCondition(queryRelBusiMerchantBo);
        ArrayList<PayProRelSysMerchantBo> relBusiMerchantList = new ArrayList<PayProRelSysMerchantBo>();
        addMerchantReqBo.setRelSysMerchantBoList(relBusiMerchantList);
        for (BusiSystemMerchantRelPo bsmPo : busiSystemMerchantRelPos) {
            PayProRelSysMerchantBo newBsmPo = new PayProRelSysMerchantBo();
            BeanUtils.copyProperties((Object)bsmPo, (Object)newBsmPo);
            relBusiMerchantList.add(newBsmPo);
        }
        MerchantPayMethodRelPo queryMerchantPayMethodRelPo = new MerchantPayMethodRelPo();
        queryMerchantPayMethodRelPo.setMerchantId(tempMerchantId);
        List<MerchantPayMethodRelPo> merchantPayMethodRelPos = this.merchantPayMethodRelMapper.queryMerchantPayMethodRelByCondition(queryMerchantPayMethodRelPo);
        ArrayList<PayProPaymentInsInfoBo> paymentInsInfoList = new ArrayList<PayProPaymentInsInfoBo>();
        addMerchantReqBo.setPaymentInsInfoBoList(paymentInsInfoList);
        this.tidyPaymentInsBo(merchantPayMethodRelPos, paymentInsInfoList);
    }

    private void tidyPaymentInsBo(List<MerchantPayMethodRelPo> merchantPayMethodRelPos, List<PayProPaymentInsInfoBo> paymentInsInfoList) {
        PayProPaymentInsInfoBo payProPaymentInsInfoBo;
        Long paymentInsId;
        HashMap<Long, PayProPaymentInsInfoBo> paymentInsMap = new HashMap<Long, PayProPaymentInsInfoBo>(16);
        for (MerchantPayMethodRelPo mpmPo : merchantPayMethodRelPos) {
            paymentInsId = mpmPo.getPaymentInsId();
            payProPaymentInsInfoBo = (PayProPaymentInsInfoBo)paymentInsMap.get(paymentInsId);
            if (payProPaymentInsInfoBo != null) continue;
            PayProPaymentInsInfoBo tempPaymentInsBo = new PayProPaymentInsInfoBo();
            tempPaymentInsBo.setPaymentInsId(paymentInsId);
            paymentInsMap.put(paymentInsId, tempPaymentInsBo);
            paymentInsInfoList.add(tempPaymentInsBo);
        }
        for (MerchantPayMethodRelPo mpmPo : merchantPayMethodRelPos) {
            paymentInsId = mpmPo.getPaymentInsId();
            payProPaymentInsInfoBo = (PayProPaymentInsInfoBo)paymentInsMap.get(paymentInsId);
            ArrayList<Long> payMethodList = payProPaymentInsInfoBo.getPayMethodList();
            if (payMethodList == null) {
                payMethodList = new ArrayList<Long>();
                payProPaymentInsInfoBo.setPayMethodList(payMethodList);
            }
            payMethodList.add(mpmPo.getPayMethod());
            PayProPayParaInfoBo payParaInfoBo = payProPaymentInsInfoBo.getPayParaInfoBo();
            if (payParaInfoBo != null) continue;
            payParaInfoBo = new PayProPayParaInfoBo();
            ArrayList<PayProPayParaAttrInfoBo> paraAttrList = new ArrayList<PayProPayParaAttrInfoBo>();
            payParaInfoBo.setPayParaAttrInfoBoList(paraAttrList);
            payProPaymentInsInfoBo.setPayParaInfoBo(payParaInfoBo);
            Long payParaId = mpmPo.getPayParaId();
            PayParaInfoAttrPo queryPayParaPo = new PayParaInfoAttrPo();
            queryPayParaPo.setPayParaId(payParaId);
            List<PayParaInfoAttrPo> payParaInfoAttrPos = this.payParaInfoAttrMapper.queryPayParaInfoAttrByCondition(queryPayParaPo);
            for (PayParaInfoAttrPo attrPo : payParaInfoAttrPos) {
                if (attrPo == null) continue;
                PayProPayParaAttrInfoBo tmpAttrInfoBo = new PayProPayParaAttrInfoBo();
                paraAttrList.add(tmpAttrInfoBo);
                tmpAttrInfoBo.setAttrCode(attrPo.getAttrCode());
                tmpAttrInfoBo.setAttrValue(attrPo.getAttrValue());
            }
        }
    }

    private String validateArg(PayProGenerateMerchantWithTempAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getMerchantId() == null) {
            return "\u5165\u53c2\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getTempMerchantId() == null) {
            return "\u5165\u53c2\u5c5e\u6027tempMerchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantName())) {
            return "\u5165\u53c2\u5c5e\u6027merchantName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

