/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProOrderUrlAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderUrlAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderUrlAbilityRspBo;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.QueryCashierService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierRspBo;
import com.tydic.payment.pay.comb.PayAbleDealPayCombService;
import com.tydic.payment.pay.comb.PayProPreparedOrderCombService;
import com.tydic.payment.pay.comb.bo.PayAbleDealPayCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleDealPayCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombRspBo;
import com.tydic.payment.pay.common.util.OrderCiphertext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="payProOrderUrlAbilityService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.PayProOrderUrlAbilityService"})
public class PayProOrderUrlAbilityServiceImpl
implements PayProOrderUrlAbilityService {
    private static final String SERVICE_NAME = "\u4e0b\u5355\u8fd4\u56deURL Ability\u670d\u52a1(\u652f\u4ed8-\u4ea7\u54c1)";
    private static final Logger LOGGER = LoggerFactory.getLogger(PayProOrderUrlAbilityServiceImpl.class);
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private PayProPreparedOrderCombService payProPreparedOrderCombService;
    @Autowired
    private QueryCashierService queryCashierService;
    @Autowired
    private PayAbleDealPayCombService payAbleDealPayCombService;

    @PostMapping(value={"orderUrl"})
    public PayProOrderUrlAbilityRspBo orderUrl(@RequestBody PayProOrderUrlAbilityReqBo reqBo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u4e0b\u5355\u8fd4\u56deURL Ability\u670d\u52a1(\u652f\u4ed8-\u4ea7\u54c1) -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProOrderUrlAbilityRspBo retBo = new PayProOrderUrlAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateArgStr);
            return retBo;
        }
        String reqPayMethod = reqBo.getPayMethod();
        if (!StringUtils.isEmpty((Object)reqPayMethod) && !"50".equals(reqPayMethod)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u672c\u4e0b\u5355\u8fd4\u56deURL\u63a5\u53e3\uff0cpayMethod\u4ec5\u652f\u6301(50)");
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u67e5\u8be2busiCode\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        String cashierTemplateUrl = "";
        if (StringUtils.isEmpty((Object)reqPayMethod)) {
            QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
            queryCashierReqBo.setBusiId(busiCodeRspBo.getBusiId().toString());
            queryCashierReqBo.setReqWay(reqBo.getReqWay());
            QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
            if (!"0000".equals(queryCashierRspBo.getRspCode())) {
                retBo.setRespCode(queryCashierRspBo.getRspCode());
                retBo.setRespDesc(queryCashierRspBo.getRspName());
                return retBo;
            }
            cashierTemplateUrl = queryCashierRspBo.getCashierTemplateUrl();
            if (StringUtils.isEmpty((Object)cashierTemplateUrl)) {
                retBo.setRespCode("8888");
                retBo.setRespDesc("\u8be5\u63a5\u5165\u65b9\u5f0f\u5bf9\u5e94\u7684\u6536\u94f6\u53f0\u6ca1\u6709\u914d\u7f6e\u6536\u94f6\u53f0\u5730\u5740");
                return retBo;
            }
        }
        PayProPreparedOrderCombReqBo createOrderBo = new PayProPreparedOrderCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)createOrderBo);
        createOrderBo.setBusiCode(busiCode);
        PayProPreparedOrderCombRspBo order = this.payProPreparedOrderCombService.createOrder(createOrderBo);
        if (!"0000".equals(order.getRespCode())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528comb\u670d\u52a1\u4e0b\u5355\u5931\u8d25\uff1a" + order.getRespDesc());
            return retBo;
        }
        String secreteOrde = OrderCiphertext.encode((byte[])order.getOrderId().getBytes());
        if (!StringUtils.isEmpty((Object)cashierTemplateUrl)) {
            cashierTemplateUrl = cashierTemplateUrl + "?orderId=" + secreteOrde;
            retBo.setUrl(cashierTemplateUrl);
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRemark(reqBo.getOutRemark());
        retBo.setOrderId(order.getOrderId());
        if (!StringUtils.isEmpty((Object)reqPayMethod)) {
            PayAbleDealPayCombReqBo combOrderBo = new PayAbleDealPayCombReqBo();
            combOrderBo.setOrderId(Long.valueOf(Long.parseLong(order.getOrderId())));
            combOrderBo.setPayMethod(Long.valueOf(Long.parseLong(reqPayMethod)));
            combOrderBo.setExtReqDatas(reqBo.getExtReqDatas());
            PayAbleDealPayCombRspBo payAbleDealPayCombRspBo = this.payAbleDealPayCombService.dealOrder(combOrderBo);
            LOGGER.info("\u8c03\u7528\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u51fa\u53c2[{}]", (Object)JSON.toJSONString((Object)payAbleDealPayCombRspBo));
            if (!"0000".equals(payAbleDealPayCombRspBo.getRespCode())) {
                retBo.setRespCode("8888");
                retBo.setRespDesc("\u652f\u4ed8\u4e2d\u5fc3\u4e0b\u5355\u6210\u529f\uff0c\u4f46\u5916\u90e8\u4e0b\u5355\u5931\u8d25\uff1a" + payAbleDealPayCombRspBo.getRespDesc());
                return retBo;
            }
            retBo.setExtRspDatas(payAbleDealPayCombRspBo.getExtRspDatas());
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc(order.getRespDesc());
        return retBo;
    }

    private String validateArg(PayProOrderUrlAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2BO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqWay())) {
            return "reqWay\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "outOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String totalFee = reqBo.getTotalFee();
        if (StringUtils.isEmpty((Object)totalFee)) {
            return "totalFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            try {
                Long.parseLong(reqBo.getPayMethod());
            }
            catch (NumberFormatException e) {
                return "payMethod\u53ea\u80fd\u4e3a\u6570\u5b57";
            }
        }
        try {
            Long fee = Long.parseLong(totalFee);
            if (fee <= 0L) {
                return "totalFee\u5fc5\u987b\u5927\u4e8e\u96f6";
            }
        }
        catch (NumberFormatException e) {
            return "totalFee\u5fc5\u987b\u4e3a\u6570\u5b57";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

