/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProQryPayMethodAndParaAbilityService;
import com.tydic.payment.pay.ability.bo.PayProPayInsParaDataBo;
import com.tydic.payment.pay.ability.bo.PayProPayMethodDataBo;
import com.tydic.payment.pay.ability.bo.PayProPaymentInsDataBo;
import com.tydic.payment.pay.ability.bo.PayProQryPayMethodAndParaReqBo;
import com.tydic.payment.pay.ability.bo.PayProQryPayMethodAndParaRspBo;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayParaRuleAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PayParaRulePo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.PayProQryPayMethodAndParaAbilityService"})
public class PayProQryPayMethodAndParaAbilityServiceImpl
implements PayProQryPayMethodAndParaAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProQryPayMethodAndParaAbilityServiceImpl.class);
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private PayParaRuleAtomService payParaRuleAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    private Long merchantId;
    private Long paymentInsId;

    @PostMapping(value={"qryPayMethodAndParas"})
    public PayProQryPayMethodAndParaRspBo qryPayMethodAndParas(@RequestBody PayProQryPayMethodAndParaReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("========\u67e5\u8be2\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u5217\u8868\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        this.validateArgs(reqBo);
        PaymentInsPo paymentInsReqPo = new PaymentInsPo();
        paymentInsReqPo.setPaymentInsId(this.paymentInsId);
        List<PaymentInsPo> paymentInsPos = this.paymentInsAtomService.queryPaymentInf(paymentInsReqPo);
        if (CollectionUtils.isEmpty(paymentInsPos)) {
            throw new BusinessException("218004", "\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784\u4fe1\u606f");
        }
        MerchantPayMethodRelPo qryMerchantPayMethodReq = new MerchantPayMethodRelPo();
        qryMerchantPayMethodReq.setMerchantId(this.merchantId);
        List<MerchantPayMethodRelPo> relInfos = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(qryMerchantPayMethodReq);
        if (!CollectionUtils.isEmpty(relInfos)) {
            List relPaymentIds = relInfos.stream().map(MerchantPayMethodRelPo::getPaymentInsId).distinct().collect(Collectors.toList());
            paymentInsPos = paymentInsPos.stream().filter(paymentPo -> !relPaymentIds.contains(paymentPo.getPaymentInsId())).collect(Collectors.toList());
            if (log.isDebugEnabled()) {
                log.debug("\u4ee5\u4e0b\u652f\u4ed8\u673a\u6784\uff1a[{}],\u5df2\u7ed1\u5b9a\uff0c\u672c\u6b21\u5c06\u8fc7\u6ee4\u6389\u3002", relPaymentIds);
            }
        }
        ArrayList<PayProPaymentInsDataBo> paymentInsList = new ArrayList<PayProPaymentInsDataBo>();
        for (PaymentInsPo paymentInsPo : paymentInsPos) {
            PayProPaymentInsDataBo paymentInsDataBo = new PayProPaymentInsDataBo();
            paymentInsDataBo.setPaymentInsId(paymentInsPo.getPaymentInsId());
            paymentInsDataBo.setPaymentInsName(paymentInsPo.getPaymentInsName());
            List<PayProPayMethodDataBo> payMethodList = this.getPayMethod(paymentInsPo.getPaymentInsId());
            paymentInsDataBo.setPayMethodList(payMethodList);
            List<PayProPayInsParaDataBo> payParaList = this.getParaList(paymentInsPo.getPaymentInsId());
            paymentInsDataBo.setPayParaList(payParaList);
            paymentInsList.add(paymentInsDataBo);
        }
        PayProQryPayMethodAndParaRspBo retBo = PayProRspUtil.generateSucRspBo(PayProQryPayMethodAndParaRspBo.class);
        retBo.setPaymentInsList(paymentInsList);
        if (log.isDebugEnabled()) {
            log.debug("\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        log.info("================\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u67e5\u8be2\u7ed3\u675f==================");
        return retBo;
    }

    private List<PayProPayMethodDataBo> getPayMethod(Long paymentInsId) {
        ArrayList<PayProPayMethodDataBo> methodList = new ArrayList<PayProPayMethodDataBo>();
        PayMethodPo reqPo = new PayMethodPo();
        reqPo.setPaymentInsId(paymentInsId);
        List<PayMethodPo> payMethodPos = this.payMethodAtomService.queryPayMethod(reqPo);
        if (CollectionUtils.isEmpty(payMethodPos)) {
            throw new BusinessException("218004", "\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784[" + paymentInsId + "]\u4e0b\u7684\u652f\u4ed8\u65b9\u5f0f");
        }
        for (PayMethodPo po : payMethodPos) {
            PayProPayMethodDataBo dataBo = new PayProPayMethodDataBo();
            dataBo.setPayMethod(po.getPayMethod().toString());
            dataBo.setPayMethodName(po.getPayMethodName());
            dataBo.setPayMethodStatus(po.getPayMethodStatus());
            methodList.add(dataBo);
        }
        return methodList;
    }

    private List<PayProPayInsParaDataBo> getParaList(Long paymentInsId) {
        ArrayList<PayProPayInsParaDataBo> payParaList = new ArrayList<PayProPayInsParaDataBo>();
        PayParaRulePo reqParaPo = new PayParaRulePo();
        reqParaPo.setPaymentInsId(paymentInsId);
        List<PayParaRulePo> retParaPos = this.payParaRuleAtomService.queryPayParaRuleByCondition(reqParaPo);
        if (CollectionUtils.isEmpty(retParaPos)) {
            if (log.isDebugEnabled()) {
                log.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784\u7684\u53c2\u6570\uff0c\u53ef\u80fd\u662f\u652f\u4ed8\u673a\u6784\u672c\u8eab\u6ca1\u6709\u53c2\u6570\uff0c\u5982\uff1a\u73b0\u91d1");
            }
            return payParaList;
        }
        for (PayParaRulePo po : retParaPos) {
            PayProPayInsParaDataBo dataBo = new PayProPayInsParaDataBo();
            BeanUtils.copyProperties((Object)po, (Object)dataBo);
            if (null == po.getNoNeedInput()) {
                dataBo.setNoNeedInput("0");
            } else {
                dataBo.setNoNeedInput(po.getNoNeedInput().toString());
            }
            payParaList.add(dataBo);
        }
        return payParaList;
    }

    private void validateArgs(PayProQryPayMethodAndParaReqBo reqBo) {
        MerChantInfoPo merchantInfo;
        if (null == reqBo) {
            throw new BusinessException("218004", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            throw new BusinessException("218004", "\u5546\u6237ID[merchantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.merchantId = Long.parseLong(reqBo.getMerchantId());
            if (!StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
                this.paymentInsId = Long.parseLong(reqBo.getPaymentInsId());
            }
        }
        catch (NumberFormatException e) {
            throw new BusinessException("218004", "\u5546\u6237ID[merchantId]\u3001\u652f\u4ed8\u673a\u6784\u7f16\u7801[paymentInsId]\u5fc5\u987b\u4e3a\u7eaf\u6570\u5b57");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            PaymentInsPo insReqPo = new PaymentInsPo();
            insReqPo.setPaymentInsId(this.paymentInsId);
            List<PaymentInsPo> insRetPo = this.paymentInsAtomService.queryPaymentInf(insReqPo);
            if (CollectionUtils.isEmpty(insRetPo)) {
                throw new BusinessException("218004", "\u652f\u4ed8\u673a\u6784\u7f16\u7801[" + this.paymentInsId + "]\u4e0d\u5b58\u5728");
            }
        }
        if (null == (merchantInfo = this.merchantInfoAtomService.queryMerchantInfoById(this.merchantId))) {
            throw new BusinessException("218004", "\u5546\u6237[" + this.merchantId + "]\u4e0d\u5b58\u5728");
        }
    }
}

