/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.busi.AddInfoBusiSystemService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.AddInfoBusiSystemReqAndTempBo;
import com.tydic.payment.pay.busi.bo.AddInfoBusiSystemReqBo;
import com.tydic.payment.pay.busi.bo.AddInfoBusiSystemRspBo;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.rsa.util.RsaEncodeUtil;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="addInfoBusiSystemService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.busi.AddInfoBusiSystemService"})
public class AddInfoBusiSystemServiceImpl
implements AddInfoBusiSystemService {
    private static final Logger log = LoggerFactory.getLogger(AddInfoBusiSystemServiceImpl.class);
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"addInfoBusiSystem"})
    public AddInfoBusiSystemRspBo addInfoBusiSystem(@RequestBody AddInfoBusiSystemReqBo bo) {
        log.info("\u751f\u6210\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u5165\u53c2\uff1a" + bo);
        this.validateArg(bo);
        AddInfoBusiSystemRspBo retBo = new AddInfoBusiSystemRspBo();
        BusiSystemInfoPO addBusiPo = new BusiSystemInfoPO();
        Map map = new HashMap();
        try {
            map = RsaEncodeUtil.generateRSAKeys();
            BeanUtils.copyProperties((Object)bo, (Object)addBusiPo);
            addBusiPo.setRsaPrivateKey((String)map.get("private"));
            addBusiPo.setRsaPublicKey((String)map.get("public"));
            addBusiPo.setSignKey(RsaEncodeUtil.getRandomStringByLength((int)32));
            addBusiPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            addBusiPo.setCallType(Integer.valueOf(bo.getCallType()));
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff1a\u751f\u6210\u516c\u94a5\u79c1\u94a5\u5f02\u5e38");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff1a\u751f\u6210\u516c\u94a5\u79c1\u94a5\u5f02\u5e38");
        }
        Long crateBusiSystemInfo = this.busiSystemInfoAtomService.crateBusiSystemInfo(addBusiPo);
        List reqAndTempList = bo.getReqAndTempList();
        for (AddInfoBusiSystemReqAndTempBo tBo : reqAndTempList) {
            CashierTemplatePo qryTmpPo = new CashierTemplatePo();
            qryTmpPo.setCashierTemplate(Long.valueOf(tBo.getCashierTemplate()));
            List<CashierTemplatePo> queryCashierTemplateByCondition = this.cashierTemplateAtomService.queryCashierTemplateByCondition(qryTmpPo);
            if (queryCashierTemplateByCondition.isEmpty()) {
                log.error("\u6a21\u677f" + tBo.getCashierTemplate() + "\u4e0d\u5b58\u5728");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6a21\u677f" + tBo.getCashierTemplate() + "\u4e0d\u5b58\u5728");
            }
            RelBusiCashierPo relBCPo = new RelBusiCashierPo();
            BeanUtils.copyProperties((Object)tBo, (Object)relBCPo);
            relBCPo.setBusiId(crateBusiSystemInfo);
            relBCPo.setCashierTemplate(Long.valueOf(tBo.getCashierTemplate()));
            this.relBusiCashierAtomService.createRelBusiCashier(relBCPo);
        }
        BusiSystemInfoPO qryBusiPo = new BusiSystemInfoPO();
        qryBusiPo.setBusiId(crateBusiSystemInfo);
        List<BusiSystemInfoPO> queryBusiSystemInfoByCondition = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(qryBusiPo);
        BeanUtils.copyProperties((Object)queryBusiSystemInfoByCondition.get(0), (Object)retBo);
        retBo.setRspCode("0000");
        retBo.setRspName("\u751f\u6210\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff01");
        return retBo;
    }

    private void validateArg(AddInfoBusiSystemReqBo bo) {
        if (bo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getBusiName() == null || bo.getBusiName().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027BusiName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getState() == null || bo.getState().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027State\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!("1".equals(bo.getState().trim()) || "-1".equals(bo.getState().trim()) || "0".equals(bo.getState().trim()))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027State\u5fc5\u987b\u4e3a1\uff0c-1\u6216\u80050");
        }
        List reqAndTempList = bo.getReqAndTempList();
        if (reqAndTempList == null || reqAndTempList.isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (AddInfoBusiSystemReqAndTempBo tmpBo : reqAndTempList) {
            if (tmpBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tmpBo.getReqWay() == null || tmpBo.getReqWay().trim().isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027ReqWay\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tmpBo.getCashierTemplate() != null && !tmpBo.getCashierTemplate().trim().isEmpty()) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027CashierTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

