/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alipay.api.response.AlipayTradeCloseResponse;
import com.tydic.payment.pay.ali.model.AliPayCloseRequestBuilder;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeServiceImpl;
import com.tydic.payment.pay.busi.AliPayCloseBusiService;
import com.tydic.payment.pay.busi.bo.AliPayCloseBusiServiceReqBO;
import com.tydic.payment.pay.busi.bo.AliPayCloseBusiServiceRspBO;
import com.tydic.payment.pay.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="pmcAliPayCloseBusiService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.busi.AliPayCloseBusiService"})
public class AliPayCloseBusiServiceImpl
implements AliPayCloseBusiService {
    private static final Logger log = LoggerFactory.getLogger(AliPayCloseBusiServiceImpl.class);

    @PostMapping(value={"dealAliPayClose"})
    public AliPayCloseBusiServiceRspBO dealAliPayClose(@RequestBody AliPayCloseBusiServiceReqBO req) throws Exception {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (req.getParamMap().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AliPayCloseRequestBuilder builder = new AliPayCloseRequestBuilder().setOutTradeNo(req.getPayOrderId());
        AlipayTradeServiceImpl tradeService = new AlipayTradeServiceImpl.ClientBuilder().build(String.valueOf(req.getParamMap().get("appid")), String.valueOf(req.getParamMap().get("privateKey")), String.valueOf(req.getParamMap().get("publicKey")), "");
        AlipayTradeCloseResponse result = tradeService.close(builder);
        log.info("\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\uff0c\u652f\u4ed8\u5b9d\u8fd4\u56de\u72b6\u6001\uff1a" + result.isSuccess());
        log.info("\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\uff0c\u652f\u4ed8\u5b9d\u8fd4\u4e1a\u52a1\u7f16\u7801\uff1a" + result.getSubCode());
        log.info("\u652f\u4ed8\u5b9d\u5173\u95ed\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\uff0c\u652f\u4ed8\u5b9d\u8fd4\u56de\uff1a" + result);
        AliPayCloseBusiServiceRspBO rsp = new AliPayCloseBusiServiceRspBO();
        if (result.isSuccess()) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
        } else if ("ACQ.TRADE_STATUS_ERROR".equals(result.getSubCode()) || "ACQ.TRADE_NOT_EXIST".equals(result.getSubCode())) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
        } else {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5173\u95ed\u8ba2\u5355\u5931\u8d25\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u65e5\u5fd7");
        }
        return rsp;
    }
}

