/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.tydic.payment.pay.ali.model.AlipayF2FRefundResult;
import com.tydic.payment.pay.ali.model.AlipayTradeRefundRequestBuilder;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.AliRefundService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.AliRefundReqBo;
import com.tydic.payment.pay.busi.bo.AliRefundRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="aliRefundService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.busi.AliRefundService"})
public class AliRefundServiceImpl
implements AliRefundService {
    private static final Logger log = LoggerFactory.getLogger(AliRefundServiceImpl.class);
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"dealAliRefund"})
    public AliRefundRspBo dealAliRefund(@RequestBody AliRefundReqBo aliRefundReqBo) {
        if (StringUtils.isEmpty((String)aliRefundReqBo.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u652f\u4ed8\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (aliRefundReqBo.getRefundFee() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AliRefundRspBo aliRefundRspBo = new AliRefundRspBo();
        try {
            QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
            paraReq.setMerchantId(String.valueOf(aliRefundReqBo.getMerchantId()));
            paraReq.setPayMethod(aliRefundReqBo.getPayMethod());
            QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
            if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + aliRefundReqBo.getMerchantId() + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
            }
            if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + aliRefundReqBo.getMerchantId() + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
            }
            Map<String, Object> paramMap = this.getParamMap(paraInfo);
            String appid = (String)paramMap.get("appid");
            String privateKey = (String)paramMap.get("privateKey");
            String publicKey = (String)paramMap.get("publicKey");
            AlipayTradeServiceImpl tradeService = new AlipayTradeServiceImpl.ClientBuilder().build(appid, privateKey, publicKey, "");
            AlipayTradeRefundRequestBuilder builder = new AlipayTradeRefundRequestBuilder().setOutTradeNo(aliRefundReqBo.getPayOrderId()).setRefundAmount(String.valueOf(MoneyUtils.fenToYuan((BigDecimal)aliRefundReqBo.getRefundFee()))).setRefundReason(aliRefundReqBo.getRefundReason()).setOutRequestNo(aliRefundReqBo.getRefundOrderId()).setStoreId(String.valueOf(aliRefundReqBo.getMerchantId()));
            AlipayF2FRefundResult result = tradeService.tradeRefund(builder);
            log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u8fd4\u56de\u4e3a\uff1a " + result.getResponse().getMsg());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String tradeTime = "";
            tradeTime = result.getResponse().getGmtRefundPay() == null ? new SimpleDateFormat("yyyyMMddHHmmss").format(this.queryDBDateBusiService.getDBDate()) : sdf.format(result.getResponse().getGmtRefundPay());
            PorderRefundTransAtomReqBo porderRefundTransAtomReqBo = new PorderRefundTransAtomReqBo();
            porderRefundTransAtomReqBo.setRefundOrderId(aliRefundReqBo.getRefundOrderId());
            porderRefundTransAtomReqBo.setOrderId(aliRefundReqBo.getRefundId());
            PorderPo orderNew = new PorderPo();
            orderNew.setOrderId(aliRefundReqBo.getRefundId());
            if ("SUCCESS".equals(result.getTradeStatus().toString())) {
                aliRefundRspBo.setRefundStatus("SUCCESS");
                aliRefundRspBo.setTradeTime(tradeTime);
                aliRefundRspBo.setRspName("\u9000\u6b3e\u6210\u529f");
                orderNew.setOrderStatus("B10");
                orderNew.setTradeTime(tradeTime);
                porderRefundTransAtomReqBo.setOrderStatus("B10");
                porderRefundTransAtomReqBo.setTradeTime(tradeTime);
                porderRefundTransAtomReqBo.setPayNotifyTransId(String.valueOf(aliRefundReqBo.getRefundId()));
            } else {
                aliRefundRspBo.setRefundStatus("FAIL");
                aliRefundRspBo.setRspName("\u6210\u529f");
                aliRefundRspBo.setMsg(result.getResponse().getSubMsg());
                orderNew.setOrderStatus("B20");
                porderRefundTransAtomReqBo.setOrderStatus("B20");
                porderRefundTransAtomReqBo.setPayMsg(result.getResponse().getSubMsg());
                porderRefundTransAtomReqBo.setTradeTime(tradeTime);
            }
            this.payOrderAtomService.update(orderNew);
            int count = this.porderRefundTransAtomService.updateOrderRefundTransByRefundOrderId(porderRefundTransAtomReqBo);
            if (count == 0) {
                log.info("\u66f4\u65b0\u9000\u6b3e\u6570\u636e\u5931\u8d25");
            }
            aliRefundRspBo.setRspCode("0000");
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u8c03\u7528\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            aliRefundRspBo.setRspCode("8888");
            aliRefundRspBo.setRefundStatus("FAIL");
            aliRefundRspBo.setRspName("\u652f\u4ed8\u5b9d\u9000\u6b3e\u8c03\u7528\u5f02\u5e38" + e.getMessage());
            aliRefundRspBo.setMsg("\u652f\u4ed8\u5b9d\u9000\u6b3e\u8c03\u7528\u5f02\u5e38");
        }
        return aliRefundRspBo;
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

