/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.config.PayProCacheManager;
import com.tydic.payment.pay.constant.PayProCacheKeys;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayProQueryPayParaBusiServiceImpl
implements PayProQueryPayParaBusiService {
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private PayParaInfoAtomService payParaInfoAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private PayProCacheManager payProCacheManager;

    public PayProQueryPayParaBusiRspBo queryPayPara(PayProQueryPayParaBusiReqBo reqBo) {
        PayProQueryPayParaBusiRspBo retBo = new PayProQueryPayParaBusiRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Long merchantId = reqBo.getMerchantId();
        Long paymentInsId = reqBo.getPaymentInsId();
        Long payMethod = reqBo.getPayMethod();
        String cacheKey = PayProCacheKeys.PAY_CACHE_MERCHANT_PAYMETHOD_PARA.getKey() + merchantId.toString() + "_" + payMethod.toString();
        PayProQueryPayParaBusiRspBo cacheRetBo = this.payProCacheManager.get(cacheKey, PayProQueryPayParaBusiRspBo.class);
        if (cacheRetBo != null) {
            return cacheRetBo;
        }
        MerChantInfoPo qryMerchantPo = new MerChantInfoPo();
        qryMerchantPo.setMerchantId(merchantId);
        List<MerChantInfoPo> queryMerChantInfoByCondition = this.merchantInfoAtomService.queryMerChantInfoByCondition(qryMerchantPo);
        if (queryMerChantInfoByCondition.isEmpty()) {
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u5546\u6237:" + merchantId + "\u4e0d\u5b58\u5728");
            return retBo;
        }
        MerchantPayMethodRelPo qryRelPo = new MerchantPayMethodRelPo();
        qryRelPo.setPayMethod(payMethod);
        qryRelPo.setMerchantId(merchantId);
        qryRelPo.setPaymentInsId(paymentInsId);
        List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(qryRelPo);
        if (queryMerchantPayMethodRelByCondition.isEmpty()) {
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u6b64\u5546\u6237(" + merchantId + ")\u672a\u914d\u7f6e\u8be5\u652f\u4ed8\u65b9\u5f0f");
            return retBo;
        }
        MerchantPayMethodRelPo relPo = queryMerchantPayMethodRelByCondition.get(0);
        if ("0".equals(relPo.getStatus())) {
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u6b64\u5546\u6237(" + merchantId + ")\u914d\u7f6e\u7684\u6b64\u652f\u4ed8\u65b9\u5f0f\u672a\u542f\u7528");
            return retBo;
        }
        Long payParaId = relPo.getPayParaId();
        PayParaInfoPo qryPayParaInfo = new PayParaInfoPo();
        qryPayParaInfo.setPayParaId(payParaId);
        List<PayParaInfoPo> queryPayParaInfoByCondition = this.payParaInfoAtomService.queryPayParaInfoByCondition(qryPayParaInfo);
        if (queryPayParaInfoByCondition.isEmpty()) {
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u8be5\u652f\u4ed8\u914d\u7f6e(" + payParaId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        if (!"1".equals(queryPayParaInfoByCondition.get(0).getState())) {
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u8be5\u652f\u4ed8\u914d\u7f6e(" + payParaId + ")\u5df2\u5931\u6548");
            return retBo;
        }
        PayParaInfoAttrPo queryPayAttrPo = new PayParaInfoAttrPo();
        queryPayAttrPo.setPayParaId(queryPayParaInfoByCondition.get(0).getPayParaId());
        List<PayParaInfoAttrPo> queryPayParaInfoAttrByCondition = this.payParaInfoAttrAtomService.queryPayParaInfoAttrByCondition(queryPayAttrPo);
        if (queryPayParaInfoAttrByCondition.isEmpty()) {
            if (PayProConstants.PayMethod.CASH_PAY.getPayMethod().longValue() == payMethod.longValue() || PayProConstants.PayMethod.UMC_PAY_BALANCE.getPayMethod().longValue() == payMethod.longValue()) {
                retBo.setRespCode("0000");
                retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
                retBo.setDetailAttrs(new HashMap(16));
                return retBo;
            }
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237(" + merchantId + ")\u8be6\u7ec6\u53c2\u6570\u914d\u7f6e");
            return retBo;
        }
        HashMap<String, String> detailMap = new HashMap<String, String>(queryPayParaInfoAttrByCondition.size());
        this.sortMap(queryPayParaInfoAttrByCondition, detailMap);
        retBo.setDetailAttrs(detailMap);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        this.payProCacheManager.set(cacheKey, retBo, true, null);
        return retBo;
    }

    private void sortMap(List<PayParaInfoAttrPo> queryPayParaInfoAttrByCondition, Map<String, String> detailMap) {
        for (PayParaInfoAttrPo tpo : queryPayParaInfoAttrByCondition) {
            detailMap.put(tpo.getAttrCode(), tpo.getAttrValue());
        }
    }

    private String validateArg(PayProQueryPayParaBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Long paymentInsId = reqBo.getPaymentInsId();
        Long payMethod = reqBo.getPayMethod();
        if (StringUtils.isEmpty((Object)paymentInsId) && StringUtils.isEmpty((Object)payMethod)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PaymentInsId\u548cPayMethod\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
        }
        return null;
    }
}

