/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.ability.bo.PayProRelPayMethodDataBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayMethodQueryReqBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayMethodQueryRspBo;
import com.tydic.payment.pay.ability.bo.PayProRelPaymentDataBo;
import com.tydic.payment.pay.busi.PayProRelPayMethodQueryBusiService;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PaymentInsMapper;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="payProRelPayMethodQueryBusiService")
public class PayProRelPayMethodQueryBusiServiceImpl
implements PayProRelPayMethodQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(PayProRelPayMethodQueryBusiServiceImpl.class);
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PaymentInsMapper paymentInsMapper;

    public PayProRelPayMethodQueryRspBo queryRelPayMethod(PayProRelPayMethodQueryReqBo reqBo) {
        PayProRelPayMethodQueryRspBo retBo = new PayProRelPayMethodQueryRspBo();
        ArrayList<PayProRelPaymentDataBo> paymentIns = new ArrayList<PayProRelPaymentDataBo>();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setPaymentIns(paymentIns);
        MerchantPayMethodRelPo reqRelPo = new MerchantPayMethodRelPo();
        reqRelPo.setMerchantId(reqBo.getMerchantId());
        List<MerchantPayMethodRelPo> retRelPos = this.merchantPayMethodRelMapper.queryMerchantPayMethodRelByCondition(reqRelPo);
        if (CollectionUtils.isEmpty(retRelPos)) {
            log.debug("\u67e5\u8be2\u6b64\u5546\u6237\u914d\u7f6e\u7684\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a");
            return retBo;
        }
        Map<Long, String> payInsMap = this.getPayInsMap();
        Map<Long, String> payMethodMap = this.getPayMethodMap();
        Map<Long, MerchantPayMethodRelPo> relMap = retRelPos.stream().collect(Collectors.toMap(MerchantPayMethodRelPo::getPayMethod, retRelPo -> retRelPo));
        HashMap tempMap = new HashMap(16);
        for (Long payMethod : relMap.keySet()) {
            PayProRelPayMethodDataBo payMethodDataBo;
            List<PayProRelPayMethodDataBo> payMethodList;
            MerchantPayMethodRelPo relPo = relMap.get(payMethod);
            Long payInsId = relPo.getPaymentInsId();
            if (tempMap.containsKey(payInsId)) {
                payMethodList = (List)tempMap.get(payInsId);
                payMethodDataBo = new PayProRelPayMethodDataBo();
                payMethodDataBo.setPayMethod(relPo.getPayMethod());
                payMethodDataBo.setPayMethodName(payMethodMap.get(payMethod));
                payMethodDataBo.setStatus(relPo.getStatus());
                payMethodList.add(payMethodDataBo);
                continue;
            }
            payMethodList = new ArrayList();
            payMethodDataBo = new PayProRelPayMethodDataBo();
            payMethodDataBo.setPayMethod(relPo.getPayMethod());
            payMethodDataBo.setPayMethodName(payMethodMap.get(payMethod));
            payMethodDataBo.setStatus(relPo.getStatus());
            payMethodList.add(payMethodDataBo);
            tempMap.put(payInsId, payMethodList);
        }
        for (Long payInsId : tempMap.keySet()) {
            PayProRelPaymentDataBo paymentDataBo = new PayProRelPaymentDataBo();
            paymentDataBo.setPaymentInsId(payInsId);
            paymentDataBo.setPaymentInsName(payInsMap.get(payInsId));
            List payMethodDatas = (List)tempMap.get(payInsId);
            paymentDataBo.setPayMethods(payMethodDatas);
            paymentIns.add(paymentDataBo);
        }
        return retBo;
    }

    private Map<Long, String> getPayMethodMap() {
        HashMap<Long, String> payMethodMap = new HashMap<Long, String>(16);
        List<PayMethodPo> methodPos = this.payMethodMapper.queryPayMethod(new PayMethodPo());
        for (PayMethodPo po : methodPos) {
            payMethodMap.put(po.getPayMethod(), po.getPayMethodName());
        }
        return payMethodMap;
    }

    private Map<Long, String> getPayInsMap() {
        HashMap<Long, String> payInsMap = new HashMap<Long, String>(16);
        List<PaymentInsPo> payIns = this.paymentInsMapper.queryPaymentInf(new PaymentInsPo());
        for (PaymentInsPo insPo : payIns) {
            payInsMap.put(insPo.getPaymentInsId(), insPo.getPaymentInsName());
        }
        return payInsMap;
    }
}

