/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PCodeListAtomService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.dao.po.PCodeListPO;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="queryCodeListByTypecodeService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.busi.QueryCodeListByTypecodeService"})
public class QueryCodeListByTypecodeServiceImpl
implements QueryCodeListByTypecodeService {
    private static final Logger log = LoggerFactory.getLogger(QueryCodeListByTypecodeServiceImpl.class);
    @Autowired
    PCodeListAtomService pCodeListAtomService;

    @PostMapping(value={"queryPCodeListMethod"})
    public QueryCodeListByTypecodeRspBo queryPCodeListMethod(@RequestBody QueryCodeListByTypecodeReqBo bo) {
        log.info("\u901a\u8fc7typeCode\u6765\u67e5\u8be2p_code_list\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)bo));
        QueryCodeListByTypecodeRspBo rspBo = new QueryCodeListByTypecodeRspBo();
        ArrayList<PCodeListBoStr> rspList = new ArrayList<PCodeListBoStr>();
        this.validateArg(bo);
        PCodeListPO po = new PCodeListPO();
        po.setTypeCode(bo.getTypeCode());
        List<PCodeListPO> resultAllL = this.pCodeListAtomService.queryPCodeListByCondition(po);
        log.info("\u67e5\u8be2\u51fa\u53c2\u5217\u8868\uff1a" + JSON.toJSONString(resultAllL));
        if (resultAllL == null || resultAllL.isEmpty()) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5b57\u5178\u7c7b\u578b\uff0c\u8bf7\u8bbe\u7f6e\u6570\u636e\u5b57\u5178\u7c7b\u578b\u6570\u636e");
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u67e5\u8be2\u6210\u529f\uff0c\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            return rspBo;
        }
        for (PCodeListPO bpo : resultAllL) {
            PCodeListBoStr pCodeListBoStr = new PCodeListBoStr();
            rspList.add(pCodeListBoStr);
            BeanUtils.copyProperties((Object)bpo, (Object)pCodeListBoStr);
            pCodeListBoStr.setCodeId(bpo.getCodeId() == null ? "" : bpo.getCodeId().toString());
            pCodeListBoStr.setState(bpo.getState() == null ? "" : bpo.getState().toString());
            pCodeListBoStr.setUpperCodeId(bpo.getUpperCodeId() == null ? "" : bpo.getUpperCodeId().toString());
        }
        rspBo.setCodeList(rspList);
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u901a\u8fc7typeCode\u6765\u67e5\u8be2p_code_list\u670d\u52a1\u6210\u529f");
        return rspBo;
    }

    private void validateArg(QueryCodeListByTypecodeReqBo bo) {
        if (bo == null) {
            log.info("\u901a\u8fc7typeCode\u6765\u67e5\u8be2p_code_list\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u8fc7typeCode\u6765\u67e5\u8be2p_code_list\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getTypeCode() == null || bo.getTypeCode().trim().isEmpty()) {
            log.info("\u901a\u8fc7typeCode\u6765\u67e5\u8be2p_code_list\u670d\u52a1\u3010typeCode\u3011\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u8fc7typeCode\u6765\u67e5\u8be2p_code_list\u670d\u52a1\u3010typeCode\u3011\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

