/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.tydic.payment.pay.comb.PayProQuerySuccessDataCombService;
import com.tydic.payment.pay.comb.bo.PayProQuerySuccessDataCombServicePayCenterRspBo;
import com.tydic.payment.pay.comb.bo.PayProQuerySuccessDataCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProQuerySuccessDataCombServiceRspBo;
import com.tydic.payment.pay.comb.bo.PayProQuerySuccessDataCombServiceThirdRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.SuccessDataWithPayCenterPo;
import com.tydic.payment.pay.dao.po.SuccessDataWithThirdPayPo;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="payProQuerySuccessDataCombService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.comb.PayProQuerySuccessDataCombService"})
public class PayProQuerySuccessDataCombServiceImpl
implements PayProQuerySuccessDataCombService {
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    private DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    @PostMapping(value={"querySuccessData"})
    public PayProQuerySuccessDataCombServiceRspBo querySuccessData(@RequestBody PayProQuerySuccessDataCombServiceReqBo reqBo) {
        PayProQuerySuccessDataCombServiceRspBo rspBo = new PayProQuerySuccessDataCombServiceRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("213009");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        Long merchantId = Long.parseLong(reqBo.getMerchantId());
        String startDateStr = reqBo.getStartDate();
        startDateStr = startDateStr + " 00:00:00";
        String endDateStr = reqBo.getEndDate();
        endDateStr = endDateStr + " 23:59:59";
        Date startDate = DateTime.parse((String)startDateStr, (DateTimeFormatter)this.timeFormatter).toDate();
        Date endDate = DateTime.parse((String)endDateStr, (DateTimeFormatter)this.timeFormatter).toDate();
        SuccessDataWithPayCenterPo paySuccessPo = new SuccessDataWithPayCenterPo();
        paySuccessPo.setMerchantId(merchantId);
        paySuccessPo.setOrderStatus("A10");
        paySuccessPo.setOrderType("01");
        paySuccessPo.setStartTime(startDate);
        paySuccessPo.setEndTime(endDate);
        SuccessDataWithPayCenterPo paySuccessResult = this.porderMapper.querySuccessData(paySuccessPo);
        SuccessDataWithPayCenterPo refundSuccessPo = new SuccessDataWithPayCenterPo();
        refundSuccessPo.setMerchantId(merchantId);
        refundSuccessPo.setOrderStatus("B10");
        refundSuccessPo.setOrderType("02");
        refundSuccessPo.setStartTime(startDate);
        refundSuccessPo.setEndTime(endDate);
        SuccessDataWithPayCenterPo refundSuccessResult = this.porderMapper.querySuccessData(refundSuccessPo);
        PayProQuerySuccessDataCombServicePayCenterRspBo payCenterData = new PayProQuerySuccessDataCombServicePayCenterRspBo();
        payCenterData.setPaySuccessCount(paySuccessResult.getSuccessCount().toString());
        payCenterData.setPayTotalFee(MoneyUtils.haoToYuan((Long)paySuccessResult.getTotalFee()).toString());
        payCenterData.setRefundSuccessCount(refundSuccessResult.getSuccessCount().toString());
        payCenterData.setRefundTotalFee(MoneyUtils.haoToYuan((Long)refundSuccessResult.getTotalFee()).toString());
        SuccessDataWithThirdPayPo queryThirdPaySuccessPo = new SuccessDataWithThirdPayPo();
        queryThirdPaySuccessPo.setMerchantId(merchantId);
        queryThirdPaySuccessPo.setOrderStatus("A10");
        queryThirdPaySuccessPo.setStartTime(startDate);
        queryThirdPaySuccessPo.setEndTime(endDate);
        SuccessDataWithThirdPayPo thirdPaySuccessResult = this.porderPayTransMapper.queryThirdPayTransData(queryThirdPaySuccessPo);
        SuccessDataWithThirdPayPo queryThirdRefundSuccessPo = new SuccessDataWithThirdPayPo();
        queryThirdRefundSuccessPo.setMerchantId(merchantId);
        queryThirdRefundSuccessPo.setOrderStatus("B10");
        queryThirdRefundSuccessPo.setStartTime(startDate);
        queryThirdRefundSuccessPo.setEndTime(endDate);
        SuccessDataWithThirdPayPo thirdRefundSuccessResult = this.porderPayTransMapper.queryThirdRefundTransData(queryThirdRefundSuccessPo);
        PayProQuerySuccessDataCombServiceThirdRspBo thirdData = new PayProQuerySuccessDataCombServiceThirdRspBo();
        thirdData.setPaySuccessCount(thirdPaySuccessResult.getSuccessCount().toString());
        thirdData.setPayTotalFee(MoneyUtils.haoToYuan((Long)thirdPaySuccessResult.getTotalFee()).toString());
        thirdData.setRefundSuccessCount(thirdRefundSuccessResult.getSuccessCount().toString());
        thirdData.setRefundTotalFee(MoneyUtils.haoToYuan((Long)thirdRefundSuccessResult.getTotalFee()).toString());
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setPayCenterData(payCenterData);
        rspBo.setThirdData(thirdData);
        return rspBo;
    }

    private String validateArg(PayProQuerySuccessDataCombServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            Long.parseLong(reqBo.getMerchantId());
        }
        catch (NumberFormatException e) {
            return "merchantId\u5fc5\u987b\u4e3a\u6574\u578b\u6570\u5b57";
        }
        if (StringUtils.isEmpty((Object)reqBo.getStartDate())) {
            return "\u5165\u53c2\u5c5e\u6027startDate\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            DateTime.parse((String)reqBo.getStartDate(), (DateTimeFormatter)this.dateFormatter).toDate();
        }
        catch (Exception e) {
            return "\u5165\u53c2\u5c5e\u6027startDate\u683c\u5f0f\u5fc5\u987b\u4e3a\uff1ayyyy-MM-dd";
        }
        if (StringUtils.isEmpty((Object)reqBo.getEndDate())) {
            return "\u5165\u53c2\u5c5e\u6027endDate\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            DateTime.parse((String)reqBo.getEndDate(), (DateTimeFormatter)this.dateFormatter).toDate();
        }
        catch (Exception e) {
            return "\u5165\u53c2\u5c5e\u6027endDate\u683c\u5f0f\u5fc5\u987b\u4e3a\uff1ayyyy-MM-dd";
        }
        if (reqBo.getStartDate().equals(reqBo.getEndDate())) {
            // empty if block
        }
        return null;
    }
}

