/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.PayProQueryCodeListBusiService;
import com.tydic.payment.pay.busi.bo.PayProQueryCodeListBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryCodeListBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.BillCompareDiffMapper;
import com.tydic.payment.pay.dao.po.BillCompareDiffPO;
import com.tydic.payment.pay.dao.po.BillCompareDiffPageReqPO;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.web.bo.req.BillCompareDiffQueryWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.BillCompareDiffQueryWebRspBo;
import com.tydic.payment.pay.web.service.BillCompareDiffQueryWebService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="billCompareDiffQueryWebService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.BillCompareDiffQueryWebService"})
public class BillCompareDiffQueryWebServiceImpl
implements BillCompareDiffQueryWebService {
    private static final String SERVICE_NAME = "\u5bf9\u8d26\u5dee\u5f02\u8868\u67e5\u8be2web\u670d\u52a1";
    private static final Logger LOG = LoggerFactory.getLogger(BillCompareDiffQueryWebServiceImpl.class);
    @Autowired
    private BillCompareDiffMapper billCompareDiffMapper;
    @Autowired
    private PayProQueryCodeListBusiService payProQueryCodeListBusiService;
    private static final String NO_RESULT = "-";
    private static final String payOrder = "\u652f\u4ed8\u8ba2\u5355";
    private static final String refundOrder = "\u9000\u6b3e\u8ba2\u5355";
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;

    @PostMapping(value={"queryListWithPage"})
    public RspPage<BillCompareDiffQueryWebRspBo> queryListWithPage(@RequestBody BillCompareDiffQueryWebReqBo reqBo) {
        Page billCompareDiffPageReqPOPage;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5bf9\u8d26\u5dee\u5f02\u8868\u67e5\u8be2web\u670d\u52a1-> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        BillCompareDiffPageReqPO billCompareDiffPageReqPO = new BillCompareDiffPageReqPO();
        RspPage retBo = new RspPage();
        ArrayList<BillCompareDiffQueryWebRspBo> rspList = new ArrayList<BillCompareDiffQueryWebRspBo>();
        retBo.setRows(rspList);
        billCompareDiffPageReqPO = this.notEmptyAssignment(reqBo);
        if (reqBo.getPageNo() > 1) {
            billCompareDiffPageReqPOPage = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            billCompareDiffPageReqPOPage = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)billCompareDiffPageReqPOPage);
            if (billCompareDiffPageReqPOPage.getPageNo() < 1) {
                billCompareDiffPageReqPOPage.setPageNo(1);
            }
            if (billCompareDiffPageReqPOPage.getPageSize() < 1) {
                billCompareDiffPageReqPOPage.setPageSize(10);
            }
        }
        List<BillCompareDiffPO> billCompareDiffPageReqPOList = this.billCompareDiffMapper.selectBillCompareDiffByPage((Page<BillCompareDiffPageReqPO>)billCompareDiffPageReqPOPage, billCompareDiffPageReqPO);
        if (!CollectionUtils.isEmpty(billCompareDiffPageReqPOList)) {
            Map<String, Map<String, String>> codeListMap = this.queryCodeList();
            HashMap<String, String> paymentInsMap = new HashMap<String, String>();
            List<PaymentInsPo> paymentInsPos = this.paymentInsAtomService.queryAllPaymentIdAndName(new PaymentInsPo());
            for (PaymentInsPo tp : paymentInsPos) {
                paymentInsMap.put(tp.getPaymentInsId() + "", tp.getPaymentInsName());
            }
            for (BillCompareDiffPO tempPo : billCompareDiffPageReqPOList) {
                BillCompareDiffQueryWebRspBo tempBo = this.valuePasser(tempPo);
                if (!StringUtils.isEmpty(paymentInsMap.get(tempBo.getPaymentInsId()))) {
                    tempBo.setPaymentInsId((String)paymentInsMap.get(tempBo.getPaymentInsId()));
                } else {
                    tempBo.setPaymentInsId(NO_RESULT);
                }
                String diffType = tempBo.getDiffType();
                if (!StringUtils.isEmpty((Object)diffType)) {
                    Map<String, String> diffTypeMap = codeListMap.get("BILL_COMPARE_DIFF_DIFF_TYPE");
                    if (diffTypeMap != null && !StringUtils.isEmpty((Object)diffTypeMap.get(diffType))) {
                        tempBo.setDiffType(diffTypeMap.get(diffType));
                    } else {
                        tempBo.setDiffType(NO_RESULT);
                    }
                } else {
                    tempBo.setDiffType(NO_RESULT);
                }
                String dealFlag = tempBo.getDealFlag();
                if (!StringUtils.isEmpty((Object)dealFlag)) {
                    Map<String, String> dealFlagMap = codeListMap.get("BILL_COMPARE_DIFF_DEAL_FLAG");
                    if (dealFlagMap != null && !StringUtils.isEmpty((Object)dealFlagMap.get(dealFlag))) {
                        tempBo.setDealFlag(dealFlagMap.get(dealFlag));
                    } else {
                        tempBo.setDealFlag(NO_RESULT);
                    }
                } else {
                    tempBo.setDealFlag(NO_RESULT);
                }
                String orderType = tempBo.getOrderType();
                if (!StringUtils.isEmpty((Object)orderType)) {
                    if (orderType.equals("01")) {
                        tempBo.setOrderType(payOrder);
                    } else if (orderType.equals("02")) {
                        tempBo.setOrderType(refundOrder);
                    }
                }
                rspList.add(tempBo);
            }
        }
        retBo.setRecordsTotal(billCompareDiffPageReqPOPage.getTotalCount());
        retBo.setTotal(billCompareDiffPageReqPOPage.getTotalPages());
        retBo.setPageNo(billCompareDiffPageReqPOPage.getPageNo());
        return retBo;
    }

    private Map<String, Map<String, String>> queryCodeList() {
        HashMap<String, Map<String, String>> codeListMap = new HashMap<String, Map<String, String>>();
        PayProQueryCodeListBusiReqBo querCodeListBo = new PayProQueryCodeListBusiReqBo();
        querCodeListBo.setTypeCode("BILL_COMPARE_DIFF_DIFF_TYPE");
        PayProQueryCodeListBusiRspBo qryDiffRetBo = this.payProQueryCodeListBusiService.querCodeList(querCodeListBo);
        if (qryDiffRetBo.getData() != null) {
            codeListMap.put("BILL_COMPARE_DIFF_DIFF_TYPE", qryDiffRetBo.getData());
        }
        querCodeListBo.setTypeCode("BILL_COMPARE_DIFF_DEAL_FLAG");
        PayProQueryCodeListBusiRspBo qryDealFlagRetBo = this.payProQueryCodeListBusiService.querCodeList(querCodeListBo);
        if (qryDealFlagRetBo.getData() != null) {
            codeListMap.put("BILL_COMPARE_DIFF_DEAL_FLAG", qryDealFlagRetBo.getData());
        }
        return codeListMap;
    }

    public BillCompareDiffQueryWebRspBo valuePasser(BillCompareDiffPO tempPo) {
        String dateStr;
        BillCompareDiffQueryWebRspBo tempBo = new BillCompareDiffQueryWebRspBo();
        BeanUtils.copyProperties((Object)tempPo, (Object)tempBo);
        if (!StringUtils.isEmpty((Object)tempPo.getBusiId())) {
            tempBo.setBusiId(tempPo.getBusiId() + "");
        }
        if (!StringUtils.isEmpty((Object)tempPo.getPaymentInsId())) {
            tempBo.setPaymentInsId(tempPo.getPaymentInsId() + "");
        }
        if (!StringUtils.isEmpty((Object)tempPo.getBillDate())) {
            String date = tempPo.getBillDate() + "";
            tempBo.setBillDate(date.substring(0, 4) + NO_RESULT + date.substring(4, 6) + NO_RESULT + date.substring(6, 8));
        }
        if (!StringUtils.isEmpty((Object)tempPo.getOrderId())) {
            tempBo.setOrderId(tempPo.getOrderId() + "");
        }
        if (!StringUtils.isEmpty((Object)tempPo.getTotalFee())) {
            tempBo.setTotalFee(tempPo.getTotalFee() + "");
        }
        if (!StringUtils.isEmpty((Object)tempPo.getPayTotalFee())) {
            tempBo.setPayTotalFee(tempPo.getPayTotalFee() + "");
        }
        if (!StringUtils.isEmpty((Object)tempPo.getDealFlag())) {
            tempBo.setDealFlag(tempPo.getDealFlag() + "");
        }
        if (!StringUtils.isEmpty((Object)tempPo.getDiffType())) {
            tempBo.setDiffType(tempPo.getDiffType() + "");
        }
        if (!StringUtils.isEmpty((Object)(dateStr = new DateTime((Object)tempPo.getCreateDate()).toString("yyyy-MM-dd HH:mm:ss")))) {
            tempBo.setCreateDate(dateStr);
        }
        if (tempPo.getTotalFee() != null) {
            tempBo.setTotalFee(MoneyUtils.fenToYuan((Long)tempPo.getTotalFee()).toString() + "");
        } else {
            tempBo.setTotalFee(NO_RESULT);
        }
        if (tempPo.getPayTotalFee() != null) {
            tempBo.setPayTotalFee(MoneyUtils.fenToYuan((Long)tempPo.getPayTotalFee()).toString() + "");
        } else {
            tempBo.setPayTotalFee(NO_RESULT);
        }
        return tempBo;
    }

    private BillCompareDiffPageReqPO notEmptyAssignment(BillCompareDiffQueryWebReqBo reqBo) {
        BillCompareDiffPageReqPO billCompareDiffPageReqPO = new BillCompareDiffPageReqPO();
        if (!StringUtils.isEmpty((Object)reqBo.getStartBillDate())) {
            billCompareDiffPageReqPO.setBillDateBegin(Long.valueOf(reqBo.getStartBillDate()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getEndBillDate())) {
            billCompareDiffPageReqPO.setBillDateEnd(Long.valueOf(reqBo.getEndBillDate()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiffType())) {
            billCompareDiffPageReqPO.setDiffType(Integer.valueOf(reqBo.getDiffType()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOrderType())) {
            billCompareDiffPageReqPO.setOrderType(reqBo.getOrderType());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            billCompareDiffPageReqPO.setBusiId(Long.valueOf(reqBo.getBusiId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            billCompareDiffPageReqPO.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDealFlag())) {
            billCompareDiffPageReqPO.setDealFlag(Long.valueOf(reqBo.getDealFlag()));
        }
        return billCompareDiffPageReqPO;
    }
}

