/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.MerchantInfoApproveManagerReqBo;
import com.tydic.payment.pay.web.service.MerchantInfoApproveManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="merchantInfoApproveManagerService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.MerchantInfoApproveManagerService"})
public class MerchantInfoApproveManagerServiceImpl
implements MerchantInfoApproveManagerService {
    private static final Logger log = LoggerFactory.getLogger(MerchantInfoApproveManagerServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"approveYes"})
    public BaseRspInfoBO approveYes(@RequestBody MerchantInfoApproveManagerReqBo reqBo) {
        log.info("\u5546\u6237\u5ba1\u6279\u7ba1\u7406\u670d\u52a1 -> \u5ba1\u6279\u901a\u8fc7\u5165\u53c2\uff1a" + reqBo);
        BaseRspInfoBO rsp = new BaseRspInfoBO();
        try {
            if (reqBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            boolean isExit = this.checkMerchantIsExist(reqBo.getMerchantId());
            if (!isExit) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5546\u6237\u4e0d\u5b58\u5728");
                return rsp;
            }
            MerChantInfoPo approvePo = new MerChantInfoPo();
            approvePo.setMerchantId(reqBo.getMerchantId());
            approvePo.setFlag("1");
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                approvePo.setApproveOperId(reqBo.getOperId());
            }
            approvePo.setApproveTime(this.queryDBDateBusiService.getDBDate());
            int updFlag = this.merchantInfoAtomService.updateMerChantInfo(approvePo);
            if (updFlag < 1) {
                log.info("\u8fd4\u56de\u7ed3\u679c\u63cf\u8ff0\uff1a" + JSON.toJSONString((Object)rsp));
                rsp.setRspCode("8888");
                rsp.setRspName("\u5ba1\u6279\u901a\u8fc7\u5931\u8d25\uff1a\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
                return rsp;
            }
            log.info("\u8fd4\u56de\u7ed3\u679c\u63cf\u8ff0\uff1a" + JSON.toJSONString((Object)rsp));
            rsp.setRspCode("0000");
            rsp.setRspName("\u5546\u6237\u5ba1\u6279\u901a\u8fc7\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            log.info("\u5546\u6237\u5ba1\u6279\u7ba1\u7406\u670d\u52a1MerchantInfoApproveManagerService\u5f02\u5e38" + e);
            rsp.setRspCode("8888");
            rsp.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            return rsp;
        }
    }

    @PostMapping(value={"approveReject"})
    public BaseRspInfoBO approveReject(@RequestBody MerchantInfoApproveManagerReqBo reqBo) {
        log.info("\u5546\u6237\u5ba1\u6279\u7ba1\u7406\u670d\u52a1 ->  \u5ba1\u6279\u9a73\u56de\u5165\u53c2\uff1a" + reqBo);
        BaseRspInfoBO rsp = new BaseRspInfoBO();
        try {
            if (reqBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBo.getRejectReason())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010rejectReason\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            boolean isExit = this.checkMerchantIsExist(reqBo.getMerchantId());
            if (!isExit) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5546\u6237\u4e0d\u5b58\u5728");
                return rsp;
            }
            MerChantInfoPo approvePo = new MerChantInfoPo();
            approvePo.setMerchantId(reqBo.getMerchantId());
            approvePo.setFlag("3");
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                approvePo.setApproveOperId(reqBo.getOperId());
            }
            approvePo.setApproveTime(this.queryDBDateBusiService.getDBDate());
            approvePo.setRejectReason(reqBo.getRejectReason());
            int updFlag = this.merchantInfoAtomService.updateMerChantInfo(approvePo);
            if (updFlag < 1) {
                log.info("\u8fd4\u56de\u7ed3\u679c\u63cf\u8ff0\uff1a" + JSON.toJSONString((Object)rsp));
                rsp.setRspName("\u5ba1\u6279\u9a73\u56de\u5931\u8d25\uff1a\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
                rsp.setRspCode("8888");
                return rsp;
            }
            log.info("\u8fd4\u56de\u7ed3\u679c\u63cf\u8ff0\uff1a" + JSON.toJSONString((Object)rsp));
            rsp.setRspCode("0000");
            rsp.setRspName("\u5546\u6237\u5ba1\u6279\u9a73\u56de\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            log.info("\u5546\u6237\u5ba1\u6279\u7ba1\u7406\u670d\u52a1MerchantInfoApproveManagerService\u5f02\u5e38" + e);
            rsp.setRspCode("8888");
            rsp.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            return rsp;
        }
    }

    private boolean checkMerchantIsExist(Long merchantId) {
        MerChantInfoPo result = this.merchantInfoAtomService.queryMerchantInfoById(merchantId);
        return result != null;
    }
}

