/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PayRuleParaAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.dao.po.PayRuleParaPageReqPo;
import com.tydic.payment.pay.dao.po.PayRuleParaPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.PayRuleParaBoStr;
import com.tydic.payment.pay.web.bo.req.QueryPaymentInfParaWebReqBo;
import com.tydic.payment.pay.web.service.QueryPaymentInfParaWebService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="queryPaymentInfParaWebService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.QueryPaymentInfParaWebService"})
public class QueryPaymentInfParaWebServiceImpl
implements QueryPaymentInfParaWebService {
    private static final Logger log = LoggerFactory.getLogger(QueryPaymentInfParaWebServiceImpl.class);
    private static String SERVICE = "QueryPaymentInfParaWebService";
    private static String SERVICE_NAME = "\u67e5\u8be2\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1";
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private QueryCodeListByTypecodeService queryCodeListByTypecodeService;
    @Autowired
    private PayRuleParaAtomService payRuleParaAtomService;

    @PostMapping(value={"queryPayMethodOfPaymentWithPage"})
    public RspPage<PayRuleParaBoStr> queryPayMethodOfPaymentWithPage(@RequestBody QueryPaymentInfParaWebReqBo reqBo) {
        log.info(SERVICE_NAME + " -> " + SERVICE + " \uff1aqueryPayMethodOfPaymentWithPage [\u5206\u9875\u67e5\u8be2\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570]");
        log.info(SERVICE + " -> queryPayMethodOfPaymentWithPage()\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        RspPage retBo = new RspPage();
        ArrayList<PayRuleParaBoStr> payParaL = new ArrayList<PayRuleParaBoStr>();
        retBo.setRows(payParaL);
        this.validateArg(reqBo);
        PaymentInsPo qryPaymPo = new PaymentInsPo();
        qryPaymPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        List<PaymentInsPo> payML = this.paymentInsAtomService.queryPaymentInf(qryPaymPo);
        if (CollectionUtils.isEmpty(payML)) {
            retBo.setPageNo(1);
            retBo.setTotal(0);
            retBo.setRecordsTotal(0);
            return retBo;
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        PayRuleParaPageReqPo paraPo = new PayRuleParaPageReqPo();
        paraPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        List<PayRuleParaPo> qryParaList = this.payRuleParaAtomService.queryPayRuleParaWithPage((Page<PayRuleParaPageReqPo>)page, paraPo);
        if (CollectionUtils.isEmpty(qryParaList)) {
            retBo.setPageNo(1);
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            return retBo;
        }
        QueryCodeListByTypecodeReqBo qryCodeLReq = new QueryCodeListByTypecodeReqBo();
        qryCodeLReq.setTypeCode("NO_NEED_INPUT_FLAG");
        QueryCodeListByTypecodeRspBo qryCodeLRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryCodeLReq);
        List noNeedInputList = qryCodeLRsp.getCodeList();
        HashMap<String, String> codeMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)noNeedInputList)) {
            for (PCodeListBoStr temp : noNeedInputList) {
                codeMap.put(temp.getCodeValue(), temp.getCodeName());
            }
        }
        QueryCodeListByTypecodeReqBo qryCodeLReq2 = new QueryCodeListByTypecodeReqBo();
        qryCodeLReq2.setTypeCode("PAY_PARA_STORE_TYPE");
        QueryCodeListByTypecodeRspBo qryCodeLRsp2 = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryCodeLReq2);
        List storeTypeList = qryCodeLRsp2.getCodeList();
        HashMap<String, String> storeTypeMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)storeTypeList)) {
            for (PCodeListBoStr temp : storeTypeList) {
                storeTypeMap.put(temp.getCodeValue(), temp.getCodeName());
            }
        }
        for (PayRuleParaPo tmp : qryParaList) {
            PayRuleParaBoStr tpBo = new PayRuleParaBoStr();
            BeanUtils.copyProperties((Object)tmp, (Object)tpBo);
            tpBo.setId(tmp.getId().toString());
            tpBo.setCreateOperId(StringUtils.isEmpty((Object)tmp.getCreateOperId()) ? "" : tmp.getCreateOperId());
            tpBo.setPaymentInsId(String.valueOf(tmp.getPaymentInsId()));
            tpBo.setUpdateOperId(StringUtils.isEmpty((Object)tmp.getUpdateOperId()) ? "" : tmp.getUpdateOperId());
            tpBo.setCreateTime(tmp.getCreateTime() == null ? "" : new DateTime((Object)tmp.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            tpBo.setRemark(StringUtils.isEmpty((Object)tmp.getRemark()) ? "" : tmp.getRemark());
            tpBo.setUpdateTime(tmp.getUpdateTime() == null ? "" : new DateTime((Object)tmp.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            if (tmp.getNoNeedInput() != null) {
                tpBo.setNoNeedInput(String.valueOf(tmp.getNoNeedInput()));
                String str = (String)codeMap.get(tmp.getNoNeedInput().toString());
                tpBo.setNoNeedInputName(str);
            }
            if (!StringUtils.isEmpty((Object)tmp.getStoreType())) {
                tpBo.setStoreTypeName(storeTypeMap.get(tpBo.getStoreType()) == null ? "" : (String)storeTypeMap.get(tmp.getStoreType()));
            }
            payParaL.add(tpBo);
        }
        retBo.setRecordsTotal(page.getTotalCount());
        retBo.setTotal(page.getTotalPages());
        retBo.setPageNo(page.getPageNo());
        return retBo;
    }

    private void validateArg(QueryPaymentInfParaWebReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027BusiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

