/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.rsa.util.RsaEncodeUtil;
import com.tydic.payment.pay.web.bo.req.UpdateBusiSystemInfoSimpleWebReqBo;
import com.tydic.payment.pay.web.bo.req.UpdateBusiSystemRelReqWayWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.UpdateBusiSystemInfoSimpleWebRspBo;
import com.tydic.payment.pay.web.service.UpdateInfoBusiSystemSimpleWebService;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="updateInfoBusiSystemSimpleWebService")
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.UpdateInfoBusiSystemSimpleWebService"})
public class UpdateInfoBusiSystemSimpleWebServiceImpl
implements UpdateInfoBusiSystemSimpleWebService {
    private static final Logger log = LoggerFactory.getLogger(UpdateInfoBusiSystemSimpleWebServiceImpl.class);
    private static String SERVICE = "UpdateInfoBusiSystemSimpleWebService";
    private static String SERVICE_NAME = "\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u7b80\u5355\u7248";
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;

    @PostMapping(value={"updateBusiSystemBaseInfo"})
    public UpdateBusiSystemInfoSimpleWebRspBo updateBusiSystemBaseInfo(@RequestBody UpdateBusiSystemInfoSimpleWebReqBo reqBo) {
        int updFlag;
        long qryBusiId;
        List<BusiSystemInfoPO> qryBusiSystemList;
        log.info(SERVICE_NAME + " -> " + SERVICE + " \uff1aupdateBusiSystemBaseInfo [\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf\u57fa\u672c\u4fe1\u606f]");
        log.info(SERVICE + " -> updateBusiSystemBaseInfo()\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        UpdateBusiSystemInfoSimpleWebRspBo retBo = new UpdateBusiSystemInfoSimpleWebRspBo();
        String validateArgStr = this.validateArgWithBusiInfo(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRspCode("RSP_CODE_PARA_NOT_NULL");
            retBo.setRspName("\u5165\u53c2\u6821\u9a8c\u5931\u8d25" + validateArgStr);
            return retBo;
        }
        BusiSystemInfoPO po = new BusiSystemInfoPO();
        if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            po.setBusiId(Long.valueOf(reqBo.getBusiId()));
        }
        if (CollectionUtils.isEmpty(qryBusiSystemList = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(po))) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u5931\u8d25\uff1a\u5bf9\u5e94\u4e1a\u52a1\u7cfb\u7edfid\u4e0d\u5b58\u5728");
            return retBo;
        }
        long realBusiId = Long.valueOf(reqBo.getBusiId());
        BusiSystemInfoPO qryPo = new BusiSystemInfoPO();
        qryPo.setBusiCode(reqBo.getBusiCode());
        List<BusiSystemInfoPO> qryBusiCodeSystemList = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(qryPo);
        if (!CollectionUtils.isEmpty(qryBusiCodeSystemList) && realBusiId != (qryBusiId = qryBusiCodeSystemList.get(0).getBusiId().longValue())) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u5931\u8d25\uff1a\u5bf9\u5e94\u4e1a\u52a1\u7cfb\u7edfbusiCode\u5df2\u5b58\u5728");
            return retBo;
        }
        BusiSystemInfoPO updPo = new BusiSystemInfoPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)updPo);
        if (!StringUtils.isEmpty((Object)reqBo.getCallType())) {
            updPo.setCallType(Integer.valueOf(reqBo.getCallType()));
        }
        updPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
        if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
            updPo.setUpdateOperId(reqBo.getOperId());
        }
        updPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        if (reqBo.getIsNeedUpdateRsa() != null && "1".equals(reqBo.getIsNeedUpdateRsa().trim())) {
            Map<String, String> map = this.genKey();
            updPo.setRsaPrivateKey(map.get("private"));
            updPo.setSignKey(map.get("signKey"));
            updPo.setRsaPublicKey(map.get("public"));
        }
        if ((updFlag = this.busiSystemInfoAtomService.updateBusiSystemInfo(updPo)) < 1) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25");
            return retBo;
        }
        BusiSystemInfoPO qryBusiPo = this.busiSystemInfoAtomService.queryBusiSystemInfoById(Long.valueOf(reqBo.getBusiId()));
        if (qryBusiPo != null) {
            BeanUtils.copyProperties((Object)qryBusiPo, (Object)retBo);
            retBo.setBusiId(qryBusiPo.getBusiId().toString());
            retBo.setCreateTime(qryBusiPo.getCreateTime() == null ? "" : new DateTime((Object)qryBusiPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            retBo.setUpdateTime(qryBusiPo.getUpdateTime() == null ? "" : new DateTime((Object)qryBusiPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            if (!StringUtils.isEmpty((Object)qryBusiPo.getState())) {
                QueryPCodeInfoReqBO qryStateReq = new QueryPCodeInfoReqBO();
                qryStateReq.setTypeCode("BUSI_SYSTEM_STATE");
                qryStateReq.setCodeValue(qryBusiPo.getState());
                QueryPCodeInfoRspBO qryStateRsp = this.queryPCodeInfoService.queryPCodeInfo(qryStateReq);
                if (qryStateRsp.getRespCode().equals("0000")) {
                    retBo.setStateName(qryStateRsp.getCodeInfo());
                }
                retBo.setState(qryBusiPo.getState());
            }
            if (qryBusiPo.getCallType() != null) {
                QueryPCodeInfoReqBO qryCallTypeReq = new QueryPCodeInfoReqBO();
                qryCallTypeReq.setTypeCode("BUSI_SYSTEM_CALL_TYPE");
                qryCallTypeReq.setCodeValue(qryBusiPo.getCallType().toString());
                QueryPCodeInfoRspBO qryCallTypeRsp = this.queryPCodeInfoService.queryPCodeInfo(qryCallTypeReq);
                if (qryCallTypeRsp.getRespCode().equals("0000")) {
                    retBo.setCallTypeName(qryCallTypeRsp.getCodeInfo());
                }
                retBo.setCallType(qryBusiPo.getCallType().toString());
            }
            if (!StringUtils.isEmpty((Object)qryBusiPo.getEncrypt())) {
                QueryPCodeInfoReqBO qryEncryptReq = new QueryPCodeInfoReqBO();
                qryEncryptReq.setTypeCode("BUSI_SYSTEM_ENCRYPT");
                qryEncryptReq.setCodeValue(qryBusiPo.getEncrypt());
                QueryPCodeInfoRspBO qryEncryptRsp = this.queryPCodeInfoService.queryPCodeInfo(qryEncryptReq);
                if (qryEncryptRsp.getRespCode().equals("0000")) {
                    retBo.setEncryptName(qryEncryptRsp.getCodeInfo());
                }
                retBo.setEncrypt(qryBusiPo.getEncrypt());
            }
        }
        retBo.setRspCode("0000");
        retBo.setRspName("\u4fee\u6539\u6210\u529f");
        return retBo;
    }

    private Map<String, String> genKey() {
        Map<String, String> map = new HashMap();
        try {
            map = RsaEncodeUtil.generateRSAKeys();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f-\u751f\u6210\u79c1\u94a5\uff0c\u516c\u94a5\u548c\u7b7e\u540d\u4e32\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f-\u751f\u6210\u79c1\u94a5\uff0c\u516c\u94a5\u548c\u7b7e\u540d\u4e32\u5f02\u5e38");
        }
        map.put("signKey", RsaEncodeUtil.getRandomStringByLength((int)32));
        return map;
    }

    private String validateArgWithBusiInfo(UpdateBusiSystemInfoSimpleWebReqBo reqBo) {
        if (reqBo == null) {
            return "bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "BusiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiName())) {
            return "BusiName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getState())) {
            return "State\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String reqBoState = reqBo.getState().trim();
        if (!("1".equals(reqBoState) || "-1".equals(reqBoState) || "0".equals(reqBoState))) {
            return "State\u5fc5\u987b\u4e3a1\uff0c-1\u6216\u80050";
        }
        return null;
    }

    @PostMapping(value={"updateBusiSystemRelCashierTemplate"})
    public BaseRspInfoBO updateBusiSystemRelCashierTemplate(@RequestBody UpdateBusiSystemRelReqWayWebReqBo reqBo) {
        log.info(SERVICE_NAME + " -> " + SERVICE + " \uff1aupdateBusiSystemRelCashierTemplate [\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf\u3001reqWay\u3001cashierTemplate\u5173\u8054\u4fe1\u606f]");
        log.info(SERVICE + " -> updateBusiSystemRelCashierTemplate()\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        String validateArgStr = this.validateArgWithBusiRelReqWay(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRspCode("RSP_CODE_PARA_NOT_NULL");
            rspBo.setRspName("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        Long busiId = Long.valueOf(reqBo.getBusiId());
        BusiSystemInfoPO busiIsExit = this.busiSystemInfoAtomService.queryBusiSystemInfoById(busiId);
        if (busiIsExit == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u5b58\u5728");
            return rspBo;
        }
        QueryPCodeInfoReqBO qryReqWayBo = new QueryPCodeInfoReqBO();
        qryReqWayBo.setTypeCode("BUSI_SYSTEM_REQ_WAY");
        qryReqWayBo.setCodeValue(reqBo.getReqWay());
        QueryPCodeInfoRspBO qryReqWayRsp = this.queryPCodeInfoService.queryPCodeInfo(qryReqWayBo);
        if (qryReqWayRsp.getRespCode().equals("0000")) {
            if (StringUtils.isEmpty((Object)qryReqWayRsp.getCodeInfo())) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u8fd4\u56de\u63a5\u5165\u65b9\u5f0f\u76f8\u5173\u4fe1\u606f");
                log.info("\u8c03\u7528\u670d\u52a1 -> com.tydic.payment.pay.busi.api.QueryPCodeInfoService\u51fa\u9519");
                return rspBo;
            }
        } else {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u63a5\u5165\u65b9\u5f0f\u5728\u6570\u636e\u5b57\u5178\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u914d\u7f6e\u6570\u636e\u5b57\u5178");
            return rspBo;
        }
        RelBusiCashierPo qryRelBusiPo = new RelBusiCashierPo();
        qryRelBusiPo.setBusiId(busiId);
        qryRelBusiPo.setReqWay(reqBo.getReqWay());
        List<RelBusiCashierPo> qrRelBusiL = this.relBusiCashierAtomService.queryRelBusiCashier(qryRelBusiPo);
        for (RelBusiCashierPo ttPo : qrRelBusiL) {
            RelBusiCashierPo delPo = new RelBusiCashierPo();
            delPo.setId(ttPo.getId());
            this.relBusiCashierAtomService.deleteRelBusiCashier(delPo);
        }
        String cashierTemps = reqBo.getCashierTemplate();
        ArrayList<Long> cashierL = new ArrayList<Long>();
        if (!StringUtils.isEmpty((Object)cashierTemps)) {
            try {
                String[] cashierListStr = cashierTemps.split(",");
                if (cashierListStr.length == 0) {
                    rspBo.setRspName("\u4f20\u5165\u6536\u94f6\u53f0\u6a21\u677f\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
                    rspBo.setRspCode("8888");
                    return rspBo;
                }
                cashierL = new ArrayList(cashierListStr.length);
                for (String cashierId : cashierListStr) {
                    cashierL.add(Long.parseLong(cashierId));
                }
            }
            catch (NumberFormatException e) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u5b57\u6bb5\u3010attrIds\u3011\u683c\u5f0f\u9519\u8bef");
                return rspBo;
            }
        }
        for (Long tempCash : cashierL) {
            CashierTemplatePo queryCashierTemplateByCondition = this.cashierTemplateAtomService.queryCashierTemplateById(tempCash);
            if (queryCashierTemplateByCondition == null) {
                log.error("\u6a21\u677f" + reqBo.getCashierTemplate() + "\u4e0d\u5b58\u5728");
                continue;
            }
            RelBusiCashierPo qryRelBusiCashier = new RelBusiCashierPo();
            qryRelBusiCashier.setBusiId(busiId);
            qryRelBusiCashier.setReqWay(reqBo.getReqWay());
            qryRelBusiCashier.setCashierTemplate(tempCash);
            List<RelBusiCashierPo> qryRelList = this.relBusiCashierAtomService.queryRelBusiCashier(qryRelBusiCashier);
            if (!CollectionUtils.isEmpty(qryRelList)) continue;
            RelBusiCashierPo relBCPo = new RelBusiCashierPo();
            relBCPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
            relBCPo.setReqWay(reqBo.getReqWay());
            relBCPo.setCashierTemplate(tempCash);
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                relBCPo.setCreateOperId(reqBo.getOperId());
            }
            relBCPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            this.relBusiCashierAtomService.createRelBusiCashier(relBCPo);
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u751f\u6210\u4e1a\u52a1\u7cfb\u7edf\u63a5\u5165\u65b9\u5f0f\u6210\u529f\uff01");
        return rspBo;
    }

    private String validateArgWithBusiRelReqWay(UpdateBusiSystemRelReqWayWebReqBo reqBo) {
        if (reqBo == null) {
            return "bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "BusiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqWay())) {
            return "\u63a5\u5165\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCashierTemplate())) {
            return "\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

