/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.PayProCreateOrderPayTransBusiService;
import com.tydic.payment.pay.busi.PayProReceiveMsgForPublicBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProReceiveMsgForPublicBusiReqBO;
import com.tydic.payment.pay.busi.bo.PayProReceiveMsgForPublicBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayProReceiveMsgForPublicBusiServiceImpl
implements PayProReceiveMsgForPublicBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProReceiveMsgForPublicBusiServiceImpl.class);
    @Autowired
    private PayProCreateOrderPayTransBusiService payProCreateOrderPayTransBusiService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;

    public PayProReceiveMsgForPublicBusiRspBO dealMsg(PayProReceiveMsgForPublicBusiReqBO reqBO) {
        long dbFee;
        PayProReceiveMsgForPublicBusiRspBO retBo = new PayProReceiveMsgForPublicBusiRspBO();
        Long orderId = Long.parseLong(reqBO.getOrderId());
        PorderPo porderPo = this.payOrderAtomService.queryByOrderId(orderId);
        if (porderPo == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8be5orderId[" + orderId + "]\u4e0d\u5b58\u5728");
            return retBo;
        }
        long inputFee = Long.parseLong(reqBO.getTotalFee());
        if (inputFee != (dbFee = MoneyUtils.haoToFen((Long)porderPo.getTotalFee()).longValue())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8be5orderId[" + orderId + "]\u548c\u4e0b\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0b\u5355\u91d1\u989d(" + dbFee + ")");
            return retBo;
        }
        if ("A10".equals(porderPo.getOrderStatus())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8be5orderId[" + orderId + "]\u5df2\u7ecf\u66f4\u65b0\u8fc7\u4e86");
            return retBo;
        }
        porderPo.setOrderStatus("A10");
        porderPo.setPayNotifyCode("0");
        porderPo.setPayNotifyMsg("\u5bf9\u516c\u652f\u4ed8-\u56de\u8c03\u6210\u529f");
        porderPo.setTradeTime(reqBO.getTradeTime());
        porderPo.setRealFee(porderPo.getTotalFee());
        porderPo.setOnlineFee(porderPo.getTotalFee());
        this.payOrderAtomService.update(porderPo);
        PayProCreateOrderPayTransBusiReqBo createTransBo = new PayProCreateOrderPayTransBusiReqBo();
        BeanUtils.copyProperties((Object)porderPo, (Object)createTransBo);
        createTransBo.setPayMethod(Long.valueOf(Long.parseLong("130")));
        createTransBo.setPayFee(Long.valueOf(inputFee));
        createTransBo.setOrderStatus("A10");
        createTransBo.setTradeTime(reqBO.getTradeTime());
        createTransBo.setPayNotifyTransId(reqBO.getPayNotifyTransId());
        createTransBo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        createTransBo.setPayMsg("\u5bf9\u516c\u652f\u4ed8-\u56de\u8c03\u6210\u529f");
        createTransBo.setPayOrderId(reqBO.getPayOrderId());
        PayProCreateOrderPayTransBusiRspBo payTrans = this.payProCreateOrderPayTransBusiService.createPayTrans(createTransBo);
        if (!"0000".equals(payTrans.getRespCode())) {
            throw new BusinessException("216003", "\u5904\u7406\u5bf9\u516c\u901a\u77e5busi\u670d\u52a1\uff0c\u63d2\u5165orderTans\u6570\u636e\u5931\u8d25\uff1a" + payTrans.getRespDesc());
        }
        CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
        callBackNoticeReqBo.setOrderId(orderId);
        CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
        if ("0000".equals(callBackNoticeRspBo.getRspCode()) && LOG.isDebugEnabled()) {
            LOG.error(orderId + ":\u53d1\u9001\u56de\u8c03\u6d88\u606f\u961f\u5217\u6210\u529f");
        }
        retBo.setPayOrderId(payTrans.getPayOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u5904\u7406\u6210\u529f");
        return retBo;
    }
}

