/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import com.ohaotian.plugin.base.bo.TopologyBO;
import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.busi.BillPayBillDayCreateBusiService;
import com.tydic.payment.bill.busi.BillPayBillDayRemoveBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillPayBillDayCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPayBillDayRemoveBatchReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransByGroupNameReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundTransByGroupNameReqBO;
import com.tydic.payment.bill.comb.BillPayDayCombService;
import com.tydic.payment.bill.exception.BillSyncPayDayException;
import com.tydic.payment.bill.util.BillPropertiesVo;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.busi.BusiPaymentMerchantQueryBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantInfoBusiBO;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantQueryBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BillPayDayCombServiceImpl
implements BillPayDayCombService {
    @Autowired
    private BillPropertiesVo billPropertiesVo;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private QueryPayTransBusiService queryPayTransBusiService;
    private BillPayBillDayCreateBusiService billPayBillDayCreateBusiService;
    private BillPayBillDayRemoveBusiService billPayBillDayRemoveBusiService;
    private QueryRefundBusiService queryRefundBusiService;
    private PaymentInsIdBusiService paymentInsIdBusiService;
    private BusiPaymentMerchantQueryBusiService busiPaymentMerchantQueryBusiService;
    private QueryDBDateBusiService queryDBDateBusiService;

    @Autowired
    public BillPayDayCombServiceImpl(QueryPayTransBusiService queryPayTransBusiService, BillPayBillDayCreateBusiService billPayBillDayCreateBusiService, BillPayBillDayRemoveBusiService billPayBillDayRemoveBusiService, QueryRefundBusiService queryRefundBusiService, PaymentInsIdBusiService paymentInsIdBusiService, BusiPaymentMerchantQueryBusiService busiPaymentMerchantQueryBusiService, QueryDBDateBusiService queryDBDateBusiService) {
        this.queryPayTransBusiService = queryPayTransBusiService;
        this.billPayBillDayCreateBusiService = billPayBillDayCreateBusiService;
        this.billPayBillDayRemoveBusiService = billPayBillDayRemoveBusiService;
        this.queryRefundBusiService = queryRefundBusiService;
        this.paymentInsIdBusiService = paymentInsIdBusiService;
        this.busiPaymentMerchantQueryBusiService = busiPaymentMerchantQueryBusiService;
        this.queryDBDateBusiService = queryDBDateBusiService;
    }

    public void clean(BillExecuteRequest request) throws BillSyncPayDayException {
        BillPayBillDayRemoveBatchReqBO reqBO = new BillPayBillDayRemoveBatchReqBO();
        reqBO.setBillDate(request.getBillDate());
        reqBO.setPaymentInsId(request.getPaymentInsId());
        reqBO.setPaymentMchId(request.getPaymentMchId());
        this.billPayBillDayRemoveBusiService.removeBatch(reqBO);
    }

    public void payDay(BillExecuteRequest request) throws BillSyncPayDayException {
        BusiPaymentMerchantQueryBusiReqBO queryBusiReqBO = new BusiPaymentMerchantQueryBusiReqBO();
        queryBusiReqBO.setPaymentInsId(request.getPaymentInsId());
        queryBusiReqBO.setPaymentMchId(request.getPaymentMchId());
        BusiPaymentMerchantQueryBusiRspBO queryBusiRspBO = this.busiPaymentMerchantQueryBusiService.query(queryBusiReqBO);
        if (queryBusiRspBO == null) {
            throw new BillSyncPayDayException("\u67e5\u8be2\u4e1a\u52a1\u5546\u6237ID\u96c6\u5408\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)queryBusiRspBO.getMerchantInfoList())) {
            throw new BillSyncPayDayException("\u67e5\u8be2\u4e1a\u52a1\u5546\u6237ID\u96c6\u5408\u4e3a\u7a7a");
        }
        Collection merchantInfoList = queryBusiRspBO.getMerchantInfoList();
        ArrayList<Long> merchantIdList = new ArrayList<Long>(merchantInfoList.size());
        for (BusiPaymentMerchantInfoBusiBO tempBO : merchantInfoList) {
            merchantIdList.add(tempBO.getMerchantId());
        }
        List payMethods = this.paymentInsIdBusiService.listPayMethodByPaymentInsId(request.getPaymentInsId());
        this.transPay(request, payMethods, merchantIdList);
        this.transRefund(request, payMethods, merchantIdList);
    }

    private void transPay(BillExecuteRequest request, List<Long> payMethods, List<Long> merchantIdList) {
        String billDataBaseStrategy = this.billPropertiesVo.getBillDataBaseStrategy();
        QueryPayTransByGroupNameReqBO queryReqBO = new QueryPayTransByGroupNameReqBO();
        queryReqBO.setBillDate(request.getBillDate());
        queryReqBO.setPayMethods(payMethods);
        queryReqBO.setMerchantIds(merchantIdList);
        if ("1".equals(billDataBaseStrategy)) {
            LinkedList groupNames = this.queryPayTransBusiService.listDrdsGroupNames();
            for (TopologyBO topology : groupNames) {
                queryReqBO.setGroupName(topology.getGroupName());
                List transPayList = this.queryPayTransBusiService.listSuccessTransByGroupName(queryReqBO, null);
                if (CollectionUtils.isEmpty((Collection)transPayList)) {
                    LoggerProUtils.debug(this.logger, "\u540c\u6b65\u652f\u4ed8\u6570\u636e\u81f3\u4e34\u65f6\u5bf9\u8d26\u8868\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{" + queryReqBO.toString() + "}");
                    continue;
                }
                this.createDayByTransPay(transPayList, request);
            }
        } else {
            List transPayList = this.queryPayTransBusiService.listSuccessTransSingleDatabase(queryReqBO, null);
            if (CollectionUtils.isEmpty((Collection)transPayList)) {
                LoggerProUtils.debug(this.logger, "\u540c\u6b65\u652f\u4ed8\u6570\u636e\u81f3\u4e34\u65f6\u5bf9\u8d26\u8868\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{" + queryReqBO.toString() + "}");
                return;
            }
            this.createDayByTransPay(transPayList, request);
        }
    }

    private void createDayByTransPay(List<QueryPayTransRspBO> transPayList, BillExecuteRequest request) {
        for (QueryPayTransRspBO trans : transPayList) {
            BillPayBillDayCreateReqBO createReqBO = new BillPayBillDayCreateReqBO();
            createReqBO.setOrderId(trans.getOrderId());
            createReqBO.setPayOrderId(trans.getPayOrderId());
            createReqBO.setBillDate(request.getBillDate());
            createReqBO.setBillTransId(trans.getPayNotifyTransId());
            createReqBO.setPayMethod(trans.getPayMethod());
            createReqBO.setCreateTime(this.queryDBDateBusiService.getDBDate());
            createReqBO.setTradeTime(trans.getTradeTime());
            createReqBO.setPaymentInsId(request.getPaymentInsId());
            createReqBO.setPaymentMchId(request.getPaymentMchId());
            createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
            this.billPayBillDayCreateBusiService.createTrans(createReqBO);
        }
    }

    private void transRefund(BillExecuteRequest request, List<Long> payMethods, List<Long> merchantIdList) {
        String billDataBaseStrategy = this.billPropertiesVo.getBillDataBaseStrategy();
        QueryRefundTransByGroupNameReqBO queryReqBO = new QueryRefundTransByGroupNameReqBO();
        queryReqBO.setBillDate(request.getBillDate());
        queryReqBO.setPayMethods(payMethods);
        queryReqBO.setMerchantIds(merchantIdList);
        if ("1".equals(billDataBaseStrategy)) {
            LinkedList groupNames = this.queryRefundBusiService.listDrdsGroupNames();
            for (TopologyBO topology : groupNames) {
                queryReqBO.setGroupName(topology.getGroupName());
                List transRefundList = this.queryRefundBusiService.listSuccessTransByGroupName(queryReqBO, null);
                if (CollectionUtils.isEmpty((Collection)transRefundList)) {
                    LoggerProUtils.debug(this.logger, "\u540c\u6b65\u9000\u6b3e\u6570\u636e\u81f3\u4e34\u65f6\u5bf9\u8d26\u8868\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{" + queryReqBO.toString() + "}");
                    continue;
                }
                this.createDayByTransRefund(transRefundList, request);
            }
        } else {
            List transRefundList = this.queryRefundBusiService.listSuccessTransSingleDataBase(queryReqBO, null);
            if (CollectionUtils.isEmpty((Collection)transRefundList)) {
                LoggerProUtils.debug(this.logger, "\u540c\u6b65\u9000\u6b3e\u6570\u636e\u81f3\u4e34\u65f6\u5bf9\u8d26\u8868\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{" + queryReqBO.toString() + "}");
                return;
            }
            this.createDayByTransRefund(transRefundList, request);
        }
    }

    private void createDayByTransRefund(List<QueryRefundRspBO> transRefundList, BillExecuteRequest request) {
        BillPayBillDayCreateReqBO createReqBO = new BillPayBillDayCreateReqBO();
        for (QueryRefundRspBO trans : transRefundList) {
            createReqBO.setOrderId(trans.getOrderId());
            createReqBO.setPayOrderId(trans.getPayOrderId());
            createReqBO.setRefundOrderId(trans.getRefundOrderId());
            createReqBO.setBillDate(request.getBillDate());
            createReqBO.setBillTransId(trans.getPayNotifyTransId());
            createReqBO.setPayMethod(trans.getPayMethod());
            createReqBO.setCreateTime(this.queryDBDateBusiService.getDBDate());
            createReqBO.setTradeTime(trans.getTradeTime());
            createReqBO.setPaymentInsId(request.getPaymentInsId());
            createReqBO.setPaymentMchId(request.getPaymentMchId());
            createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
            this.billPayBillDayCreateBusiService.createTrans(createReqBO);
        }
    }
}

