/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.payment.bill.BillBusiExecuteRequest;
import com.tydic.payment.bill.busi.BillInfoBusiSystemQueryBusiService;
import com.tydic.payment.bill.busi.BillPaySettleBusiLogCreateBusiService;
import com.tydic.payment.bill.busi.bo.BillPaySettleBusiLogCreateBusiReqBO;
import com.tydic.payment.bill.busi.bo.InfoBusiSystemQueryRspBO;
import com.tydic.payment.bill.comb.BillBusiCheckCombService;
import com.tydic.payment.bill.comb.bo.BillBusiCheckCombReqBO;
import com.tydic.payment.bill.executor.busi.BillBusiExecutor;
import com.tydic.payment.pay.ability.impl.PayProBillExecutorAbilityServiceImpl;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billBusiCheckCombService")
public class BillBusiCheckCombServiceImpl
implements BillBusiCheckCombService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private BillPaySettleBusiLogCreateBusiService billPaySettleBusiLogCreateBusiService;
    private BillInfoBusiSystemQueryBusiService billInfoBusiSystemQueryBusiService;
    private BillBusiExecutor billBusiExecutor;
    @Autowired
    private CacheClient cacheClient;

    @Autowired
    public BillBusiCheckCombServiceImpl(BillPaySettleBusiLogCreateBusiService billPaySettleBusiLogCreateBusiService, BillInfoBusiSystemQueryBusiService billInfoBusiSystemQueryBusiService, BillBusiExecutor billBusiExecutor) {
        this.billPaySettleBusiLogCreateBusiService = billPaySettleBusiLogCreateBusiService;
        this.billInfoBusiSystemQueryBusiService = billInfoBusiSystemQueryBusiService;
        this.billBusiExecutor = billBusiExecutor;
    }

    public void execute(BillBusiCheckCombReqBO reqBO) {
        long beginTime = System.currentTimeMillis();
        this.logger.debug("\u3010\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8d26\u3011\u5f00\u59cb");
        this.logger.debug("\u5165\u53c2\uff1a{}", (Object)reqBO);
        List busiList = this.billInfoBusiSystemQueryBusiService.listStateEffective();
        for (InfoBusiSystemQueryRspBO busiSystem : busiList) {
            BillBusiExecuteRequest request = new BillBusiExecuteRequest();
            request.setBillDate(reqBO.getBillDate());
            request.setBusiId(busiSystem.getBusiId());
            request.setBusiCode(busiSystem.getBusiCode());
            this.doExecute(request);
        }
        this.logger.debug("\u3010\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8d26\u3011\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - beginTime));
        this.logger.debug("\u3010\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u8d26\u3011\u7ed3\u675f");
    }

    private void doExecute(BillBusiExecuteRequest request) {
        BillPaySettleBusiLogCreateBusiReqBO logReqBO = new BillPaySettleBusiLogCreateBusiReqBO();
        logReqBO.setBillDate(request.getBillDate());
        logReqBO.setBusiId(request.getBusiId());
        logReqBO.setCreateTime(new Date());
        try {
            this.billBusiExecutor.invoke(request);
        }
        catch (Exception ex) {
            this.logger.warn("\u4e1a\u52a1\u7cfb\u7edf\u3010{}\u3011\u5bf9\u8d26\u5f02\u5e38\uff1a{}", (Object)request.getBusiId(), (Object)ex);
            logReqBO.setResultCode("8888");
            logReqBO.setResultDesc(PayProBillExecutorAbilityServiceImpl.cutException(ex));
            this.billPaySettleBusiLogCreateBusiService.create(logReqBO);
            return;
        }
        String fileNamess = (String)this.cacheClient.get("BILL_BUSI_FILENAMES");
        this.cacheClient.delete("BILL_BUSI_FILENAMES");
        logReqBO.setResultCode("0000");
        logReqBO.setResultDesc("\u6210\u529f");
        logReqBO.setFileNames(fileNamess);
        this.billPaySettleBusiLogCreateBusiService.create(logReqBO);
    }
}

