/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.tydic.payment.pay.atom.PayParaRuleAtomService;
import com.tydic.payment.pay.dao.PayParaRuleMapper;
import com.tydic.payment.pay.dao.po.PayParaRulePo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payParaRuleAtomService")
public class PayParaRuleAtomServiceImpl
implements PayParaRuleAtomService {
    @Autowired
    private PayParaRuleMapper payParaRuleMapper;

    @Override
    public Long createPayParaRule(PayParaRulePo po) {
        this.validateArg(po);
        int createPayParaRule = this.payParaRuleMapper.createPayParaRule(po);
        if (createPayParaRule < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_RULE_PAY_PARA\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getId() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_RULE_PAY_PARA\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getId();
    }

    @Override
    public List<PayParaRulePo> queryPayParaRuleByCondition(PayParaRulePo po) {
        List<PayParaRulePo> queryPayParaRuleByCondition;
        if (po == null) {
            po = new PayParaRulePo();
        }
        if ((queryPayParaRuleByCondition = this.payParaRuleMapper.queryPayParaRuleByCondition(po)) == null || queryPayParaRuleByCondition.isEmpty()) {
            return new ArrayList<PayParaRulePo>();
        }
        return queryPayParaRuleByCondition;
    }

    @Override
    public int updatePayParaRule(PayParaRulePo po) {
        this.validateArgUpdate(po);
        int updatePayParaRule = this.payParaRuleMapper.updatePayParaRule(po);
        return updatePayParaRule;
    }

    @Override
    public int deletePayParaRule(PayParaRulePo po) {
        this.validateArgDel(po);
        int deletePayParaRule = this.payParaRuleMapper.deletePayParaRule(po);
        return deletePayParaRule;
    }

    private void validateArgDel(PayParaRulePo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_RULE_PAY_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null && po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgUpdate(PayParaRulePo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_RULE_PAY_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArg(PayParaRulePo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() != null) {
            po.setId(null);
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getParameterCode() == null || po.getParameterCode().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027ParameterCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getParameterName() == null || po.getParameterName().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027ParameterName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

