/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.WXQrCodePayBusiService;
import com.tydic.payment.pay.busi.WXUnifiedOrderService;
import com.tydic.payment.pay.busi.bo.WXQrCodePayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXQrCodePayBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXUnifiedOrderReqBO;
import com.tydic.payment.pay.busi.bo.WXUnifiedOrderRspBO;
import com.tydic.payment.pay.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXQrCodePayBusiService")
public class WXQrCodePayBusiServiceImpl
implements WXQrCodePayBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXQrCodePayBusiServiceImpl.class);
    @Autowired
    private WXUnifiedOrderService wXUnifiedOrderService;

    public WXQrCodePayBusiRspBO dealWxQrCodePay(WXQrCodePayBusiReqBO req) throws Exception {
        log.info("\u8fdb\u5165\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u670d\u52a1\uff1a" + req);
        WXQrCodePayBusiRspBO rsp = new WXQrCodePayBusiRspBO();
        try {
            this.checkInputParas(req);
            String appid = (String)req.getParamMap().get("appid");
            String mchid = (String)req.getParamMap().get("mchid");
            String key = (String)req.getParamMap().get("signkey");
            String sub_mch_id = (String)req.getParamMap().get("subMchId");
            String trade_type = "NATIVE";
            WXUnifiedOrderReqBO unifiedOrderReq = new WXUnifiedOrderReqBO();
            unifiedOrderReq.setAppId(appid);
            unifiedOrderReq.setMchId(mchid);
            unifiedOrderReq.setSubMchId(sub_mch_id);
            unifiedOrderReq.setKey(key);
            unifiedOrderReq.setTradeType(trade_type);
            unifiedOrderReq.setTotalFee(req.getTotalFee());
            unifiedOrderReq.setOrderId(req.getOrderId());
            unifiedOrderReq.setMerchantId(req.getMerchantId());
            unifiedOrderReq.setPayMethod("11");
            WXUnifiedOrderRspBO unifiedOrderRsp = this.wXUnifiedOrderService.dealUnifiedOrder(unifiedOrderReq);
            if (!"0000".equals(unifiedOrderRsp.getRspCode())) {
                rsp.setRspCode(unifiedOrderRsp.getRspCode());
                rsp.setRspName(unifiedOrderRsp.getRspName());
                return rsp;
            }
            String code_url = unifiedOrderRsp.getCodeUrl();
            if (StringUtils.isEmpty((Object)code_url)) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u670d\u52a1\u6ca1\u6709\u53d6\u5230\u5fae\u4fe1\u8fd4\u56de\u7684code_url\u503c");
                return rsp;
            }
            rsp.setQrCode(code_url);
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
            rsp.setPayOrderId(unifiedOrderRsp.getPayOrderId());
            rsp.setEffectiveSeconds(unifiedOrderRsp.getEffectiveSeconds());
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u7edf\u4e00\u652f\u4ed8\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void checkInputParas(WXQrCodePayBusiReqBO req) {
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTotalFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getParamMap())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("appid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u5e94\u7528id\u3010appid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("mchid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u6ca1\u6709\u5546\u6237\u53f7\u3010mchid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("signkey"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u7b7e\u540d\u5bc6\u94a5\u3010sign_key\u3011\uff01");
        }
    }
}

