/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.busi.WXCloseOrderBusiService;
import com.tydic.payment.pay.busi.WXPayApiBusiService;
import com.tydic.payment.pay.busi.bo.WXCloseOrderBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXCloseOrderBusiRspBO;
import com.tydic.payment.pay.common.util.ParseAbilityResponse;
import com.tydic.payment.pay.common.util.ParseInfo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.req.bo.WXApiCloseOrderReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiCloseOrderRspBO;
import com.tydic.payment.pay.wx.util.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXCloseOrderBusiService")
public class WXCloseOrderBusiServiceImpl
implements WXCloseOrderBusiService {
    private static final Logger logger = LoggerFactory.getLogger(WXCloseOrderBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private WXPayApiBusiService wXPayApiBusiService;

    public WXCloseOrderBusiRspBO dealWXCloseOrder(WXCloseOrderBusiReqBO req) throws Exception {
        logger.info("\u8fdb\u5165\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1" + req);
        WXCloseOrderBusiRspBO rsp = new WXCloseOrderBusiRspBO();
        try {
            this.checkInputParas(req);
            String appid = (String)req.getParamMap().get("appid");
            String mchid = (String)req.getParamMap().get("mchid");
            String key = (String)req.getParamMap().get("signkey");
            String sub_mch_id = (String)req.getParamMap().get("subMchId");
            WXApiCloseOrderReqBO closeOrderReqData = new WXApiCloseOrderReqBO().setAppid(appid).setMch_id(mchid).setSub_mch_id(sub_mch_id).setOut_trade_no(req.getPayOrderId()).setNonce_str("").setKey(key);
            if ("1".equals(this.payPropertiesVo.getAbilitySwitch())) {
                rsp = this.closeWxOrderByAbility(closeOrderReqData);
            } else if ("0".equals(this.payPropertiesVo.getAbilitySwitch())) {
                rsp = this.closeWxOrderByWxApi(closeOrderReqData);
            }
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e);
        }
        return rsp;
    }

    private WXCloseOrderBusiRspBO closeWxOrderByAbility(WXApiCloseOrderReqBO closeOrderReqData) throws Exception {
        WXCloseOrderBusiRspBO rsp = new WXCloseOrderBusiRspBO();
        JSONObject body = new JSONObject();
        JSONObject bodyInfo = new JSONObject();
        bodyInfo.put("APP_ID", (Object)closeOrderReqData.getAppid());
        bodyInfo.put("MCH_ID", (Object)closeOrderReqData.getMch_id());
        bodyInfo.put("SUB_MCH_ID", (Object)closeOrderReqData.getSub_mch_id());
        bodyInfo.put("OUT_TRADE_NO", (Object)closeOrderReqData.getOut_trade_no());
        bodyInfo.put("NONCE_STR", (Object)closeOrderReqData.getNonce_str());
        bodyInfo.put("SIGN", (Object)closeOrderReqData.getSign());
        body.put("CLOSE_ORDER_REQ", (Object)bodyInfo);
        String resultStr = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityWxCloseOrderUrl(), body);
        ParseInfo parseInfo = ParseAbilityResponse.getRspBodyInfo((String)resultStr, (String)"CLOSE_ORDER_RSP");
        JSONObject bodyJosonInfo = parseInfo.getJsonInfo();
        if (bodyJosonInfo == null) {
            rsp.setRspCode(parseInfo.getRsp_code());
            rsp.setRspName(parseInfo.getRsp_msg());
            return rsp;
        }
        String err_code = bodyJosonInfo.getString("ERR_CODE");
        if ("0000".equals(parseInfo.getRsp_code()) && StringUtils.isEmpty((Object)err_code)) {
            if (!Signature.checkIsSignValidFromAbilityResponse((JSONObject)parseInfo.getJsonInfo(), (String)closeOrderReqData.getKey())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u6821\u9a8c\u67e5\u8be2\u8ba2\u5355api\u8fd4\u56de\u7b7e\u540d\u5931\u8d25");
                return rsp;
            }
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
            return rsp;
        }
        if ("8888".equals(parseInfo.getRsp_code()) && StringUtils.isEmpty((Object)err_code)) {
            rsp.setRspCode(parseInfo.getRsp_code());
            rsp.setRspName(parseInfo.getRsp_msg());
            return rsp;
        }
        if ("ORDERPAID".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u5173\u5355");
        } else if ("SYSTEMERROR".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5173\u95ed\u8ba2\u5355\uff0c\u5fae\u4fe1\u8fd4\u56de\u7cfb\u7edf\u9519\u8bef");
        } else if ("ORDERCLOSED".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8ba2\u5355\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u91cd\u590d\u5173\u95ed");
        } else if ("SIGNERROR".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8bf7\u68c0\u67e5\u7b7e\u540d\u53c2\u6570\u548c\u65b9\u6cd5\u662f\u5426\u90fd\u7b26\u5408\u7b7e\u540d\u7b97\u6cd5\u8981\u6c42");
        } else if ("REQUIRE_POST_METHOD".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u901a\u8fc7post\u65b9\u6cd5\u63d0\u4ea4");
        } else if ("XML_FORMAT_ERROR".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8bf7\u68c0\u67e5XML\u53c2\u6570\u683c\u5f0f\u662f\u5426\u6b63\u786e");
        } else {
            rsp.setRspCode(parseInfo.getRsp_code());
            rsp.setRspName(parseInfo.getRsp_msg());
        }
        return rsp;
    }

    private WXCloseOrderBusiRspBO closeWxOrderByWxApi(WXApiCloseOrderReqBO closeOrderReqData) throws Exception {
        WXCloseOrderBusiRspBO rsp = new WXCloseOrderBusiRspBO();
        WXApiCloseOrderRspBO closeOrderRspData = this.wXPayApiBusiService.closeOrder(closeOrderReqData);
        logger.info("\u5173\u95ed\u8ba2\u5355\u5fae\u4fe1\u8fd4\u56de\uff1a" + closeOrderRspData.toString());
        if (!"SUCCESS".equals(closeOrderRspData.getReturn_code())) {
            rsp.setRspCode("8888");
            rsp.setRspName(closeOrderRspData.getReturn_msg());
            return rsp;
        }
        if ("SUCCESS".equals(closeOrderRspData.getResult_code())) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
            return rsp;
        }
        String err_code = closeOrderRspData.getErr_code();
        if ("ORDERPAID".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u5173\u5355");
        } else if ("SYSTEMERROR".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5173\u95ed\u8ba2\u5355\uff0c\u5fae\u4fe1\u8fd4\u56de\u7cfb\u7edf\u9519\u8bef");
        } else if ("ORDERCLOSED".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8ba2\u5355\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u91cd\u590d\u5173\u95ed");
        } else if ("SIGNERROR".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8bf7\u68c0\u67e5\u7b7e\u540d\u53c2\u6570\u548c\u65b9\u6cd5\u662f\u5426\u90fd\u7b26\u5408\u7b7e\u540d\u7b97\u6cd5\u8981\u6c42");
        } else if ("REQUIRE_POST_METHOD".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u901a\u8fc7post\u65b9\u6cd5\u63d0\u4ea4");
        } else if ("XML_FORMAT_ERROR".equals(err_code)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8bf7\u68c0\u67e5XML\u53c2\u6570\u683c\u5f0f\u662f\u5426\u6b63\u786e");
        } else {
            rsp.setRspCode("8888");
            rsp.setRspName(closeOrderRspData.getErr_code_des());
        }
        return rsp;
    }

    private void checkInputParas(WXCloseOrderBusiReqBO req) {
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getParamMap())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("appid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u5e94\u7528id\u3010appid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("mchid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u6ca1\u6709\u5546\u6237\u53f7\u3010mchid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("signkey"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u7b7e\u540d\u5bc6\u94a5\u3010signkey\u3011\uff01");
        }
    }
}

