/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.bill.busi.bo.BillWxPayTransCreateReqBO;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.util.DownloadBillReqData;
import com.tydic.payment.bill.util.WXPayUtil;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayBillAbleWxImpl
implements PayBillAble {
    private static final Logger log = LoggerFactory.getLogger(PayBillAbleWxImpl.class);
    private static final String WX_DEFAULT_DOWNLOAD_BILL_URL = "https://api.mch.weixin.qq.com/pay/downloadbill";
    private static final String REFUND_FLAG = "0";
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long paymentIns() {
        return BillConstant.PaymentIns.WX_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        PayBillAbleDownloadRspBo retBo = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        Map paramMap = reqBo.getParaMap();
        String appid = (String)paramMap.get("appid");
        String mchid = (String)paramMap.get("mchid");
        String sign = (String)paramMap.get("signkey");
        String bill_date = reqBo.getBillDate().toString();
        String bill_type = "ALL";
        String billUrl = this.payPropertiesVo.getWXDownloadBill();
        billUrl = StringUtils.isEmpty((String)billUrl) ? WX_DEFAULT_DOWNLOAD_BILL_URL : billUrl;
        log.info("\u672c\u6b21\u8d26\u5355\u4e0b\u8f7d\u5730\u5740\u4e3a\uff1a", (Object)billUrl);
        DownloadBillReqData downloadReqBo = new DownloadBillReqData(appid, mchid, sign, "", bill_date, bill_type, "");
        String billStr = null;
        try {
            billStr = WXPayUtil.doDownloadBillBusiness(downloadReqBo, billUrl);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u5fae\u4fe1\u8d26\u5355\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)paramMap));
            }
            throw new BusinessException("218009", e.getMessage());
        }
        this.parseAndAssignRspBos(billStr, retBo);
        return retBo;
    }

    private void parseAndAssignRspBos(String billStr, PayBillAbleDownloadRspBo retBo) {
        ByteArrayInputStream billStream = new ByteArrayInputStream(billStr.getBytes());
        InputStreamReader reader = new InputStreamReader(billStream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String content;
            bufferedReader.readLine();
            while ((content = bufferedReader.readLine()) != null && content.contains("`")) {
                BillWxPayTransCreateReqBO wxPayTrans = this.buildWxPayTrans(content);
                this.assignToRetBo(wxPayTrans, retBo);
            }
        }
        catch (Exception ex) {
            throw new BillDownAndTransException("\u5fae\u4fe1\u652f\u4ed8\u8d26\u5355\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
        try {
            bufferedReader.close();
            ((Reader)reader).close();
            ((InputStream)billStream).close();
        }
        catch (IOException ex) {
            log.warn("\u5173\u95ed\u5fae\u4fe1\u652f\u4ed8\u8d26\u5355\u6570\u636e\u8bfb\u53d6\u6d41\u5f02\u5e38\uff1a" + ex.getMessage());
        }
    }

    public void assignToRetBo(BillWxPayTransCreateReqBO wxPayTrans, PayBillAbleDownloadRspBo retBo) {
        PayBillAbleDownloadRspDataBo trans = new PayBillAbleDownloadRspDataBo();
        if (StringUtils.isEmpty((String)wxPayTrans.getRefundId()) || REFUND_FLAG.equals(wxPayTrans.getRefundId())) {
            trans.setTypeOrderId(wxPayTrans.getOutTradeNo());
            trans.setOrderType("01");
            trans.setTypeTransId(wxPayTrans.getTransactionId());
            trans.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((BigDecimal)wxPayTrans.getTotalFee().abs()).longValue()));
        } else {
            trans.setTypeOrderId(wxPayTrans.getOutRefundNo());
            trans.setOrderType("02");
            trans.setTypeTransId(wxPayTrans.getRefundId());
            trans.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((BigDecimal)wxPayTrans.getSettlementRefundFee().abs()).longValue()));
        }
        trans.setBillDate(wxPayTrans.getBillDate());
        trans.setPaymentInsId(BillConstant.PaymentIns.WX_PAY.getPaymentInsId());
        trans.setBillFlag(REFUND_FLAG);
        trans.setPaymentMchId(wxPayTrans.getMchId());
        trans.setPaymentInsId(BillConstant.PaymentIns.WX_PAY.getPaymentInsId());
        DateTime transTime = DateTime.parse((String)wxPayTrans.getTransTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
        trans.setTradeTime(transTime.toString("yyyyMMddHHmmss"));
        trans.setPaymentInsObj((Object)wxPayTrans);
        retBo.getRspDataBos().add(trans);
    }

    private BillWxPayTransCreateReqBO buildWxPayTrans(String row) {
        BillWxPayTransCreateReqBO reqBO = new BillWxPayTransCreateReqBO();
        int index = 0;
        String[] columns = row.replace("`", "").split(",");
        reqBO.setTransTime(columns[index++]);
        reqBO.setAppId(columns[index++]);
        reqBO.setMchId(columns[index++]);
        reqBO.setSubMchId(columns[index++]);
        reqBO.setDeviceInfo(columns[index++]);
        reqBO.setTransactionId(columns[index++]);
        reqBO.setOutTradeNo(columns[index++]);
        reqBO.setOpenId(columns[index++]);
        reqBO.setTradeType(columns[index++]);
        reqBO.setResultCode(columns[index++]);
        reqBO.setBank(columns[index++]);
        reqBO.setFeeType(columns[index++]);
        reqBO.setTotalFee(new BigDecimal(columns[index++]));
        reqBO.setRedFee(new BigDecimal(columns[index++]));
        reqBO.setRefundId(columns[index++]);
        reqBO.setOutRefundNo(columns[index++]);
        reqBO.setSettlementRefundFee(new BigDecimal(columns[index++]));
        reqBO.setRedRefundFee(new BigDecimal(columns[index++]));
        reqBO.setRefundType(columns[index++]);
        reqBO.setRefundCode(columns[index++]);
        reqBO.setBody(columns[index++]);
        reqBO.setDetail(columns[index++]);
        reqBO.setMerFee(new BigDecimal(columns[index++]));
        reqBO.setRateFee(columns[index]);
        String billDate = reqBO.getTransTime();
        billDate = billDate.replaceAll("-", "");
        billDate = billDate.substring(0, 8);
        reqBO.setBillDate(Long.valueOf(billDate));
        reqBO.setBillCheckFlag(REFUND_FLAG);
        return reqBO;
    }

    public static void main(String[] args) throws IOException {
        String appid = "wx1a61246a77d08c7c";
        String mchid = "1516396021";
        String sign = "Ao1VLmIkqUf89zBPpfbsFn3gB0X6GHbS";
        String bill_date = "20201014";
        String bill_type = "ALL";
        DownloadBillReqData downloadReqBo = new DownloadBillReqData(appid, mchid, sign, "", bill_date, bill_type, "");
        String billStr = null;
        try {
            billStr = WXPayUtil.doDownloadBillBusiness(downloadReqBo, WX_DEFAULT_DOWNLOAD_BILL_URL);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u8d26\u5355\u5931\u8d25");
        }
        System.out.println("billStr:" + billStr);
    }
}

