/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import cn.hutool.core.collection.CollUtil;
import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.busi.BillCompareDiffCreateBusiService;
import com.tydic.payment.bill.busi.BillPayBillDayCreateBusiService;
import com.tydic.payment.bill.busi.BillPayBillDayRemoveBusiService;
import com.tydic.payment.bill.busi.BillSettleTransCreateBusiService;
import com.tydic.payment.bill.busi.BillSettleTransRemoveBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillCompareDiffCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPayBillDayCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPayBillDayRemoveBatchReqBO;
import com.tydic.payment.bill.busi.bo.BillSettleTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillSettleTransRemoveBusiReqBO;
import com.tydic.payment.bill.busi.bo.PayBillDayBO;
import com.tydic.payment.bill.busi.bo.QueryPayDayReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.comb.BillPaySettleTransCombService;
import com.tydic.payment.bill.exception.BillSyncSettleTransException;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.constant.OrderConstant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billPaySettleTransCombService")
public class BillPaySettleTransCombServiceImpl
implements BillPaySettleTransCombService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BillSettleTransCreateBusiService billSettleTransCreateBusiService;
    @Autowired
    private BillSettleTransRemoveBusiService billSettleTransRemoveBusiService;
    @Autowired
    private BillPayBillDayRemoveBusiService billPayBillDayRemoveBusiService;
    @Autowired
    private QueryPayTransBusiService queryPayTransBusiService;
    @Autowired
    private QueryRefundBusiService queryRefundBusiService;
    @Autowired
    private BillCompareDiffCreateBusiService billCompareDiffCreateBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private BillPayBillDayCreateBusiService billPayBillDayCreateBusiService;

    public void doSyncSettleTransClean(BillExecuteRequest request) throws BillSyncSettleTransException {
        BillSettleTransRemoveBusiReqBO reqBO = new BillSettleTransRemoveBusiReqBO();
        reqBO.setBillDate(request.getBillDate());
        reqBO.setPaymentInsId(request.getPaymentInsId());
        reqBO.setPaymentMchId(request.getPaymentMchId());
        this.billSettleTransRemoveBusiService.removeBatch(reqBO);
    }

    public void doSyncSettleTransDay(BillExecuteRequest request) throws BillSyncSettleTransException {
        int totalItem = 10;
        for (int current = 0; current < totalItem; ++current) {
            QueryPayDayReqBO queryPayDayReqBO = new QueryPayDayReqBO();
            queryPayDayReqBO.setBillDate(request.getBillDate());
            queryPayDayReqBO.setPaymentInsId(request.getPaymentInsId());
            queryPayDayReqBO.setPaymentMchId(request.getPaymentMchId());
            queryPayDayReqBO.setTotalItem(Long.valueOf(Integer.valueOf(totalItem).longValue()));
            queryPayDayReqBO.setCurrentItem(Long.valueOf(Integer.valueOf(current).longValue()));
            List bos = this.billSettleTransCreateBusiService.query(queryPayDayReqBO);
            if (bos == null || bos.size() < 1) {
                LoggerProUtils.debug(this.logger, "\u67e5\u8be2\u4e34\u65f6\u5bf9\u8d26\u8868\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a" + queryPayDayReqBO.toString());
                continue;
            }
            this.createSettleTrans(bos);
        }
    }

    private void removeBillDay(BillExecuteRequest request) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Long removeDate = Long.valueOf(LocalDate.parse(request.getBillDate().toString(), formatter).minusDays(1L).format(formatter));
        BillPayBillDayRemoveBatchReqBO reqBO = new BillPayBillDayRemoveBatchReqBO();
        reqBO.setBillDate(removeDate);
        reqBO.setPaymentInsId(request.getPaymentInsId());
        reqBO.setPaymentMchId(request.getPaymentMchId());
        this.billPayBillDayRemoveBusiService.removeBatch(reqBO);
    }

    private void createSettleTrans(List<PayBillDayBO> bos) {
        for (PayBillDayBO bo : bos) {
            List refundTrans;
            List payTrans;
            if (OrderConstant.isOrderTypeRequest((String)bo.getOrderType()) && !CollUtil.isEmpty((Collection)(payTrans = this.queryPayTransBusiService.listByOrderId(bo.getOrderId())))) {
                this.createSettleTransAndRemoceBillDayTransByOrderTransCount(bo, payTrans, ((QueryPayTransRspBO)payTrans.get(0)).getCreateTime());
            }
            if (!OrderConstant.isOrderTypeRefund((String)bo.getOrderType()) || CollUtil.isEmpty((Collection)(refundTrans = this.queryRefundBusiService.listByOrderId(bo.getOrderId())))) continue;
            this.createSettleTransAndRemoceBillDayTransByOrderTransCount(bo, refundTrans, ((QueryRefundRspBO)refundTrans.get(0)).getCreateTime());
        }
    }

    private void createSettleTransAndRemoceBillDayTransByOrderTransCount(PayBillDayBO reqBO, List<?> orderTrans, Date createTime) {
        if (orderTrans == null || orderTrans.size() < 1) {
            return;
        }
        List dayTrans = this.billSettleTransCreateBusiService.listByOrderId(reqBO.getOrderId());
        if (dayTrans == null || dayTrans.size() < 1) {
            return;
        }
        reqBO.setCreateTime(createTime);
        if (orderTrans.size() == 1 && dayTrans.size() == 1) {
            this.createSettleTransByPayBillDay(reqBO);
            return;
        }
        boolean result = this.billSettleTransCreateBusiService.hasOrderId(reqBO.getOrderId());
        if (result) {
            return;
        }
        if (orderTrans.size() == dayTrans.size()) {
            this.createSettleTransByPayBillDay(reqBO);
        }
    }

    private void createSettleTransByPayBillDay(PayBillDayBO billDayBO) {
        BillSettleTransCreateReqBO reqBO = new BillSettleTransCreateReqBO();
        BeanUtils.copyProperties((Object)billDayBO, (Object)reqBO);
        this.billSettleTransCreateBusiService.create(reqBO);
    }

    private void createDiff(PayBillDayBO pmcPayPO) {
        BillCompareDiffCreateReqBO diff = new BillCompareDiffCreateReqBO();
        diff.setPaymentInsId(pmcPayPO.getPaymentInsId());
        diff.setBillDate(pmcPayPO.getBillDate());
        diff.setDiffType(Integer.valueOf(-2));
        diff.setCreateDate(this.queryDBDateBusiService.getDBDate());
        diff.setBusiId(pmcPayPO.getBusiId());
        diff.setOrderType(pmcPayPO.getOrderType());
        diff.setOutOrderId(pmcPayPO.getOutOrderId());
        diff.setOrderId(pmcPayPO.getOrderId());
        diff.setPayOrderId(pmcPayPO.getPayOrderId());
        diff.setRefundOrderId(pmcPayPO.getRefundOrderId());
        diff.setBillTransId(pmcPayPO.getBillTransId());
        diff.setOrderDate(pmcPayPO.getCreateTime());
        diff.setTotalFee(pmcPayPO.getRealFee());
        this.billCompareDiffCreateBusiService.create(diff);
    }

    private void updatePayBillDayFlag(PayBillDayBO billDayBO) {
        BillPayBillDayCreateReqBO reqBO = new BillPayBillDayCreateReqBO();
        reqBO.setOrderId(billDayBO.getOrderId());
        reqBO.setPayOrderId(billDayBO.getPayOrderId());
        reqBO.setRefundOrderId(billDayBO.getRefundOrderId());
        reqBO.setFlag("-2");
        this.billPayBillDayCreateBusiService.updateFlag(reqBO);
    }
}

