/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.WXJsapiPayBusiService;
import com.tydic.payment.pay.busi.WXUnifiedOrderService;
import com.tydic.payment.pay.busi.bo.WXJsapiPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXJsapiPayBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXUnifiedOrderReqBO;
import com.tydic.payment.pay.busi.bo.WXUnifiedOrderRspBO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.util.RandomStringGenerator;
import com.tydic.payment.pay.wx.util.Signature;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXJsapiPayBusiService")
public class WXJsapiPayBusiServiceImpl
implements WXJsapiPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXJsapiPayBusiServiceImpl.class);
    @Autowired
    private WXUnifiedOrderService wXUnifiedOrderService;

    public WXJsapiPayBusiRspBO dealWxJsapiPay(WXJsapiPayBusiReqBO req) throws Exception {
        log.info("\u8fdb\u5165\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u670d\u52a1\uff1a" + req);
        WXJsapiPayBusiRspBO rsp = new WXJsapiPayBusiRspBO();
        this.checkInputParas(req);
        String payMethod = StringUtils.isEmpty((Object)req.getPayMethod()) ? "14" : req.getPayMethod();
        String appid = "";
        appid = "14".equals(payMethod) ? (String)req.getParamMap().get("appid") : (String)req.getParamMap().get("applets_appid");
        String mchid = (String)req.getParamMap().get("mchid");
        String key = (String)req.getParamMap().get("signkey");
        String subMchId = (String)req.getParamMap().get("subMchId");
        String trade_type = "JSAPI";
        WXUnifiedOrderReqBO unifiedOrderReq = new WXUnifiedOrderReqBO();
        unifiedOrderReq.setAppId(appid);
        unifiedOrderReq.setMchId(mchid);
        unifiedOrderReq.setSubMchId(subMchId);
        unifiedOrderReq.setKey(key);
        unifiedOrderReq.setTradeType(trade_type);
        unifiedOrderReq.setOpenId(req.getOpenid());
        unifiedOrderReq.setTotalFee(req.getTotalFee());
        unifiedOrderReq.setOrderId(req.getOrderId());
        unifiedOrderReq.setMerchantId(req.getMerchantId());
        unifiedOrderReq.setPayMethod(payMethod);
        WXUnifiedOrderRspBO unifiedOrderRsp = this.wXUnifiedOrderService.dealUnifiedOrder(unifiedOrderReq);
        if (!"0000".equals(unifiedOrderRsp.getRspCode())) {
            rsp.setRspCode(unifiedOrderRsp.getRspCode());
            rsp.setRspName(unifiedOrderRsp.getRspName());
            return rsp;
        }
        String prepay_id = unifiedOrderRsp.getPrepayId();
        if (StringUtils.isEmpty((Object)prepay_id)) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u670d\u52a1\u6ca1\u6709\u53d6\u5230\u5fae\u4fe1\u8fd4\u56de\u7684prepay_id\u503c");
            return rsp;
        }
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String package_ = new StringBuffer("prepay_id=").append(prepay_id).toString();
        String nonceStr = RandomStringGenerator.getRandomStringByLength((int)32);
        HashMap<String, String> signMsg = new HashMap<String, String>();
        signMsg.put("appId", appid);
        signMsg.put("timeStamp", timeStamp);
        signMsg.put("nonceStr", nonceStr);
        signMsg.put("package", package_);
        signMsg.put("signType", "MD5");
        String sign = Signature.getSign(signMsg, (String)key);
        log.info("\u516c\u4f17\u53f7\u652f\u4ed8\u7b7e\u540d\u7684key=" + key);
        log.info("\u516c\u4f17\u53f7\u652f\u4ed8\u7b7e\u540d\u8fd4\u56de\u7ed9\u524d\u53f0=" + sign);
        rsp.setAppId(appid);
        rsp.setTimeStamp(timeStamp);
        rsp.setNonceStr(nonceStr);
        rsp.setPackage_(package_);
        rsp.setSignType("MD5");
        rsp.setPaySign(sign);
        rsp.setPayOrderId(unifiedOrderRsp.getPayOrderId());
        rsp.setRspCode("0000");
        rsp.setRspName("\u6210\u529f");
        return rsp;
    }

    private void checkInputParas(WXJsapiPayBusiReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTotalFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOpenid())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u3010openid\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getParamMap())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("appid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u5e94\u7528id\u3010appid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("mchid"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u6ca1\u6709\u5546\u6237\u53f7\u3010mchid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("signkey"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u7b7e\u540d\u5bc6\u94a5\u3010sign_key\u3011\uff01");
        }
    }
}

