/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.UnionPayFileTransferBusiService;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.UnionPayFileTransferBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionPayFileTransferBusiRspBO;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.FileUtil;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.busi.UnionPayFileTransferBusiService"})
public class UnionPayFileTransferBusiServiceImpl
implements UnionPayFileTransferBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionPayFileTransferBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Resource
    FileClient fileClient;

    @PostMapping(value={"dealUnionPayFileTransfer"})
    public UnionPayFileTransferBusiRspBO dealUnionPayFileTransfer(@RequestBody UnionPayFileTransferBusiReqBO req) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u94f6\u8054\u652f\u4ed8\u83b7\u53d6\u5bf9\u8d26\u6587\u4ef6\u4ea4\u6613\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        }
        Map<String, String> payParaMap = this.loadProperties(req);
        Map<String, String> reqContent = this.createReqContent(req, payParaMap.get("merId"));
        Map reqData = AcpService.sign(reqContent, (String)"UTF-8");
        String url = SdkConfig.getConfig().getFileTransUrl();
        Map rspData = AcpService.post((Map)reqData, (String)url, (String)"UTF-8");
        UnionPayFileTransferBusiRspBO rsp = new UnionPayFileTransferBusiRspBO();
        if (rspData.isEmpty()) {
            rsp.setRspCode("212000");
            rsp.setRspName("\u94f6\u8054\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (!AcpService.validate((Map)rspData, (String)"UTF-8")) {
            rsp.setRspCode("212001");
            rsp.setRspName("\u6821\u9a8c\u8fd4\u56de\u7b7e\u540d\u5931\u8d25\uff01");
            return rsp;
        }
        String respCode = (String)rspData.get("respCode");
        if (!"00".equals(respCode)) {
            rsp.setRspCode("8888");
            rsp.setRspName((String)rspData.get("respMsg"));
            return rsp;
        }
        String outPutDirectory = "C:\\Users\\lenovo\\Downloads";
        String fileContentDispaly = "";
        String zipFilePath = AcpService.deCodeFileContent((Map)rspData, (String)outPutDirectory, (String)"UTF-8");
        List fileList = FileUtil.unzip((String)zipFilePath, (String)outPutDirectory);
        fileContentDispaly = "<br>\u83b7\u53d6\u5230\u5546\u6237\u5bf9\u8d26\u6587\u4ef6\uff0c\u5e76\u843d\u5730\u5230" + outPutDirectory + ",\u5e76\u89e3\u538b\u7f29 <br>";
        for (String file : fileList) {
            if (file.indexOf("ZM_") != -1) {
                List ZmDataList = FileUtil.parseZMFile((String)file);
                fileContentDispaly = fileContentDispaly + FileUtil.getFileContentTable((List)ZmDataList, (String)file);
                continue;
            }
            if (file.indexOf("ZME_") == -1) continue;
            FileUtil.parseZMEFile((String)file);
        }
        System.out.println(zipFilePath);
        rsp.setFileContent(fileContentDispaly);
        rsp.setRspCode("0000");
        rsp.setRspName("\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u6210\u529f\uff01");
        return rsp;
    }

    private Map<String, String> loadProperties(UnionPayFileTransferBusiReqBO req) {
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(req.getMerchantId());
        paraReq.setPayMethod(req.getPayMethod());
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u94f6\u8054\u652f\u4ed8\u83b7\u53d6\u5bf9\u8d26\u6587\u4ef6\u4ea4\u6613\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + paraReq.getMerchantId() + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u94f6\u8054\u652f\u4ed8\u83b7\u53d6\u5bf9\u8d26\u6587\u4ef6\u4ea4\u6613\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + paraReq.getMerchantId() + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, String> payParaMap = new HashMap<String, String>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            payParaMap.put(para.getAttrCode(), para.getAttrValue());
        }
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, payParaMap);
        return payParaMap;
    }

    private Map<String, String> createReqContent(UnionPayFileTransferBusiReqBO req, String merId) {
        HashMap<String, String> data = new HashMap<String, String>(64);
        data.put("version", SdkConfig.getConfig().getVersion());
        data.put("encoding", "UTF-8");
        data.put("signMethod", SdkConfig.getConfig().getSignMethod());
        data.put("txnType", "76");
        data.put("txnSubType", "01");
        data.put("bizType", "000000");
        data.put("accessType", "0");
        data.put("merId", merId);
        data.put("settleDate", req.getSettleDate());
        data.put("txnTime", DateUtils.dateToStr((Date)this.queryDBDateBusiService.getDBDate(), (String)"yyyyMMddHHmmss"));
        data.put("fileType", "00");
        return data;
    }
}

