/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.AliPayQueryService;
import com.tydic.payment.pay.busi.GdBank4PayStateQueryBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.UnionPayOrderQueryBusiService;
import com.tydic.payment.pay.busi.WXPayStateQueryBusiService;
import com.tydic.payment.pay.busi.bo.AliPayQueryReqBo;
import com.tydic.payment.pay.busi.bo.AliPayQueryRspBo;
import com.tydic.payment.pay.busi.bo.GdBank4PayStateQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.GdBank4PayStateQueryBusiRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.UnionPayOrderQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXPayStateQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXPayStateQueryBusiRspBO;
import com.tydic.payment.pay.comb.OrderQueryCombService;
import com.tydic.payment.pay.comb.bo.OrderQueryCombReqBO;
import com.tydic.payment.pay.comb.bo.OrderQueryCombRspBO;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.comb.OrderQueryCombService"})
public class OrderQueryCombServiceImpl
implements OrderQueryCombService {
    private static final Logger log = LoggerFactory.getLogger(OrderQueryCombServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private WXPayStateQueryBusiService wXPayStateQueryBusiService;
    @Autowired
    private AliPayQueryService aliPayQueryService;
    @Autowired
    private GdBank4PayStateQueryBusiService gdBank4PayStateQueryBusiService;
    @Autowired
    private UnionPayOrderQueryBusiService unionPayOrderQueryBusiService;

    @PostMapping(value={"orderQueryComb"})
    public OrderQueryCombRspBO orderQueryComb(@RequestBody OrderQueryCombReqBO req) throws Exception {
        OrderQueryCombRspBO rsp = new OrderQueryCombRspBO();
        try {
            this.checkInputParas(req);
            PorderPayTransAtomReqBo porderPayTransAtomReqBo = new PorderPayTransAtomReqBo();
            porderPayTransAtomReqBo.setPayOrderId(req.getPayOrderId());
            PorderPayTransAtomRspBo porderPayTransAtomRspBo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(porderPayTransAtomReqBo);
            if (porderPayTransAtomRspBo == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010PAY_ORDER_ID=" + req.getPayOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(porderPayTransAtomRspBo.getOrderId());
            if (orderInfo == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + porderPayTransAtomRspBo.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            Long merchant_id = orderInfo.getMerchantId();
            String orderId = String.valueOf(porderPayTransAtomRspBo.getOrderId());
            if (StringUtils.isEmpty((Object)merchant_id)) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + porderPayTransAtomRspBo.getOrderId() + "\u3011\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\u4e2d\u65e0\u5546\u6237\u53f7\uff01");
            }
            String payMethod = String.valueOf(porderPayTransAtomRspBo.getPayMethod());
            QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
            paraReq.setMerchantId(String.valueOf(merchant_id));
            paraReq.setPayMethod(payMethod);
            QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
            if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
            }
            if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
            }
            Map<String, Object> paramMap = this.getParamMap(paraInfo);
            if ("10".equals(payMethod) || "11".equals(payMethod) || "13".equals(payMethod) || "12".equals(payMethod) || "14".equals(payMethod)) {
                WXPayStateQueryBusiReqBO wXPayOrderQueryReq = new WXPayStateQueryBusiReqBO();
                wXPayOrderQueryReq.setOrderId(orderId);
                wXPayOrderQueryReq.setPayOrderId(req.getPayOrderId());
                wXPayOrderQueryReq.setParamMap(paramMap);
                WXPayStateQueryBusiRspBO wXPayOrderQueryRsp = this.wXPayStateQueryBusiService.dealWXPayStateQuery(wXPayOrderQueryReq);
                BeanUtils.copyProperties((Object)wXPayOrderQueryRsp, (Object)rsp);
            } else if ("20".equals(payMethod) || "21".equals(payMethod) || "23".equals(payMethod) || "22".equals(payMethod) || "24".equals(payMethod)) {
                AliPayQueryReqBo aliPayQueryReqBo = new AliPayQueryReqBo();
                aliPayQueryReqBo.setOrderId(Long.valueOf(Long.parseLong(orderId)));
                aliPayQueryReqBo.setPayOrderId(req.getPayOrderId());
                aliPayQueryReqBo.setParamMap(paramMap);
                AliPayQueryRspBo aliPayQueryRspBo = this.aliPayQueryService.dealQuery(aliPayQueryReqBo);
                if (!"0000".equals(aliPayQueryRspBo.getRspCode())) {
                    log.info("\u67e5\u8be2\u5931\u8d25");
                }
                BeanUtils.copyProperties((Object)aliPayQueryRspBo, (Object)rsp);
            } else if ("120".equals(payMethod)) {
                GdBank4PayStateQueryBusiReqBo gbPayReqBo = new GdBank4PayStateQueryBusiReqBo();
                gbPayReqBo.setOrderId(orderId);
                gbPayReqBo.setPayOrderId(req.getPayOrderId());
                gbPayReqBo.setParamMap(paramMap);
                GdBank4PayStateQueryBusiRspBo gbPayRspBo = this.gdBank4PayStateQueryBusiService.dealGbBank4QueryStateQuery(gbPayReqBo);
                if (!"0000".equals(gbPayRspBo.getRspCode())) {
                    log.info("\u67e5\u8be2\u5931\u8d25");
                }
                BeanUtils.copyProperties((Object)gbPayRspBo, (Object)rsp);
            } else if ("110".equals(payMethod) || "112".equals(payMethod) || "113".equals(payMethod)) {
                UnionPayOrderQueryBusiReqBO unionPayOrderQueryBusiReqBO = new UnionPayOrderQueryBusiReqBO();
                unionPayOrderQueryBusiReqBO.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
                unionPayOrderQueryBusiReqBO.setOrderId(orderId);
                unionPayOrderQueryBusiReqBO.setPayOrderId(req.getPayOrderId());
                unionPayOrderQueryBusiReqBO.setTxnTime(DateUtils.dateToStr((Date)porderPayTransAtomRspBo.getCreateTime(), (String)"yyyyMMddHHmmss"));
                this.unionPayOrderQueryBusiService.dealUnionPayOrderQuery(unionPayOrderQueryBusiReqBO);
            }
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void checkInputParas(OrderQueryCombReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

