/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.CashierPayMethodRelAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.CashierPayMethodRelPageReqPO;
import com.tydic.payment.pay.dao.po.CashierPayMethodRelPo;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.CodePayMethodStr;
import com.tydic.payment.pay.web.bo.req.QueryCashierPayMethodNewServiceReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryCashierPayMethodAvailableRspBo;
import com.tydic.payment.pay.web.bo.rsp.QueryCashierPayMethodNewServiceRspBo;
import com.tydic.payment.pay.web.service.QueryCashierPayMethodNewService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_TEST/2.0.0/com.tydic.payment.pay.web.service.QueryCashierPayMethodNewService"})
public class QueryCashierPayMethodNewServiceImpl
implements QueryCashierPayMethodNewService {
    private static final Logger log = LoggerFactory.getLogger(QueryCashierPayMethodNewServiceImpl.class);
    private static String SERVICE_NAME = "\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u67e5\u8be2\u670d\u52a1";
    @Autowired
    CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    CashierPayMethodRelAtomService cashierPayMethodRelAtomService;
    @Autowired
    PayMethodAtomService payMethodAtomService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;

    @PostMapping(value={"queryCashierPayMethod"})
    public QueryCashierPayMethodNewServiceRspBo queryCashierPayMethod(@RequestBody QueryCashierPayMethodNewServiceReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        QueryCashierPayMethodNewServiceRspBo rspBo = new QueryCashierPayMethodNewServiceRspBo();
        ArrayList<CodePayMethodStr> codePayMethodList = new ArrayList<CodePayMethodStr>();
        rspBo.setCodePayMethodList(codePayMethodList);
        this.validateArg(reqBo);
        Long casherTemplateId = Long.valueOf(reqBo.getCashierTemplate());
        CashierTemplatePo qryCashierResult = this.cashierTemplateAtomService.queryCashierTemplateById(casherTemplateId);
        if (reqBo == null) {
            log.info(SERVICE_NAME + " -> \u5931\u8d25\uff1a\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
            return rspBo;
        }
        BeanUtils.copyProperties((Object)qryCashierResult, (Object)rspBo);
        rspBo.setCashierTemplate(qryCashierResult.getCashierTemplate().toString());
        rspBo.setCreateTime(qryCashierResult.getCreateTime() == null ? "" : new DateTime((Object)qryCashierResult.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setCreateOperId(qryCashierResult.getCreateOperId() == null ? "" : qryCashierResult.getCreateOperId());
        rspBo.setUpdateOperId(qryCashierResult.getUpdateOperId() == null ? "" : qryCashierResult.getUpdateOperId());
        rspBo.setUpdateTime(qryCashierResult.getUpdateTime() == null ? "" : new DateTime((Object)qryCashierResult.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setRemark(qryCashierResult.getRemark() == null ? "" : qryCashierResult.getRemark());
        if (!StringUtils.isEmpty((Object)qryCashierResult.getReqWay())) {
            QueryPCodeInfoReqBO reqWayReq = new QueryPCodeInfoReqBO();
            reqWayReq.setTypeCode("BUSI_SYSTEM_REQ_WAY");
            reqWayReq.setCodeValue(qryCashierResult.getReqWay());
            QueryPCodeInfoRspBO reqWayRsp = this.queryPCodeInfoService.queryPCodeInfo(reqWayReq);
            if (reqWayRsp.getRespCode().equals("0000")) {
                rspBo.setReqWayName(reqWayRsp.getCodeInfo());
            } else {
                rspBo.setReqWayName(qryCashierResult.getReqWay());
            }
        }
        if (!StringUtils.isEmpty((Object)qryCashierResult.getFlag())) {
            QueryPCodeInfoReqBO flagReq = new QueryPCodeInfoReqBO();
            flagReq.setTypeCode("TEMPLATE_FLAG");
            flagReq.setCodeValue(qryCashierResult.getFlag());
            QueryPCodeInfoRspBO flagRsp = this.queryPCodeInfoService.queryPCodeInfo(flagReq);
            if (flagRsp.getRespCode().equals("0000")) {
                rspBo.setFlagName(flagRsp.getCodeInfo());
            } else {
                rspBo.setFlagName(qryCashierResult.getFlag());
            }
        }
        CashierPayMethodRelPo qryRelCashierPayM = new CashierPayMethodRelPo();
        qryRelCashierPayM.setCashierTemplate(casherTemplateId);
        List<CashierPayMethodRelPo> payMethodL = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(qryRelCashierPayM);
        if (CollectionUtils.isEmpty(payMethodL)) {
            log.info(SERVICE_NAME + " -> \u6210\u529f\uff1a\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u6ca1\u6709\u5173\u8054\u7684\u652f\u4ed8\u65b9\u5f0f");
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u6ca1\u6709\u5173\u8054\u7684\u652f\u4ed8\u65b9\u5f0f");
            return rspBo;
        }
        for (CashierPayMethodRelPo temp : payMethodL) {
            CodePayMethodStr tempStr = new CodePayMethodStr();
            tempStr.setPayMethod(temp.getPayMethod().toString());
            PayMethodPo qryPayMethodL = this.payMethodAtomService.queryPayMethodById(temp.getPayMethod());
            if (qryPayMethodL == null) {
                tempStr.setPayMethodName(temp.getPayMethod().toString());
            }
            if (qryPayMethodL != null) {
                tempStr.setPayMethodName(qryPayMethodL.getPayMethodName());
            }
            codePayMethodList.add(tempStr);
        }
        log.info(SERVICE_NAME + " -> \u6210\u529f");
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u67e5\u8be2\u6210\u529f");
        return rspBo;
    }

    private void validateArg(QueryCashierPayMethodNewServiceReqBo reqBo) {
        if (reqBo == null) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getCashierTemplate())) {
            log.info(SERVICE_NAME + "\u5165\u53c2cashierTemplate(\u6536\u94f6\u53f0\u6a21\u677fid)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6536\u94f6\u53f0\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @PostMapping(value={"queryCashierAvailablePayMethod"})
    public QueryCashierPayMethodAvailableRspBo queryCashierAvailablePayMethod(@RequestBody QueryCashierPayMethodNewServiceReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        QueryCashierPayMethodAvailableRspBo retBo = new QueryCashierPayMethodAvailableRspBo();
        ArrayList<CodePayMethodStr> codePayMethodList = new ArrayList<CodePayMethodStr>();
        retBo.setCodePayMethodList(codePayMethodList);
        this.validateArg(reqBo);
        PayMethodPo qryPayMPo = new PayMethodPo();
        List<PayMethodPo> payMPoL = this.payMethodAtomService.queryPayMethod(qryPayMPo);
        if (CollectionUtils.isEmpty(payMPoL)) {
            log.info(SERVICE_NAME + " -> \u6210\u529f\uff1a\u6ca1\u6709\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\u7684\u6570\u636e");
            retBo.setRspCode("0000");
            retBo.setRspName("\u6ca1\u6709\u652f\u4ed8\u65b9\u5f0f\u53ef\u4ee5\u9009\u62e9\uff0c\u8bf7\u914d\u7f6e\u652f\u4ed8\u673a\u6784");
            return retBo;
        }
        CashierPayMethodRelPo qryRelCashierPayM = new CashierPayMethodRelPo();
        qryRelCashierPayM.setCashierTemplate(Long.valueOf(reqBo.getCashierTemplate()));
        List<CashierPayMethodRelPo> payRelMethodL = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(qryRelCashierPayM);
        HashSet<Long> relPayL = new HashSet<Long>();
        for (CashierPayMethodRelPo ttmp : payRelMethodL) {
            relPayL.add(ttmp.getPayMethod());
        }
        for (PayMethodPo temp : payMPoL) {
            if (relPayL.contains(temp.getPayMethod())) continue;
            CodePayMethodStr tempBo = new CodePayMethodStr();
            BeanUtils.copyProperties((Object)temp, (Object)tempBo);
            tempBo.setPayMethod(temp.getPayMethod() == null ? "" : temp.getPayMethod().toString());
            codePayMethodList.add(tempBo);
        }
        log.info(SERVICE_NAME + " -> \u6210\u529f");
        retBo.setRspCode("0000");
        retBo.setRspName("\u67e5\u8be2\u6210\u529f");
        return retBo;
    }

    @PostMapping(value={"queryCashierPayMethodWithPage"})
    public RspPage<CodePayMethodStr> queryCashierPayMethodWithPage(@RequestBody QueryCashierPayMethodNewServiceReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        RspPage retBo = new RspPage();
        ArrayList<CodePayMethodStr> codePayMethodList = new ArrayList<CodePayMethodStr>();
        retBo.setRows(codePayMethodList);
        this.validateArg(reqBo);
        Long casherTemplateId = Long.valueOf(reqBo.getCashierTemplate());
        CashierTemplatePo qryCashierResult = this.cashierTemplateAtomService.queryCashierTemplateById(casherTemplateId);
        if (reqBo == null) {
            log.info(SERVICE_NAME + " -> \u5931\u8d25\uff1a\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
            retBo.setPageNo(1);
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            return retBo;
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        CashierPayMethodRelPageReqPO qryRelCashierPayM = new CashierPayMethodRelPageReqPO();
        qryRelCashierPayM.setCashierTemplate(casherTemplateId);
        List<CashierPayMethodRelPo> payMethodL = this.cashierPayMethodRelAtomService.queryPayMethodRelCashierWithPage((Page<CashierPayMethodRelPageReqPO>)page, qryRelCashierPayM);
        if (CollectionUtils.isEmpty(payMethodL)) {
            log.info(SERVICE_NAME + " -> \u6210\u529f\uff1a\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u6ca1\u6709\u5173\u8054\u7684\u652f\u4ed8\u65b9\u5f0f");
            retBo.setPageNo(1);
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            return retBo;
        }
        for (CashierPayMethodRelPo temp : payMethodL) {
            CodePayMethodStr tempStr = new CodePayMethodStr();
            tempStr.setPayMethod(temp.getPayMethod().toString());
            PayMethodPo qryPayMethodL = this.payMethodAtomService.queryPayMethodById(temp.getPayMethod());
            if (qryPayMethodL == null) {
                tempStr.setPayMethodName(temp.getPayMethod().toString());
            }
            if (qryPayMethodL != null) {
                tempStr.setPayMethodName(qryPayMethodL.getPayMethodName());
            }
            CashierPayMethodRelPo qryRelCashiPayPo = new CashierPayMethodRelPo();
            qryRelCashiPayPo.setCashierTemplate(casherTemplateId);
            qryRelCashiPayPo.setPayMethod(temp.getPayMethod());
            List<CashierPayMethodRelPo> cashRelPL = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(qryRelCashiPayPo);
            if (!CollectionUtils.isEmpty(cashRelPL)) {
                CashierPayMethodRelPo ttCa = cashRelPL.get(0);
                tempStr.setCreateTime(ttCa.getCreateTime() == null ? "" : new DateTime((Object)ttCa.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                tempStr.setCreateOperId(ttCa.getCreateOperId() == null ? "" : ttCa.getCreateOperId());
                tempStr.setUpdateOperId(ttCa.getUpdateOperId() == null ? "" : ttCa.getUpdateOperId());
                tempStr.setUpdateTime(ttCa.getUpdateTime() == null ? "" : new DateTime((Object)ttCa.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                tempStr.setRemark(ttCa.getRemark() == null ? "" : ttCa.getRemark());
            }
            codePayMethodList.add(tempStr);
        }
        log.info(SERVICE_NAME + " -> \u6210\u529f");
        retBo.setPageNo(page.getPageNo());
        retBo.setRecordsTotal(page.getTotalCount());
        retBo.setTotal(page.getTotalPages());
        return retBo;
    }
}

