/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ali.model;

import com.google.gson.annotations.SerializedName;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.model.RequestBuilder;
import org.apache.commons.lang.StringUtils;

public class AlipayTradeAppPayRequestBuilder
extends RequestBuilder {
    private BizContent bizContent = new BizContent();

    @Override
    public BizContent getBizContent() {
        return this.bizContent;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isEmpty((String)this.bizContent.product_code)) {
            throw new NullPointerException("product_code should not be NULL!");
        }
        if (StringUtils.isEmpty((String)this.bizContent.outTradeNo)) {
            throw new NullPointerException("out_trade_no should not be NULL!");
        }
        if (StringUtils.isEmpty((String)this.bizContent.totalAmount)) {
            throw new NullPointerException("total_amount should not be NULL!");
        }
        if (StringUtils.isEmpty((String)this.bizContent.subject)) {
            throw new NullPointerException("subject should not be NULL!");
        }
        if (StringUtils.isEmpty((String)this.bizContent.storeId)) {
            throw new NullPointerException("store_id should not be NULL!");
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AlipayTradePayRequestBuilder{");
        sb.append("bizContent=").append(this.bizContent);
        sb.append(", super=").append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    public AlipayTradeAppPayRequestBuilder() {
        this.bizContent.product_code = "QUICK_MSECURITY_PAY";
        this.bizContent.goods_type = "0";
    }

    public String getSubject() {
        return this.bizContent.subject;
    }

    public AlipayTradeAppPayRequestBuilder setSubject(String subject) {
        this.bizContent.subject = subject;
        return this;
    }

    public String getBody() {
        return this.bizContent.body;
    }

    public AlipayTradeAppPayRequestBuilder setBody(String body) {
        this.bizContent.body = body;
        return this;
    }

    public String getOutTradeNo() {
        return this.bizContent.outTradeNo;
    }

    public AlipayTradeAppPayRequestBuilder setOutTradeNo(String outTradeNo) {
        this.bizContent.outTradeNo = outTradeNo;
        return this;
    }

    public String getTimeoutExpress() {
        return this.bizContent.timeoutExpress;
    }

    public AlipayTradeAppPayRequestBuilder setTimeoutExpress(String timeoutExpress) {
        this.bizContent.timeoutExpress = timeoutExpress;
        return this;
    }

    public String getTotalAmount() {
        return this.bizContent.totalAmount;
    }

    public AlipayTradeAppPayRequestBuilder setTotalAmount(String totalAmount) {
        this.bizContent.totalAmount = totalAmount;
        return this;
    }

    public String getSellerId() {
        return this.bizContent.sellerId;
    }

    public AlipayTradeAppPayRequestBuilder setSellerId(String sellerId) {
        this.bizContent.sellerId = sellerId;
        return this;
    }

    public String getProduct_code() {
        return this.bizContent.product_code;
    }

    public AlipayTradeAppPayRequestBuilder setProduct_code(String product_code) {
        this.bizContent.product_code = product_code;
        return this;
    }

    public String getGoods_type() {
        return this.bizContent.goods_type;
    }

    public AlipayTradeAppPayRequestBuilder setGoods_type(String goods_type) {
        this.bizContent.goods_type = goods_type;
        return this;
    }

    public String getPassback_params() {
        return this.bizContent.passback_params;
    }

    public AlipayTradeAppPayRequestBuilder setPassback_params(String passback_params) {
        this.bizContent.passback_params = passback_params;
        return this;
    }

    public ExtendParams getExtendParams() {
        return this.bizContent.extendParams;
    }

    public AlipayTradeAppPayRequestBuilder setExtendParams(ExtendParams extendParams) {
        this.bizContent.extendParams = extendParams;
        return this;
    }

    @Override
    public AlipayTradeAppPayRequestBuilder setNotifyUrl(String notifyUrl) {
        return (AlipayTradeAppPayRequestBuilder)super.setNotifyUrl(notifyUrl);
    }

    public AlipayTradeAppPayRequestBuilder setStoreId(String storeId) {
        this.bizContent.storeId = storeId;
        return this;
    }

    public String getStoreId() {
        return this.bizContent.storeId;
    }

    public static class BizContent {
        private String subject;
        private String body;
        @SerializedName(value="out_trade_no")
        private String outTradeNo;
        @SerializedName(value="timeout_express")
        private String timeoutExpress;
        @SerializedName(value="total_amount")
        private String totalAmount;
        @SerializedName(value="seller_id")
        private String sellerId;
        private String product_code;
        private String goods_type;
        @SerializedName(value="passback_params")
        private String passback_params;
        @SerializedName(value="extend_params")
        private ExtendParams extendParams;
        @SerializedName(value="store_id")
        private String storeId;

        public String toString() {
            StringBuilder sb = new StringBuilder("BizContent{");
            sb.append(", subject='").append(this.subject).append('\'');
            sb.append(", body='").append(this.body).append('\'');
            sb.append(", outTradeNo='").append(this.outTradeNo).append('\'');
            sb.append(", timeoutExpress='").append(this.timeoutExpress).append('\'');
            sb.append(", totalAmount='").append(this.totalAmount).append('\'');
            sb.append(", sellerId='").append(this.sellerId).append('\'');
            sb.append("product_code='").append(this.product_code).append('\'');
            sb.append(", goods_type='").append(this.goods_type).append('\'');
            sb.append(", passback_params='").append(this.passback_params).append('\'');
            sb.append(", extendParams=").append(this.extendParams);
            sb.append(", storeId='").append(this.storeId).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

