/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config.quartz;

import com.tydic.payment.pay.config.quartz.PayJobFactory;
import com.tydic.payment.pay.config.quartz.PaySchedulerFactoryBean;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.util.StringUtils;

@Configuration
public class QuartzConfiguration {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PayJobFactory payJobFactory;

    @Bean
    public SchedulerFactoryBean payCenterSchedulerFactoryBean() {
        PaySchedulerFactoryBean schedulerFactoryBean = new PaySchedulerFactoryBean();
        if (this.payPropertiesVo.isUseMulitpleCallBack()) {
            schedulerFactoryBean.setDataSource(this.dataSource);
            Properties properties = this.getQuartzProperties();
            schedulerFactoryBean.setQuartzProperties(properties);
            schedulerFactoryBean.setJobFactory((JobFactory)this.payJobFactory);
        }
        return schedulerFactoryBean;
    }

    private Properties getQuartzProperties() {
        ArrayList<String> quartzKeys = new ArrayList<String>();
        quartzKeys.add("org.quartz.jobStore.class");
        quartzKeys.add("org.quartz.jobStore.driverDelegateClass");
        quartzKeys.add("org.quartz.jobStore.useProperties");
        quartzKeys.add("org.quartz.threadPool.threadCount");
        quartzKeys.add("org.quartz.threadPool.class");
        Properties properties = new Properties();
        for (String key : quartzKeys) {
            String value = this.payPropertiesVo.getValueByKey(key);
            if (StringUtils.isEmpty((Object)value)) {
                this.LOGGER.error("quartz\u914d\u7f6e\u503c(" + key + ")\u4e3a\u7a7a\u4e86\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                continue;
            }
            properties.put(key, value);
        }
        return properties;
    }

    @Bean
    public Scheduler scheduler(SchedulerFactoryBean payCenterSchedulerFactoryBean) throws SchedulerException {
        Scheduler scheduler = payCenterSchedulerFactoryBean.getScheduler();
        scheduler.start();
        return scheduler;
    }
}

