/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.ohaotian.plugin.file.FileClient;
import com.sinovatech.unicom.util.sign.CryptUtil;
import com.sinovatech.unicom.util.sign.PayResponseBean;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.wopay.util.SSLClient;
import com.tydic.payment.pay.wopay.util.SingleOrderQuery;
import com.tydic.payment.pay.wopay.util.SingleOrderRefund;
import com.tydic.payment.pay.wopay.util.UniPaySignUtilsCer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractWopayPayAble
implements PayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Resource
    private FileClient fileClient;
    private static final String PAY_RESULE_OK = "1";
    private static final String SIGN_TYPE = "RSA_SHA256";
    private final Map<String, File> fileCache = new HashMap<String, File>();
    private final String REFUND_SUCCESS_KEY = "transRet";
    private final String REFUND_SUCCESS_VALUE = "SUCCESS";
    private static final String NORMAL_REFUND_DESC = "\u6b63\u5e38\u9000\u6b3e";
    private final String QUERY_SUCCESS_KEY = "queryResult";
    private final String QUERY_SUCCESS_VALUE = "SUCCESS";
    public static final String QUERY_STATUS_SUCCESS = "1";
    public static final String QUERY_STATUS_PAYING = "0";
    public static final String QUERY_STATUS_CLOSED = "2";

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        PayAbleRefundRspBo rspBo = new PayAbleRefundRspBo();
        String validateArgStr = this.validateRefundArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        String refundUrl = this.payPropertiesVo.getValueByKey("wopay.mobile.refund.url");
        if (StringUtils.isEmpty((Object)refundUrl)) {
            this.LOGGER.error("\u9000\u6b3e\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u68c0\u67e5\u914d\u7f6e\uff1awopay.mobile.refund.url");
            rspBo.setRespCode("211003");
            rspBo.setRespDesc("\u9000\u6b3e\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u68c0\u67e5\u914d\u7f6e\uff1awopay.mobile.refund.url");
            return rspBo;
        }
        SingleOrderRefund wopayRefundBean = this.generateRefundBean(reqBo);
        String generateSignMsgResult = this.generateRefundSignMsg(reqBo, wopayRefundBean);
        if (!StringUtils.isEmpty((Object)generateSignMsgResult)) {
            rspBo.setRespCode("211003");
            rspBo.setRespDesc(generateSignMsgResult);
            return rspBo;
        }
        Map<String, String> refundRequestMap = this.generateRefundRequestMap(wopayRefundBean);
        String refundResult = "";
        try {
            refundResult = SSLClient.doPost((String)refundUrl, refundRequestMap);
            this.LOGGER.info("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a\n" + refundResult);
        }
        catch (Exception e) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rspBo.setRespCode("211003");
            rspBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            return rspBo;
        }
        Map<String, String> resultMap = this.parseResult2Map(refundResult);
        if (!resultMap.isEmpty() && "SUCCESS".equalsIgnoreCase(resultMap.get("transRet"))) {
            BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
            if (StringUtils.isEmpty((Object)rspBo.getRefundReason())) {
                rspBo.setRefundReason(NORMAL_REFUND_DESC);
            }
            rspBo.setRefundTransId(resultMap.get("acceptNo"));
            String tradeTime = new DateTime((Object)this.payMethodMapper.getDBDate().getDate()).toString("yyyyMMddHHmmss");
            rspBo.setTradeTime(tradeTime);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u9000\u6b3e\u6210\u529f");
            return rspBo;
        }
        rspBo.setRespCode("211003");
        rspBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + resultMap.get("resultDis"));
        return rspBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateQueryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("211004");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String queryUrl = this.payPropertiesVo.getValueByKey("wopay.mobile.query.url");
        if (StringUtils.isEmpty((Object)queryUrl)) {
            this.LOGGER.error("\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u68c0\u67e5\u914d\u7f6e\uff1awopay.mobile.query.url");
            retBo.setRespCode("211004");
            retBo.setRespDesc("\u67e5\u8be2\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u68c0\u67e5\u914d\u7f6e\uff1awopay.mobile.query.url");
            return retBo;
        }
        SingleOrderQuery reqQueryBean = this.generateQueryBean(reqBo);
        String querySignMsgResult = this.generateQuerySignMsg(reqBo, reqQueryBean);
        if (!StringUtils.isEmpty((Object)querySignMsgResult)) {
            retBo.setRespCode("211004");
            retBo.setRespDesc(querySignMsgResult);
            return retBo;
        }
        Map reqMap = UniPaySignUtilsCer.obj2NormalMap((Object)reqQueryBean);
        String queryResult = "";
        try {
            queryResult = SSLClient.doPost((String)queryUrl, (Map)reqMap);
            this.LOGGER.info("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + queryResult);
        }
        catch (Exception e) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8-\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            retBo.setRespCode("211004");
            retBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8-\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        Map<String, String> resultMap = this.parseResult2Map(queryResult);
        String queryReqResult = resultMap.get("queryResult");
        if (!resultMap.isEmpty() && "SUCCESS".equalsIgnoreCase(queryReqResult)) {
            retBo.setOrderId(reqBo.getOrderId());
            retBo.setPayOrderId(reqBo.getPayOrderId());
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u67e5\u8be2\u6210\u529f(wopay_mobile)");
            String orderState = resultMap.get("orderState");
            if ("1".equalsIgnoreCase(orderState)) {
                retBo.setTradeTime(reqBo.getTradeTime());
                retBo.setPayNotifyTransId(reqBo.getPayNotifyTransId());
                retBo.setRealFee(Long.valueOf(Long.parseLong(resultMap.get("payAmount"))));
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f(wopay_mobile)");
            } else if (QUERY_STATUS_PAYING.equalsIgnoreCase(orderState)) {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u7528\u6237\u652f\u4ed8\u4e2d(wopay_mobile)");
            } else if (QUERY_STATUS_CLOSED.equalsIgnoreCase(orderState)) {
                retBo.setPayStatus("CLOSED");
                retBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u5173\u95ed(wopay_mobile)");
            } else {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u8ba2\u5355\u652f\u4ed8\u5931\u8d25(wopay_mobile)");
            }
        } else {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8-\u67e5\u8be2\u5931\u8d25\uff1a" + queryReqResult);
            retBo.setRespCode("211004");
            retBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8-\u67e5\u8be2\u5931\u8d25\uff1a" + queryReqResult);
            return retBo;
        }
        return retBo;
    }

    private Map<String, String> parseResult2Map(String refundResult) {
        String[] resultArray;
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        if (StringUtils.isEmpty((Object)refundResult)) {
            return resultMap;
        }
        for (String r : resultArray = refundResult.split("\n")) {
            String[] valueArray;
            if (StringUtils.isEmpty((Object)r) || (valueArray = r.split("=")).length <= 1) continue;
            resultMap.put(valueArray[0], valueArray[1]);
        }
        return resultMap;
    }

    private String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayNotifyTransId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PayNotifyTransId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        if (paraMap == null || paraMap.isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e2dkey(merNo)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merSignDir"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e2dkey(merSignDir)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merSignKey"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e2dkey(merSignKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PayOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTradeTime())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027TradeTime\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getRefundFee() == null || reqBo.getRefundFee() <= 0L) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027RefundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundReason())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027RefundReason\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private Map<String, String> generateRefundRequestMap(SingleOrderRefund wopayRefundBean) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("refundReqJournl", wopayRefundBean.getRefundReqJournl());
        map.put("merNo", wopayRefundBean.getMerNo());
        map.put("orderNo", wopayRefundBean.getOrderNo());
        map.put("orderDate", wopayRefundBean.getOrderDate());
        map.put("payJournl", wopayRefundBean.getPayJournl());
        map.put("merReqTime", wopayRefundBean.getMerReqTime());
        map.put("amount", wopayRefundBean.getAmount().toString());
        map.put("reason", wopayRefundBean.getReason());
        map.put("signType", wopayRefundBean.getSignType());
        map.put("signMsg", wopayRefundBean.getSignMsg());
        return map;
    }

    private SingleOrderRefund generateRefundBean(PayAbleRefundReqBo reqBo) {
        SingleOrderRefund wopayRefundBean = new SingleOrderRefund();
        String reqDataStr = new DateTime((Object)this.payMethodMapper.getDBDate().getDate()).toString("yyyyMMddHHmmss");
        wopayRefundBean.setRefundReqJournl(reqBo.getRefundOrderId());
        wopayRefundBean.setMerNo((String)reqBo.getParaMap().get("merNo"));
        wopayRefundBean.setOrderNo(reqBo.getPayOrderId());
        wopayRefundBean.setOrderDate(reqBo.getTradeTime().substring(0, 8));
        wopayRefundBean.setPayJournl(reqBo.getPayNotifyTransId());
        wopayRefundBean.setMerReqTime(reqDataStr);
        wopayRefundBean.setAmount(Integer.valueOf(reqBo.getRefundFee().intValue()));
        wopayRefundBean.setReason(reqBo.getRefundReason());
        wopayRefundBean.setSignType(SIGN_TYPE);
        return wopayRefundBean;
    }

    private String generateRefundSignMsg(PayAbleRefundReqBo reqBo, SingleOrderRefund wopayRefundBean) {
        Map paraMap = reqBo.getParaMap();
        String merSignDir = (String)paraMap.get("merSignDir");
        String merSignKey = (String)paraMap.get("merSignKey");
        File signFile = null;
        signFile = this.fileCache.get(merSignDir) == null ? this.fileClient.downloadToFile(merSignDir) : this.fileCache.get(merSignDir);
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(signFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bb = new byte[4096];
            while ((len = fis.read(bb)) != -1) {
                baos.write(bb, 0, len);
            }
            fis.close();
            String signMsg = UniPaySignUtilsCer.merSign((Map)UniPaySignUtilsCer.obj2NormalMap((Object)wopayRefundBean), (String)wopayRefundBean.getSignType(), (boolean)false, (byte[])baos.toByteArray(), (String)merSignKey);
            this.LOGGER.info("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u9000\u6b3e\u751f\u6210\u7684\u7b7e\u540d\u4e32\u4e3a\uff1a" + signMsg);
            wopayRefundBean.setSignMsg(signMsg);
            baos.close();
        }
        catch (IOException e) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u9000\u6b3e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return "\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u9000\u6b3e\u5f02\u5e38\uff1a" + e.getMessage();
        }
        return null;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        PayAbleCallBackRspBo rspBo = new PayAbleCallBackRspBo();
        PayResponseBean payResponseBean = (PayResponseBean)CryptUtil.decryptBeanNoKey((String)reqBo.getReqData(), PayResponseBean.class);
        String base64Cer = this.payPropertiesVo.getValueByKey("wopay.mobile.base64Cer");
        Boolean veri = UniPaySignUtilsCer.merVerify((Map)UniPaySignUtilsCer.obj2LowerMap((Object)payResponseBean), (String)SIGN_TYPE, (String)payResponseBean.getHmac(), (String)base64Cer, (boolean)false);
        this.LOGGER.debug("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u56de\u8c03\u7b7e\u540d\u9a8c\u8bc1\u60c5\u51b5\uff1a" + veri);
        rspBo.setPayOrderId(payResponseBean.getOrderId());
        if (!veri.booleanValue()) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u56de\u8c03\u7b7e\u540d\u5931\u8d25");
            rspBo.setRespCode("211002");
            rspBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u56de\u8c03\u7b7e\u540d\u5931\u8d25");
            return rspBo;
        }
        if (!"1".equals(payResponseBean.getPayResult())) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u56de\u8c03\u8fd4\u56de\u652f\u4ed8\u5931\u8d25\u4e86");
            rspBo.setRespCode("211002");
            rspBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u56de\u8c03\u8fd4\u56de\u652f\u4ed8\u5931\u8d25\u4e86");
            return rspBo;
        }
        rspBo.setPayNotifyTransId(payResponseBean.getPayFloodId());
        rspBo.setPaymentInsReturnData(payResponseBean.getPaymentBalanceDetail());
        rspBo.setTradeTime(payResponseBean.getRespTime());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String generateQuerySignMsg(PayAbleQryPayStatusReqBo reqBo, SingleOrderQuery reqQueryBean) {
        Map paraMap = reqBo.getParaMap();
        String merSignDir = (String)paraMap.get("merSignDir");
        String merSignKey = (String)paraMap.get("merSignKey");
        File signFile = null;
        signFile = this.fileCache.get(merSignDir) == null ? this.fileClient.downloadToFile(merSignDir) : this.fileCache.get(merSignDir);
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(signFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bb = new byte[4096];
            while ((len = fis.read(bb)) != -1) {
                baos.write(bb, 0, len);
            }
            fis.close();
            String signMsg = UniPaySignUtilsCer.merSign((Map)UniPaySignUtilsCer.obj2NormalMap((Object)reqQueryBean), (String)reqQueryBean.getSignType(), (boolean)false, (byte[])baos.toByteArray(), (String)merSignKey);
            this.LOGGER.info("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u67e5\u8be2\u751f\u6210\u7684\u7b7e\u540d\u4e32\u4e3a\uff1a" + signMsg);
            reqQueryBean.setSignMsg(signMsg);
            baos.close();
        }
        catch (IOException e) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return "\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage();
        }
        return null;
    }

    private String validateQueryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        if (paraMap == null || paraMap.isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e2dkey(merNo)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merSignDir"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e2dkey(merSignDir)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merSignKey"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ParaMap\u4e2dkey(merSignKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PayOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private SingleOrderQuery generateQueryBean(PayAbleQryPayStatusReqBo reqBo) {
        SingleOrderQuery reqQueryBean = new SingleOrderQuery();
        reqQueryBean.setCharSet("UTF-8");
        reqQueryBean.setMerNo((String)reqBo.getParaMap().get("merNo"));
        if (!StringUtils.isEmpty((Object)reqBo.getTradeTime())) {
            reqQueryBean.setOrderDate(reqBo.getTradeTime().substring(0, 8));
        } else {
            reqQueryBean.setOrderDate(new DateTime((Object)reqBo.getCreateTime()).toString("yyyyMMdd"));
        }
        reqQueryBean.setOrderNo(reqBo.getPayOrderId());
        reqQueryBean.setSignType(SIGN_TYPE);
        return reqQueryBean;
    }
}

