/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.PayProGetParamsBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractChinaBankPayAble;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankBodyReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankHeadReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankRequestBo;
import com.tydic.payment.pay.util.BeanUtils;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="chinaBankOrderPayAbleImpl")
public class ChinaBankOrderPayAbleImpl
extends AbstractChinaBankPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(ChinaBankOrderPayAbleImpl.class);
    private String formHead = "<form id=\"chinaBankForm\" name=\"chinaBankForm\" method=\"post\" action=\"URL\">";
    private String inputItem = "<input type=\"hidden\" name=\"CODE\" value=\"VALUE\">";
    private String submit = "<input type=\"submit\" value=\"\u652f\u4ed8\" style=\"display:none\">";
    private String script = "<script>document.getElementById(\"chinaBankForm\").submit();</script>";
    @Value(value="${china.bank.close.time:7200000}")
    private long chinaBankCloseTime;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PayProGetParamsBusiService payProGetParamsBusiService;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.CHINA_BANK_ORDER_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        String payOrderPath = this.payPropertiesVo.getValueByKey("china.bank.order.pay.url");
        log.debug("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)payOrderPath);
        if (StringUtils.isEmpty((Object)payOrderPath)) {
            log.error("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u5730\u5740'china.bank.real.pay.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("212062");
            retBo.setRespDesc("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u5730\u5740'china.bank.real.pay.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        String chinaBankCallbackUrl = this.payPropertiesVo.getValueByKey("china.bank.order.pay.callback.url");
        if (StringUtils.isEmpty((Object)chinaBankCallbackUrl)) {
            retBo.setRespCode("212062");
            retBo.setRespDesc("\u652f\u4ed8\u4e2d\u5fc3\u63a5\u53d7\u4e2d\u884c\u652f\u4ed8\u7684\u56de\u8c03\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff1achina.bank.order.pay.callback.url");
            return retBo;
        }
        Map<String, Object> reqMap = this.assembleData(reqBo, chinaBankCallbackUrl);
        log.debug("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u63a5\u53e3\u7684\u8bf7\u6c42\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(reqMap));
        if (reqMap == null) {
            log.error("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            return retBo;
        }
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append(this.formHead.replace("URL", payOrderPath));
        for (String key : reqMap.keySet()) {
            String input = this.inputItem.replace("CODE", key).replace("VALUE", (String)reqMap.get(key));
            htmlBuilder.append(input);
        }
        htmlBuilder.append(this.submit);
        htmlBuilder.append("</form>");
        htmlBuilder.append(this.script);
        if (log.isDebugEnabled()) {
            log.debug("\u7ec4\u88c5\u597d\u7684HTML\u4e3a\uff1a" + htmlBuilder.toString());
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setHtmlBody(htmlBuilder.toString());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getPayFee() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return super.validateParaMap(reqBo.getParaMap());
    }

    private Map<String, Object> assembleData(PayAbleDealPayReqBo reqBo, String chinaBankCallbackUrl) {
        ChinaBankRequestBo chinaBankRequestBo = new ChinaBankRequestBo();
        ChinaBankHeadReqBo headReqBo = new ChinaBankHeadReqBo();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        headReqBo.setRequestTime(new DateTime((Object)dbDate).toString("yyyyMMddHHmmss"));
        chinaBankRequestBo.setHead(headReqBo);
        ChinaBankBodyReqBo bodyReqBo = new ChinaBankBodyReqBo();
        bodyReqBo.setOrderNo(reqBo.getPayOrderId());
        bodyReqBo.setCurrency("156");
        bodyReqBo.setAmount(reqBo.getPayFee().toString());
        bodyReqBo.setOrderTime(new DateTime((Object)dbDate).toString("yyyyMMddHHmmss"));
        bodyReqBo.setOrderNote(reqBo.getDetailName());
        bodyReqBo.setBackNotifyUrl(chinaBankCallbackUrl);
        bodyReqBo.setFrontNotifyUrl("");
        Date closeDate = new Date(dbDate.getTime() + this.chinaBankCloseTime);
        String closeTime = new DateTime((Object)closeDate).toString("yyyyMMddHHmmss");
        bodyReqBo.setCloseTime(closeTime);
        bodyReqBo.setBocFlag("1");
        bodyReqBo.setPayeeActNum((String)reqBo.getParaMap().get("chinaBankAccountNo"));
        bodyReqBo.setPayeeActNam((String)reqBo.getParaMap().get("chinaBankAccountName"));
        bodyReqBo.setPayeeIbkNum("");
        bodyReqBo.setPayeeBnkOrg("");
        bodyReqBo.setPayeeCnaps("");
        bodyReqBo.setPayeeIbkNam("");
        bodyReqBo.setPayerBankEpsbtp("");
        bodyReqBo.setSubMerchantInfo(reqBo.getMerchantId());
        chinaBankRequestBo.setBody(bodyReqBo);
        log.debug("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u652f\u4ed8\uff09\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)chinaBankRequestBo));
        String messageId = "0000115";
        return super.assembleFormData(chinaBankRequestBo, messageId);
    }
}

