/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.impl.transbo.SftBillReqBO;
import com.tydic.payment.pay.sft.MD5;
import com.tydic.payment.pay.sft.RSATool;
import com.tydic.payment.pay.util.SftHttpClient;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayBillAbleSftImpl
implements PayBillAble {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String UTF_8 = "UTF-8";
    private String ThirdSysID;
    private String TxCode;
    private String Data;
    private String Auth;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private SftHttpClient sftHttpClient;

    public Long paymentIns() {
        return BillConstant.PaymentIns.SFT_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        this.log.info("\u8fdb\u5165\u5584\u4ed8\u901a\u8d26\u5355\u4e0b\u8f7d\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        PayBillAbleDownloadRspBo retBo = new PayBillAbleDownloadRspBo();
        String sftRequestUrl = this.payPropertiesVo.getSFTRequestUrl();
        SftBillReqBO sftBillReqBO = new SftBillReqBO();
        sftBillReqBO.setTxCode("SFT10033");
        sftBillReqBO.setTransID(String.valueOf(PayProSequence.nextId()));
        sftBillReqBO.setQueryTime(String.valueOf(reqBo.getBillDate()));
        this.initParam(sftBillReqBO);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("ThirdSysID", this.ThirdSysID);
        dataMap.put("Data", this.Data);
        dataMap.put("TxCode", this.TxCode);
        dataMap.put("Auth", this.Auth);
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient client = this.getCloseableHttpClient();
            HttpPost httpPost = new HttpPost(sftRequestUrl);
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set keySet = dataMap.keySet();
            for (String key : keySet) {
                nvps.add(new BasicNameValuePair(key, (String)dataMap.get(key)));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)httpPost);
            InputStream inputStream = response.getEntity().getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public String encryp(String reqJson, String publicKeyStr) {
        String enStr = null;
        try {
            enStr = RSATool.clientEncrypt((String)reqJson, (String)publicKeyStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enStr;
    }

    private void initParam(SftBillReqBO sftBillReqBO) {
        String sftPublicKey = this.payPropertiesVo.getSFTPublicKey();
        String md5Key = this.payPropertiesVo.getSFTMD5Key();
        String reqJson = JSON.toJSONString((Object)sftBillReqBO);
        String enStr = this.encryp(reqJson, sftPublicKey);
        try {
            this.Data = URLEncoder.encode(enStr, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.Auth = MD5.getMD5((String)(this.ThirdSysID + this.TxCode + this.Data + md5Key), (String)"utf-8");
        this.TxCode = "SFT10033";
        this.ThirdSysID = this.payPropertiesVo.getSFTThirdSysId();
    }

    private byte[] unZip(byte[] data) {
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = null;
        ZipInputStream zip = null;
        byte[] b = null;
        try {
            bis = new ByteArrayInputStream(data);
            bos = new ByteArrayOutputStream();
            zip = new ZipInputStream(bis);
            while (zip.getNextEntry() != null) {
                int r = -1;
                byte[] buf = new byte[1024];
                while ((r = zip.read(buf, 0, buf.length)) != -1) {
                    bos.write(buf, 0, r);
                }
                b = bos.toByteArray();
                bos.flush();
                bos.close();
            }
            zip.close();
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            assert (sc != null);
            sc.init(null, new TrustManager[]{x509TrustManager}, null);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    private CloseableHttpClient getCloseableHttpClient() {
        SSLContext sslcontext = PayBillAbleSftImpl.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    public static byte[] inputStream2Byte(InputStream is) {
        int BUFFER_SIZE = 1024;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] date = new byte[BUFFER_SIZE];
        int len = -1;
        while (true) {
            try {
                len = is.read(date, 0, BUFFER_SIZE);
                if (-1 == len) {
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            os.write(date, 0, BUFFER_SIZE);
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFileByBytes(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

