/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.util;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sft.MD5;
import com.tydic.payment.pay.sft.RSATool;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SftHttpClient {
    private static final Logger log = LoggerFactory.getLogger(SftHttpClient.class);
    private static final String UTF_8 = "UTF-8";
    private String requestUrl;
    private String thirdSysId;
    private String publicKey;
    private String md5Key;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(Map<String, Object> reqMap) {
        String initResult = this.init();
        if (!StringUtils.isEmpty((Object)initResult)) {
            log.error("\u5584\u4ed8\u901a\u7f3a\u5c11\u914d\u7f6e\u4fe1\u606f:{}", (Object)initResult);
            throw new BusinessException("219001", initResult);
        }
        String reqJsonStr = JSONObject.toJSONString(reqMap);
        String enCodeStr = "";
        try {
            enCodeStr = RSATool.clientEncrypt((String)reqJsonStr, (String)this.publicKey);
        }
        catch (Exception e) {
            log.error("\u5584\u4ed8\u901a\u8bf7\u6c42\u62a5\u6587RSA\u52a0\u5bc6\u5931\u8d25");
            throw new BusinessException("219001", "\u5584\u4ed8\u901a\u8bf7\u6c42\u62a5\u6587RSA\u52a0\u5bc6\u5931\u8d25");
        }
        String data = "";
        try {
            data = URLEncoder.encode(enCodeStr, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String auth = MD5.getMD5((String)(this.thirdSysId + reqMap.get("TxCode") + data + this.md5Key), (String)"utf-8");
        SSLContext sslcontext = SftHttpClient.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        dataMap.put("ThirdSysID", this.thirdSysId);
        dataMap.put("Data", data);
        dataMap.put("TxCode", reqMap.get("TxCode").toString());
        dataMap.put("Auth", auth);
        String body = "";
        try {
            HttpPost httpPost = new HttpPost(this.requestUrl);
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set keySet = dataMap.keySet();
            for (String key : keySet) {
                nvps.add(new BasicNameValuePair(key, (String)dataMap.get(key)));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = null;
            try {
                response = client.execute((HttpUriRequest)httpPost);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HttpEntity rspEntity = response.getEntity();
            body = EntityUtils.toString((HttpEntity)rspEntity, (String)UTF_8);
            EntityUtils.consume((HttpEntity)entity);
            response.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return body;
    }

    private String init() {
        this.thirdSysId = this.payPropertiesVo.getSFTThirdSysId();
        if (StringUtils.isEmpty((Object)this.thirdSysId)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901a\u4e09\u65b9Id\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        this.requestUrl = this.payPropertiesVo.getSFTRequestUrl();
        if (StringUtils.isEmpty((Object)this.requestUrl)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901a\u8bf7\u6c42\u5730\u5740\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        this.md5Key = this.payPropertiesVo.getSFTMD5Key();
        if (StringUtils.isEmpty((Object)this.md5Key)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901amd5Key\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        this.publicKey = this.payPropertiesVo.getSFTPublicKey();
        if (StringUtils.isEmpty((Object)this.publicKey)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901apublicKey\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        return null;
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            assert (sc != null);
            sc.init(null, new TrustManager[]{x509TrustManager}, null);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    public String decodeU(String body) {
        this.init();
        String retBody = null;
        try {
            retBody = RSATool.clientDecrypt((String)body, (String)this.publicKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retBody;
    }

    public String decode(String body) {
        this.init();
        String decode = "";
        try {
            decode = URLDecoder.decode(body, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String retBody = null;
        try {
            retBody = RSATool.clientDecrypt((String)decode, (String)this.publicKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retBody;
    }

    public static byte[] inputStream2Byte(InputStream is) {
        int BUFFER_SIZE = 1024;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] date = new byte[BUFFER_SIZE];
        int len = -1;
        while (true) {
            try {
                len = is.read(date, 0, BUFFER_SIZE);
                if (-1 == len) {
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            os.write(date, 0, BUFFER_SIZE);
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFileByBytes(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

