/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.CreateFkMqBusiService;
import com.tydic.payment.pay.busi.CreatePayOrderService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.WXJsapiPayBusiService;
import com.tydic.payment.pay.busi.bo.CreateFkMqReqBo;
import com.tydic.payment.pay.busi.bo.CreateFkMqRspBo;
import com.tydic.payment.pay.busi.bo.CreatePayOrderReqBo;
import com.tydic.payment.pay.busi.bo.CreatePayOrderRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.WXJsapiPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXJsapiPayBusiRspBO;
import com.tydic.payment.pay.comb.WspPayCombService;
import com.tydic.payment.pay.comb.bo.WspPayComReqBO;
import com.tydic.payment.pay.comb.bo.WspPayComRspBO;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.comb.WspPayCombService"})
public class WspPayCombServiceImpl
implements WspPayCombService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private static final String SERVICE_NAME = "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u7ec4\u5408\u670d\u52a1";
    @Autowired
    private CreatePayOrderService createPayOrderService;
    @Autowired
    private WXJsapiPayBusiService wxJsapiPayBusiService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private CreateFkMqBusiService createFkMqBusiService;

    @PostMapping(value={"wspPay"})
    public WspPayComRspBO wspPay(@RequestBody WspPayComReqBO wspPayReqBO) {
        if (this.isDebug) {
            this.logger.debug("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u7ec4\u5408\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)wspPayReqBO));
        }
        WspPayComRspBO wspPayRspBO = null;
        try {
            this.checkReqData(wspPayReqBO);
            String orderId = this.createOrder(wspPayReqBO);
            try {
                Long.parseLong(orderId);
            }
            catch (Exception e) {
                this.logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u7ec4\u5408\u670d\u52a1 -> ");
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5c0f\u7a0b\u5e8f\u7ec4\u5408\u670d\u52a1 -> \u521b\u5efa\u8ba2\u5355\u5f02\u5e38\uff1a\u8fd4\u56de\u8ba2\u5355id\u9519\u8bef(" + orderId + ")");
            }
            wspPayRspBO = this.payUnifiedOrder(wspPayReqBO, orderId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u7ec4\u5408\u670d\u52a1 -> \u51fa\u53c2\uff1a" + JSON.toJSONString((Object)wspPayRspBO));
            }
            return wspPayRspBO;
        }
        catch (Exception e) {
            this.logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u7ec4\u5408\u670d\u52a1 -> \u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6216\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private WspPayComRspBO payUnifiedOrder(WspPayComReqBO reqBO, String orderId) throws Exception {
        WspPayComRspBO wspPayRspBO = new WspPayComRspBO();
        Map<String, Object> payParaMap = this.queryPayPara(reqBO.getMerchantId(), reqBO.getReqWay());
        String appId = payParaMap.get("applets_appid") + "";
        WXJsapiPayBusiReqBO wxJsapiPayBusiReqBO = new WXJsapiPayBusiReqBO();
        wxJsapiPayBusiReqBO.setOrderId(orderId);
        wxJsapiPayBusiReqBO.setMerchantId(reqBO.getMerchantId());
        wxJsapiPayBusiReqBO.setTotalFee(new BigDecimal(reqBO.getTotalFee()));
        wxJsapiPayBusiReqBO.setOpenid(reqBO.getOpenId());
        wxJsapiPayBusiReqBO.setParamMap(payParaMap);
        if ("4".equals(reqBO.getReqWay())) {
            wxJsapiPayBusiReqBO.setPayMethod("14");
        } else if ("5".equals(reqBO.getReqWay())) {
            wxJsapiPayBusiReqBO.setPayMethod("15");
        }
        WXJsapiPayBusiRspBO wxJsapiPayBusiRspBO = this.wxJsapiPayBusiService.dealWxJsapiPay(wxJsapiPayBusiReqBO);
        wspPayRspBO.setRspCode(wxJsapiPayBusiRspBO.getRspCode());
        wspPayRspBO.setRspName(wxJsapiPayBusiRspBO.getRspName());
        if (!"0000".equals(wxJsapiPayBusiRspBO.getRspCode())) {
            return wspPayRspBO;
        }
        wspPayRspBO.setAppId(appId);
        wspPayRspBO.setTimeStamp(wxJsapiPayBusiRspBO.getTimeStamp());
        wspPayRspBO.setNonceStr(wxJsapiPayBusiRspBO.getNonceStr());
        wspPayRspBO.setPackageBody(wxJsapiPayBusiRspBO.getPackage_());
        wspPayRspBO.setSignType(wxJsapiPayBusiRspBO.getSignType());
        wspPayRspBO.setPaySign(wxJsapiPayBusiRspBO.getPaySign());
        wspPayRspBO.setBusiId(reqBO.getBusiId());
        wspPayRspBO.setOutOrderId(reqBO.getOutOrderId());
        wspPayRspBO.setMerchantId(reqBO.getMerchantId());
        wspPayRspBO.setRemark(reqBO.getRemark());
        wspPayRspBO.setOrderAttrValue1(reqBO.getOrderAttrValue1());
        wspPayRspBO.setOrderAttrValue2(reqBO.getOrderAttrValue2());
        wspPayRspBO.setOrderAttrValue3(reqBO.getOrderAttrValue3());
        return wspPayRspBO;
    }

    private Map<String, Object> queryPayPara(String merchantId, String reqWay) {
        String payMethod = null;
        if ("4".equals(reqWay)) {
            payMethod = "14";
        }
        if ("5".equals(reqWay)) {
            payMethod = "15";
        }
        if (null == payMethod) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0d\u652f\u6301\u7684\u3010" + reqWay + "\u3011\u8bf7\u6c42\u65b9\u5f0f");
        }
        QueryCashierInfoPayParaAttrReqBo paraReqBO = new QueryCashierInfoPayParaAttrReqBo();
        paraReqBO.setMerchantId(merchantId);
        paraReqBO.setPayMethod(payMethod);
        QueryCashierInfoPayParaAttrRspBo paraRspBO = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReqBO);
        if (paraRspBO == null || !"0000".equals(paraRspBO.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraRspBO.getInfoPayParaAttrList() == null || paraRspBO.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        for (PayParaInfoAttrBo para : paraRspBO.getInfoPayParaAttrList()) {
            if (StringUtils.isEmpty((Object)para.getAttrCode()) || StringUtils.isEmpty((Object)para.getAttrValue())) continue;
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }

    private String createOrder(WspPayComReqBO reqBO) {
        CreatePayOrderReqBo createPorderReqBo = new CreatePayOrderReqBo();
        Map<String, String> contentMap = new HashMap(16);
        contentMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), Map.class);
        contentMap.put("orderType", "01");
        createPorderReqBo.setBusiId(reqBO.getBusiId());
        createPorderReqBo.setBusiCode(reqBO.getBusiCode());
        createPorderReqBo.setIp(reqBO.getIp());
        createPorderReqBo.setContentMap(contentMap);
        CreatePayOrderRspBo rspBO = this.createPayOrderService.createPorder(createPorderReqBo);
        if (!"0000".equals(rspBO.getRspCode())) {
            this.debugLog("\u521b\u5efa\u8ba2\u5355\u5931\u8d25\uff01", rspBO.getRspName());
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5c0f\u7a0b\u5e8f\u7ec4\u5408\u670d\u52a1 -> \u521b\u5efa\u8ba2\u5355\u5f02\u5e38\uff1a" + rspBO.getRspName());
        }
        CreateFkMqReqBo createFkMqReqBo = new CreateFkMqReqBo();
        createFkMqReqBo.setBusiId(Long.valueOf(Long.parseLong(rspBO.getBusiId())));
        createFkMqReqBo.setOrderId(Long.valueOf(Long.parseLong(rspBO.getOrderId())));
        createFkMqReqBo.setOutOrderId(rspBO.getOutOrderId());
        CreateFkMqRspBo createFkMqRspBo = this.createFkMqBusiService.createFk(createFkMqReqBo);
        if ("0000".equals(createFkMqRspBo.getRspCode())) {
            this.debugLog("\u5206\u5e93\u5efa\u5173\u8054 \u8fdb\u5165MQ\u961f\u5217\uff1a{}", createFkMqRspBo);
        }
        return rspBO.getOrderId();
    }

    private void checkReqData(WspPayComReqBO wspPayReqBO) {
        if (null == wspPayReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"4".equals(wspPayReqBO.getReqWay()) && !"5".equals(wspPayReqBO.getReqWay())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0d\u652f\u6301\u7684\u3010" + wspPayReqBO.getReqWay() + "\u3011\u8bf7\u6c42\u65b9\u5f0f");
        }
    }

    private void debugLog(String s, Object o) {
        if (this.isDebug) {
            this.logger.debug(s, o);
        }
    }
}

