/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import com.tydic.payment.pay.util.BeanUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliPayQrCodePayAbleImpl
extends AbstractAliPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(AliPayQrCodePayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_QR.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("212007");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        String aliNotifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            LOG.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("216006", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            LOG.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
            throw new BusinessException("216006", "\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradePrecreateRequest request = new AlipayTradePrecreateRequest();
        request.setNotifyUrl(aliNotifyUrl);
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_trade_no", "34719347923874891273489");
        dataMap.put("total_amount", MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        dataMap.put("subject", reqBo.getDetailName());
        dataMap.put("timeout_express", reqBo.getExtTime() + "m");
        dataMap.put("qr_code_timeout_express", reqBo.getExtTime() + "m");
        request.setBizContent(JSON.toJSONString(dataMap));
        AlipayTradePrecreateResponse response = null;
        try {
            response = (AlipayTradePrecreateResponse)alipayClient.execute((AlipayRequest)request);
            LOG.info("\u652f\u4ed8\u5b9d\u4e8c\u7ef4\u7801\u4e0b\u5355\u8fd4\u56de\u503c\u4e3a\uff1a" + (response != null ? JSON.toJSONString((Object)response) : "null"));
            if (response == null) {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                retBo.setRespCode("212007");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                return retBo;
            }
            if (!response.isSuccess()) {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                retBo.setRespCode("212007");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            String qrCode = response.getQrCode();
            BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
            retBo.setQrCodeUrl(qrCode);
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u4e8c\u7ef4\u7801\u4e0b\u5355\u6210\u529f");
        }
        catch (AlipayApiException e) {
            LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u4e8c\u7ef4\u7801\u4e0b\u5355\u5f02\u5e38\uff1a" + (Object)((Object)e));
            throw new BusinessException("216006", "\u8c03\u7528\u652f\u4ed8\u5b9d\u4e8c\u7ef4\u7801\u4e0b\u5355\u5f02\u5e38\uff1a" + (Object)((Object)e), (Throwable)e);
        }
        return retBo;
    }

    private String validateArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("3");
        }
        return null;
    }
}

