/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.PayProBillInsertToTransBusiService;
import com.tydic.payment.pay.busi.bo.PayProBillInsertToTransBusiServiceReqBo;
import com.tydic.payment.pay.busi.bo.PayProBillInsertToTransBusiServiceRspBo;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.PorderRefundTransMapper;
import com.tydic.payment.pay.dao.TransPaymentMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.dao.po.TransPaymentPO;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PayProBillInsertToTransBusiServiceImpl
implements PayProBillInsertToTransBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Value(value="${project_name}")
    private String projectName;
    @Autowired
    private TransPaymentMapper transPaymentMapper;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PorderRefundTransMapper porderRefundTransMapper;

    public PayProBillInsertToTransBusiServiceRspBo insertTrans(PayProBillInsertToTransBusiServiceReqBo reqBo) {
        PayProBillInsertToTransBusiServiceRspBo rspBo = PayProRspUtil.generateSucRspBo(PayProBillInsertToTransBusiServiceRspBo.class);
        List dataBos = reqBo.getDataBos();
        Map<String, PorderPayTransPo> payMap = this.queryPayOrder(dataBos);
        Map<String, PorderRefundTransPo> refundMap = this.queryRefundOrder(dataBos);
        ArrayList<TransPaymentPO> poList = new ArrayList<TransPaymentPO>(dataBos.size());
        for (PayBillAbleDownloadRspDataBo dataBo : dataBos) {
            if (!dataBo.getTypeOrderId().startsWith(this.projectName)) {
                this.LOGGER.info("\u8be5\u8ba2\u5355\u3010{}\u3011\u4e0d\u662f\u672c\u73af\u5883\u7684\u8ba2\u5355\uff0c\u6545\u4e0d\u8bb0\u5f55", (Object)dataBo.getTypeOrderId());
                continue;
            }
            TransPaymentPO insertPo = new TransPaymentPO();
            BeanUtils.copyProperties((Object)dataBo, (Object)insertPo);
            insertPo.setId(PayProSequence.nextId());
            if ("01".equals(dataBo.getOrderType())) {
                if (payMap.get(dataBo.getTypeOrderId()) != null) {
                    insertPo.setBusiId(payMap.get(dataBo.getTypeOrderId()).getBusiId());
                    insertPo.setOrderId(payMap.get(dataBo.getTypeOrderId()).getOrderId());
                }
            } else if ("02".equals(dataBo.getOrderType()) && refundMap.get(dataBo.getTypeOrderId()) != null) {
                insertPo.setBusiId(refundMap.get(dataBo.getTypeOrderId()).getBusiId());
                insertPo.setOrderId(refundMap.get(dataBo.getTypeOrderId()).getOrderId());
            }
            if (dataBo.getPaymentInsObj() != null) {
                insertPo.setPaymentInsValueJson(JSON.toJSONString((Object)dataBo.getPaymentInsObj()));
            }
            poList.add(insertPo);
        }
        if (!CollectionUtils.isEmpty(poList)) {
            int n = this.transPaymentMapper.insertBatch(poList);
        }
        return rspBo;
    }

    private Map<String, PorderRefundTransPo> queryRefundOrder(List<PayBillAbleDownloadRspDataBo> dataBos) {
        List<String> refundDatas = dataBos.stream().filter(data -> "02".equals(data.getOrderType())).map(PayBillAbleDownloadRspDataBo::getTypeOrderId).collect(Collectors.toList());
        HashMap<String, PorderRefundTransPo> refundMap = new HashMap<String, PorderRefundTransPo>(refundDatas.size());
        if (refundDatas.isEmpty()) {
            return refundMap;
        }
        List<PorderRefundTransPo> porderRefundTransPos = this.porderRefundTransMapper.queryOrderByRefundIds(refundDatas);
        for (PorderRefundTransPo transPo : porderRefundTransPos) {
            refundMap.put(transPo.getRefundOrderId(), transPo);
        }
        return refundMap;
    }

    private Map<String, PorderPayTransPo> queryPayOrder(List<PayBillAbleDownloadRspDataBo> dataBos) {
        List<String> payDatas = dataBos.stream().filter(data -> "01".equals(data.getOrderType())).map(PayBillAbleDownloadRspDataBo::getTypeOrderId).collect(Collectors.toList());
        HashMap<String, PorderPayTransPo> payMap = new HashMap<String, PorderPayTransPo>(payDatas.size());
        if (payDatas.isEmpty()) {
            return payMap;
        }
        List<PorderPayTransPo> porderPayTransPos = this.porderPayTransMapper.listOrdersByPayOrderList(payDatas);
        for (PorderPayTransPo transPo : porderPayTransPos) {
            payMap.put(transPo.getPayOrderId(), transPo);
        }
        return payMap;
    }
}

